package com.elitesland.tw.tw5.server.common.permission.annotation;

import com.elitesland.tw.tw5.server.common.permission.enums.ClientTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;

import java.lang.annotation.*;

/**
 * 权限控制接口 注解
 *
 * @author : JS
 * @date 2023/09/21
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface FunctionDetail {

    /**
     * 功能代码
     */
    FunctionCodeEnum functionCode();

    /**
     * 功能名称
     */
    String name() default "";

    /**
     * 枚举类，功能类型
     */
    FunctionTypeEnum type();

    /**
     * 客户端类型
     */
    ClientTypeEnum clientType() default ClientTypeEnum.PC;

    /**
     * 将功能提供给其他业务对象
     * <p>
     * 例如 商机业务对象需要用到合同列表功能，则在合同列表功能中指定 referDomain = PermissionDomainEnum.BUSINESS_OPPORTUNITY
     */
    PermissionDomainEnum[] referDomain() default {};

}
