package com.elitesland.tw.tw5.server.log.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.dto.ApiRequestLogQuery;
import com.elitesland.tw.tw5.server.log.entity.ApiRequestLogDO;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 第三方api请求日志控制器
 *
 * @author duwh
 * @date 2022/11/12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/request")
@Slf4j
public class ApiRequestLogController {

    private final ApiRequestLogService service;

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/log/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            //return TwOutputUtil.error("", "权限不足", null);
            return TwOutputUtil.ok();
        }
        ApiRequestLogDO entity = service.queryByKey(key);
        return TwOutputUtil.ok(entity);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/log/paging")
    public TwOutputUtil paging(ApiRequestLogQuery query) {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            //return TwOutputUtil.error("", "权限不足", null);
            return TwOutputUtil.ok();
        }
        PagingVO<ApiRequestLogDO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 日志类型列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/log/logTypeList")
    public TwOutputUtil logTypeList() {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            //return TwOutputUtil.error("", "权限不足", null);
            return TwOutputUtil.ok();
        }
        final List<ApiRequestLogTypeEnum> enumList = EnumUtils.getEnumList(ApiRequestLogTypeEnum.class);
        return TwOutputUtil.ok(enumList.stream().map(apiRequestLogTypeEnum -> {
            HashMap map = new HashMap(2);
            map.put("code",apiRequestLogTypeEnum.getCode());
            map.put("desc",apiRequestLogTypeEnum.getDesc());
            return map;
        }).collect(Collectors.toList()));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/log/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            service.deleteSoft(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }

    /**
     * 物理删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/log/delete")
    public TwOutputUtil delete(Long[] keys) {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            service.delete(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }


}
