package com.elitesland.tw.tw5.server.log.service;

import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogChannelEnum;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.dto.ApiRequestLogQuery;
import com.elitesland.tw.tw5.server.log.entity.ApiRequestLogDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 接口请求日志记录服务
 *
 * @author duwh
 * @date 2022/11/10
 */
public interface ApiRequestLogService {

    /**
     * 保存日志
     *
     * @param type          类型
     * @param channel       通道
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     * @param remark        备注
     */
    void saveLog(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark);

    /**
     * 保存日志
     *
     * @param type          类型
     * @param channel       通道
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     * @param remark        备注
     * @param ext1          ext1
     * @param ext2          ext2
     * @param ext3          ext3
     * @param ext4          ext4
     */
    void saveLog(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark, String ext1, String ext2, String ext3, String ext4);

    /**
     * 保存日志
     *
     * @param logDO 日志做
     */
    void saveLog(ApiRequestLogDO logDO);

    /**
     * 保存调用外部系统日志记录
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     */
    void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status);

    /**
     * 节省了日志
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        头
     * @param result        结果
     * @param status        状态
     * @param time          时间
     */
    @Async
    void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status,Long time);

    /**
     * 节省了日志
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        头
     * @param result        结果
     * @param status        状态
     * @param time          时间
     * @param docId          业务id
     */
    void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, Long time, String docId);
    /**
     * 保存调用外部系统日志记录
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     * @param remark        备注
     */
    void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark);


    /**
     * 保存外部系统调入日志
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     */
    void saveInLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status);

    /**
     * 保存外部系统调入日志
     *
     * @param type          类型
     * @param uri           uri
     * @param requestMethod 请求方法
     * @param param         参数
     * @param header        请求头
     * @param result        结果
     * @param status        状态
     * @param remark        备注
     */
    void saveInLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark);

    /**
     * 查询关键
     *
     * @param key 关键
     * @return {@link ApiRequestLogDO}
     */
    ApiRequestLogDO queryByKey(Long key);

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link ApiRequestLogDO}>
     */
    PagingVO<ApiRequestLogDO> paging(ApiRequestLogQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 键
     */
    void deleteSoft(List<Long> keys);


    /**
     * 删除
     *
     * @param keys 键
     */
    void delete(List<Long> keys);
}
