package com.elitesland.tw.tw5.server.prd.borrow.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
@Entity
@Table(name = "transfer_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "transfer_apply", comment = "出让申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TransferApplyDO extends BaseModel implements Serializable  {
    /** 借款ID */
    @Comment("借款ID")
    @Column()
    private Long borrowId;
    /** 出让名称 */
    @Comment("出让名称")
    @Column()
    private String transferName;
    /** 出让人ID */
    @Comment("出让人ID")
    @Column()
    private Long transferUserId;
    /** 出让日期 */
    @Comment("出让日期")
    @Column()
    private LocalDate transferDate;
    /** 出让人所属bu */
    @Comment("出让人所属bu")
    @Column()
    private Long transferBuId;
    /** 费用BU */
    @ApiModelProperty("费用BU")
    @Comment("费用BU")
    @Column()
    private Long costBuId;
    /** 受让人ID */
    @Comment("受让人ID")
    @Column()
    private Long receiveUserId;
    /** 受让人所属bu */
    @Comment("受让人所属bu")
    @Column()
    private Long receiveBuId;
    /** 出让原因 */
    @Comment("出让原因")
    @Column()
    private String transferReason;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字4 */
    @Comment("扩展字4")
    @Column()
    private String ext4;
    /** 扩展字5 */
    @Comment("扩展字5")
    @Column()
    private String ext5;

    public void copy(TransferApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
