package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalSettlePricePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalSettlePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalSettlePriceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalSettlePriceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalSettlePriceConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalSettlePriceDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalSettlePriceDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalSettlePriceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalSettlePriceServiceImpl extends BaseServiceImpl implements CalSettlePriceService {

    private final CalSettlePriceRepo calSettlePriceRepo;
    private final CalSettlePriceDAO calSettlePriceDAO;

    @Override
    public PagingVO<CalSettlePriceVO> queryPaging(CalSettlePriceQuery query) {
        PagingVO<CalSettlePriceVO> CalSettlePriceVOPagingVO = calSettlePriceDAO.queryPaging(query);
        if (CalSettlePriceVOPagingVO.getTotal() > 0) {
            CalSettlePriceVOPagingVO.getRecords().forEach(this::translateData);
        }
        return CalSettlePriceVOPagingVO;
    }

    @Override
    public List<CalSettlePriceVO> queryListDynamic(CalSettlePriceQuery query) {
        return calSettlePriceDAO.queryListDynamic(query);
    }

    @Override
    public CalSettlePriceVO queryByKey(Long key) {
        CalSettlePriceVO CalSettlePriceVO = calSettlePriceDAO.queryByKey(key);
        translateData(CalSettlePriceVO);
        return CalSettlePriceVO;
    }

    /**
     * 数据翻译
     *
     * @param CalSettlePriceVO
     */
    void translateData(CalSettlePriceVO CalSettlePriceVO) {
        if (CalSettlePriceVO.getFinYear() != null && CalSettlePriceVO.getFinPeriod() != null) {
            String finPeriodName = CalSettlePriceVO.getFinYear() + "-" + (CalSettlePriceVO.getFinPeriod() > 9 ? ("" + CalSettlePriceVO.getFinPeriod()) : ("0" + CalSettlePriceVO.getFinPeriod()));
            CalSettlePriceVO.setFinPeriodName(finPeriodName);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalSettlePriceVO insertOrUpdate(CalSettlePricePayload payload) {
        //数据校验
        checkDate(payload);
        CalSettlePriceDO entityDo = CalSettlePriceConvert.INSTANCE.toDo(payload);
        return CalSettlePriceConvert.INSTANCE.toVo(calSettlePriceRepo.save(entityDo));
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    void checkDate(CalSettlePricePayload payload) {
        if (payload.getFinPeriod() != null && payload.getFinYear() == null) {
            throw TwException.error("", "期间存在，年度不可为空");
        }
        if (StringUtils.hasText(payload.getJobType2()) && !StringUtils.hasText(payload.getJobType1())) {
            throw TwException.error("", "工种子类存在，工种不可为空");
        }
        CalSettlePriceQuery CalSettlePriceQuery = CalSettlePriceConvert.INSTANCE.toQuery(payload);
        List<Long> longs = calSettlePriceDAO.queryCheckData(CalSettlePriceQuery);
        if (!ObjectUtils.isEmpty(longs)) {
            if (payload.getId() == null || longs.size() > 1 || !longs.get(0).equals(payload.getId())) {
                throw TwException.error("", "存在相同结算定价");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            calSettlePriceDAO.deleteSoft(keys);
        }
    }

    @Override
    public CalSettlePriceVO getSettlePricePlus(CalSettlePriceQuery query) {

        return calSettlePriceDAO.getSettlePricePlus(query);
    }

}
