package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustOperInfoSysQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustOperInfoSysVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustOperInfoSysDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

@Repository
@RequiredArgsConstructor
public class CrmCustOperInfoSysDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmCustOperInfoSysDO infoSysDO = QCrmCustOperInfoSysDO.crmCustOperInfoSysDO;


    private JPAQuery<CrmCustOperInfoSysVO> getJpaQuerySelect() {
        JPAQuery<CrmCustOperInfoSysVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustOperInfoSysVO.class,
                infoSysDO.operId,
                infoSysDO.sysType,
                infoSysDO.sysName,
                infoSysDO.belongCompany,
                infoSysDO.implScope,
                infoSysDO.sysFunc,
                infoSysDO.onlineTime,
                infoSysDO.id,
                infoSysDO.remark,
                infoSysDO.sysVersion
        )).from(infoSysDO);
        return jpaQuery;
    }


    /**
     * 列表查询
     *
     * @return
     */
    public PagingVO<CrmCustOperInfoSysVO> paging(CrmCustOperInfoSysQuery query) {
        JPAQuery<CrmCustOperInfoSysVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(infoSysDO.deleteFlag.eq(0)).where(infoSysDO.operId.eq(query.getOperId()));
        // 动态排序
        QueryResults<CrmCustOperInfoSysVO> result = jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmCustOperInfoSysVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

}
