package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmFollowConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmFollowRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmFollowDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmFollowRepo repo;
    private final QCrmFollowDO qdo = QCrmFollowDO.crmFollowDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmFollowDO save(CrmFollowDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmFollowDO> saveAll(List<CrmFollowDO> dos) {
        return repo.saveAll(dos);
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }



    public List<CrmFollowDO> queryByObjectIdAndObjectType(Long objectId, String followObjectType) {
        return repo.findByObjectIdAndFollowObjectOrderByCreateTimeDesc(objectId,followObjectType);
    }
    public List<CrmFollowDO> queryByObjectIdsAndObjectType(List<Long> objectIds, String followObjectType) {
        return repo.findByObjectIdInAndFollowObjectOrderByCreateTimeDesc(objectIds,followObjectType);
    }

    public PagingVO<CrmFollowVO> listPage(CrmFollowQuery query) {
        final BooleanExpression expression = where(query);
        final Page<CrmFollowDO> page = repo.findAll(expression, query.getPageRequest());
        List<CrmFollowDO> content = page.getContent();
        List<CrmFollowVO> collect = content.stream().map(e -> CrmFollowConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
        //类型转化
        PagingVO<CrmFollowVO> pagingVO = new PagingVO<>(page.getTotalElements(), collect);
        return pagingVO;
    }

    public List<CrmFollowVO> list(CrmFollowQuery query) {
        final BooleanExpression expression = where(query);
        final Iterable<CrmFollowDO> iterable = repo.findAll(expression,query.getPageRequest().getSort());
        final Iterator<CrmFollowDO> iterator = iterable.iterator();
        List<CrmFollowVO> list = new ArrayList<>();
        while (iterator.hasNext()){
            list.add(CrmFollowConvert.INSTANCE.toVo(iterator.next()));
        }
        return list;
    }

    private BooleanExpression where(CrmFollowQuery query) {
        QCrmFollowDO q = QCrmFollowDO.crmFollowDO;
        BooleanExpression expression = q.deleteFlag.eq(0);
        if(StringUtils.hasText(query.getFollowType())){
            expression = expression.and(q.followType.eq(query.getFollowType()));
        }
        if(StringUtils.hasText(query.getFollowObject())){
            expression = expression.and(q.followObject.eq(query.getFollowObject()));
        }
        if (null != query.getObjectId()) {
            expression = expression.and(q.objectId.eq(query.getObjectId()));
        }
        if (null != query.getCreateTimeStart()) {
            expression = expression.and(q.createTime.goe(query.getCreateTimeStart()));
        }
        if (null != query.getCreateTimeEnd()) {
            expression = expression.and(q.createTime.loe(query.getCreateTimeEnd()));
        }
        //if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
        //    //大于或等于开始时间
        //    predicates.add(cb.greaterThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), query.getCreateTimeStart()));
        //}
        //if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
        //    //小于或等于结束时间
        //    predicates.add(cb.lessThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), query.getCreateTimeEnd()));
        //}
        return expression;
    }

    public void updateByKeyDynamic(CrmFollowPayload payload) {
        //查询出当前的do
        CrmFollowDO followDO = repo.findById(payload.getId()).orElse(null);
        if(followDO!=null){
            if(payload.getFollowType()!=null){
                followDO.setFollowType(payload.getFollowType());
            }
            if(payload.getFileCodes()!=null){
                followDO.setFileCodes(payload.getFileCodes());
            }
            if(payload.getFollowContent()!=null){
                followDO.setFollowContent(payload.getFollowContent());
            }
            // 处理要设置成空的字段
            List<String> nullFields = payload.getNullFields();
            if (nullFields != null && nullFields.size() > 0) {

            }
            repo.save(followDO);
        }
    }

    /**
     * 根据线索id集合以及类型查询最新更进
     * @param objectIds
     * @param followObject
     * @return
     */
    public List<CrmFollowVO> findLastFollowByObjectIds(List<Long> objectIds,String followObject) {
        JPAQuery<CrmFollowVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmFollowVO.class,
                qdo.id,
                qdo.objectId,
                qdo.createTime,
                qdo.followType,
                qdo.followContent
        )).from(qdo)
                .where(qdo.objectId.in(objectIds)
                        .and(qdo.followObject.eq(followObject))
                        .and(qdo.deleteFlag.eq(0)))
                .groupBy(qdo.objectId)
                .orderBy(qdo.objectId.desc(),qdo.createTime.desc());
        return jpaQuery.fetch();
    }
    public long countByObjectIdsAndObjectType(List<Long> objectIds, String followObjectType) {
        return repo.countByObjectIdInAndFollowObject(objectIds,followObjectType);
    }
}
