package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 客户经营-经营团队成员
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation_member", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_member", comment = " 客户经营-经营团队成员")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationMemberDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 7655285261129870145L;

    @Comment("客户经营主键 crm_customer_operation.id")
    @Column()
    private Long operId;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name="operId",referencedColumnName="id",insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    //@org.hibernate.annotations.ForeignKey(name = "none")
    private CrmCustomerOperationDO operObj;

    @Comment("类型 TEMP 临时授权人员 ...")
    @Column()
    private String type;

    @Comment("类型名称")
    @Column()
    private String typeName;

    @Comment("用户id")
    @Column()
    private Long userId;

    @Comment("用户名字 冗余")
    @Column()
    private String userName;

    @Comment("授权开始时间")
    @Column()
    private LocalDateTime startTime;

    @Comment("授权开始结束")
    @Column()
    private LocalDateTime endTime;

    @Column(
        name = "disabled_flag",
        columnDefinition = "int(10) default '0' comment '禁用标记，0：未禁用，1：已禁用' "
    )
    private Integer disabledFlag = 0;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public CrmCustomerOperationMemberDO() {
    }

    public void copy(CrmCustomerOperationMemberDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
