package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdIndividAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdIndividAbilityVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力
 */

@RestController
@RequestMapping("/api/prdIndividAbility")
@RequiredArgsConstructor
@Api(value = "单项能力", tags = {"单项能力"})
public class PrdIndividAbilityController {

    private final PrdIndividAbilityService prdIndividAbilityService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-单项能力")
    public TwOutputUtil<PrdIndividAbilityVO> get(@PathVariable Long id) {

        PrdIndividAbilityVO res = prdIndividAbilityService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-单项能力")
    public TwOutputUtil<Long> save(@RequestBody PrdIndividAbilityPayload prdIndividAbilityPayload) {

        PrdIndividAbilityVO res = prdIndividAbilityService.save(prdIndividAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-单项能力")
    public TwOutputUtil<Long> update(@RequestBody PrdIndividAbilityPayload prdIndividAbilityPayload) {

        PrdIndividAbilityVO res = prdIndividAbilityService.update(prdIndividAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-单项能力")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdIndividAbilityService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-单项能力")
    public TwOutputUtil<PagingVO<PrdIndividAbilityVO>> page(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        PagingVO<PrdIndividAbilityVO> res = prdIndividAbilityService.page(prdIndividAbilityQuery);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("updateShow")
    @ApiOperation("修改-单项能力显示")
    public TwOutputUtil<Long> updateShow(@RequestBody PrdIndividAbilityPayload prdIndividAbilityPayload) {

        Long res = prdIndividAbilityService.updateShow(prdIndividAbilityPayload);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("updateState")
    @ApiOperation("修改-单项能力状态")
    public TwOutputUtil<Long> updateState(@RequestBody PrdIndividAbilityPayload prdIndividAbilityPayload) {

        Long res = prdIndividAbilityService.updateState(prdIndividAbilityPayload);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/levelPage")
    @UdcNameClass
    @ApiOperation("单项能力-级别定义明细的分页查询")
    public TwOutputUtil<PagingVO<PrdIndividAbilityVO>> levelPage(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        PagingVO<PrdIndividAbilityVO> res = prdIndividAbilityService.levelPage(prdIndividAbilityQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/levelList")
    @UdcNameClass
    @ApiOperation("单项能力-级别定义明细的列表查询")
    public TwOutputUtil<List<PrdIndividAbilityVO>> levelList(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        List<PrdIndividAbilityVO> res = prdIndividAbilityService.levelList(prdIndividAbilityQuery);
        return TwOutputUtil.ok(res);

    }

}

