package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamRangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamRangeDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核范围RepoProc
 */

@Component
public class PrdPerformanceExamRangeDao extends BaseRepoProc<PrdPerformanceExamRangeDO> {

    private static final QPrdPerformanceExamRangeDO qPrdPerformanceExamRangeDO = QPrdPerformanceExamRangeDO.prdPerformanceExamRangeDO;


    protected PrdPerformanceExamRangeDao() {

        super(qPrdPerformanceExamRangeDO);

    }


    public PagingVO<PrdPerformanceExamRangeVO> page(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        JPAQuery<PrdPerformanceExamRangeVO> query =
                select(PrdPerformanceExamRangeVO.class)
                        .where(bulidPredicate(prdPerformanceExamRangeQuery));
        prdPerformanceExamRangeQuery.setPaging(query);
        prdPerformanceExamRangeQuery.fillOrders(query, qPrdPerformanceExamRangeDO);
        return PagingVO.<PrdPerformanceExamRangeVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdPerformanceExamRangeDO)
                .set(qPrdPerformanceExamRangeDO.deleteFlag, 1)
                .where(qPrdPerformanceExamRangeDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdPerformanceExamRangeVO get(Long id) {

        PrdPerformanceExamRangeVO prdPerformanceExamRangeVO = select(PrdPerformanceExamRangeVO.class)
                .where(qPrdPerformanceExamRangeDO.id.eq(id))
                .fetchOne();

        return prdPerformanceExamRangeVO;

    }


    public List<PrdPerformanceExamRangeVO> getList(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        List<PrdPerformanceExamRangeVO> res =
                select(PrdPerformanceExamRangeVO.class)
                        .where(bulidPredicate(prdPerformanceExamRangeQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdPerformanceExamRangeDO.examId,
                        qPrdPerformanceExamRangeDO.userId,
                        qPrdPerformanceExamRangeDO.resId,
                        qPrdPerformanceExamRangeDO.resName,
                        qPrdPerformanceExamRangeDO.buId,
                        qPrdPerformanceExamRangeDO.buName,
                        qPrdPerformanceExamRangeDO.enrollDate,
                        qPrdPerformanceExamRangeDO.resType,
                        qPrdPerformanceExamRangeDO.coopType,
                        qPrdPerformanceExamRangeDO.id,
                        qPrdPerformanceExamRangeDO.createTime,
                        qPrdPerformanceExamRangeDO.remark

                )).from(qPrdPerformanceExamRangeDO);

    }


    private Predicate bulidPredicate(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdPerformanceExamRangeQuery.getExamId(), qPrdPerformanceExamRangeDO.examId, prdPerformanceExamRangeQuery.getExamId())
                .andEq(null != prdPerformanceExamRangeQuery.getUserId(), qPrdPerformanceExamRangeDO.userId, prdPerformanceExamRangeQuery.getUserId())
                .andEq(null != prdPerformanceExamRangeQuery.getResId(), qPrdPerformanceExamRangeDO.resId, prdPerformanceExamRangeQuery.getResId())
                .andEq(null != prdPerformanceExamRangeQuery.getBuId(), qPrdPerformanceExamRangeDO.buId, prdPerformanceExamRangeQuery.getBuId())
                .andEq(null != prdPerformanceExamRangeQuery.getEnrollDate(), qPrdPerformanceExamRangeDO.enrollDate, prdPerformanceExamRangeQuery.getEnrollDate())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamRangeQuery.getResType()), qPrdPerformanceExamRangeDO.resType, prdPerformanceExamRangeQuery.getResType())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamRangeQuery.getCoopType()), qPrdPerformanceExamRangeDO.coopType, prdPerformanceExamRangeQuery.getCoopType())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 绩效考核id
        if (null != prdPerformanceExamRangeQuery.getExamId()) {
            predicates.add(qPrdPerformanceExamRangeDO.examId.eq(prdPerformanceExamRangeQuery.getExamId()));
        }
        // 用户id
        if (null != prdPerformanceExamRangeQuery.getUserId()) {
            predicates.add(qPrdPerformanceExamRangeDO.userId.eq(prdPerformanceExamRangeQuery.getUserId()));
        }
        // 资源id
        if (null != prdPerformanceExamRangeQuery.getResId()) {
            predicates.add(qPrdPerformanceExamRangeDO.resId.eq(prdPerformanceExamRangeQuery.getResId()));
        }
        // buid
        if (null != prdPerformanceExamRangeQuery.getBuId()) {
            predicates.add(qPrdPerformanceExamRangeDO.buId.eq(prdPerformanceExamRangeQuery.getBuId()));
        }
        // 入职时间
        if (null != prdPerformanceExamRangeQuery.getEnrollDate()) {
            predicates.add(qPrdPerformanceExamRangeDO.enrollDate.eq(prdPerformanceExamRangeQuery.getEnrollDate()));
        }
        // 资源类型
        if (StringUtils.isNotEmpty(prdPerformanceExamRangeQuery.getResType())) {
            predicates.add(qPrdPerformanceExamRangeDO.resType.eq(prdPerformanceExamRangeQuery.getResType()));
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdPerformanceExamRangeQuery.getCoopType())) {
            predicates.add(qPrdPerformanceExamRangeDO.coopType.eq(prdPerformanceExamRangeQuery.getCoopType()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        long res = select(PrdPerformanceExamRangeVO.class)
                .where(bulidPredicate(prdPerformanceExamRangeQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamRangeDO);

        // 绩效考核id
        if (null != prdPerformanceExamRangePayload.getExamId()) {
            update.set(qPrdPerformanceExamRangeDO.examId, prdPerformanceExamRangePayload.getExamId());
        }
        // 用户id
        if (null != prdPerformanceExamRangePayload.getUserId()) {
            update.set(qPrdPerformanceExamRangeDO.userId, prdPerformanceExamRangePayload.getUserId());
        }
        // 资源id
        if (null != prdPerformanceExamRangePayload.getResId()) {
            update.set(qPrdPerformanceExamRangeDO.resId, prdPerformanceExamRangePayload.getResId());
        }
        // buid
        if (null != prdPerformanceExamRangePayload.getBuId()) {
            update.set(qPrdPerformanceExamRangeDO.buId, prdPerformanceExamRangePayload.getBuId());
        }
        // 入职时间
        if (null != prdPerformanceExamRangePayload.getEnrollDate()) {
            update.set(qPrdPerformanceExamRangeDO.enrollDate, prdPerformanceExamRangePayload.getEnrollDate());
        }
        // 资源类型
        if (StringUtils.isNotEmpty(prdPerformanceExamRangePayload.getResType())) {
            update.set(qPrdPerformanceExamRangeDO.resType, prdPerformanceExamRangePayload.getResType());
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdPerformanceExamRangePayload.getCoopType())) {
            update.set(qPrdPerformanceExamRangeDO.coopType, prdPerformanceExamRangePayload.getCoopType());
        }
        long res = update.where(qPrdPerformanceExamRangeDO.id.eq(prdPerformanceExamRangePayload.getId()))
                .execute();
        return res;

    }

    public Long delByExamId(Long id) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamRangeDO);
        long res = update.set(qPrdPerformanceExamRangeDO.deleteFlag, 1)
                .where(qPrdPerformanceExamRangeDO.examId.eq(id))
                .execute();

        return res;
    }

}

