package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonEduExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonEduExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonEduExperienceRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonEduExperienceDAO {

    private final PersonEduExperienceRepo personEduExperienceRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonEduExperienceDO personEduExperienceDO = QPersonEduExperienceDO.personEduExperienceDO;

    public List<PersonEduExperienceDO> findAllByPersonId(Long personId) {
        return personEduExperienceRepo.findAllByPersonId(personId);
    }

    public void deleteAllByPersonId(Long personId) {
        jpaQueryFactory.update(personEduExperienceDO)
                .set(personEduExperienceDO.deleteFlag, 1)
                .where(personEduExperienceDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonEduExperienceDO> personEduExperienceDOS) {
        personEduExperienceRepo.saveAll(personEduExperienceDOS);
    }

}
