package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResEntryExitLogQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEntryExitLogVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QResEntryExitLogDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.ResEntryExitLogDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.ResEntryExitLogRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class ResEntryExitLogDAO {

    private final ResEntryExitLogRepo resEntryExitLogRepo;

    private final QResEntryExitLogDO resEntryExitLogDO = QResEntryExitLogDO.resEntryExitLogDO;

    private final JPAQueryFactory jpaQueryFactory;

    public List<ResEntryExitLogDO> findAllByEmployeeId(Long employeeId) {
        return resEntryExitLogRepo.findAllByEmployeeId(employeeId);
    }

    public void save(ResEntryExitLogDO resEntryExitLogDO) {
        resEntryExitLogRepo.save(resEntryExitLogDO);
    }

    private JPAQuery<ResEntryExitLogVO> getJpaQueryWhere(ResEntryExitLogQuery query) {
        JPAQuery<ResEntryExitLogVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getEmployeeId())) {
            jpaQuery.where(resEntryExitLogDO.employeeId.eq(query.getEmployeeId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, resEntryExitLogDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(resEntryExitLogDO, query.getOrders()));
        return jpaQuery;
    }

    public JPAQuery<ResEntryExitLogVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ResEntryExitLogVO.class,
                        resEntryExitLogDO.entryExitDate,
                        resEntryExitLogDO.employeeId,
                        resEntryExitLogDO.logNo,
                        resEntryExitLogDO.id,
                        resEntryExitLogDO.baseCity,
                        resEntryExitLogDO.bookId,
                        resEntryExitLogDO.coopType,
                        resEntryExitLogDO.job,
                        resEntryExitLogDO.leaveReason,
                        resEntryExitLogDO.leaveReasonDesc,
                        resEntryExitLogDO.reasonType1,
                        resEntryExitLogDO.reasonType2,
                        resEntryExitLogDO.resClass,
                        resEntryExitLogDO.resType,
                        resEntryExitLogDO.reasonId,
                        resEntryExitLogDO.orgId)
                ).from(resEntryExitLogDO)
                .where(resEntryExitLogDO.deleteFlag.eq(0));
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ResEntryExitLogVO> queryPaging(ResEntryExitLogQuery query) {
        JPAQuery<ResEntryExitLogVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<ResEntryExitLogVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<ResEntryExitLogVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
