package com.elitesland.tw.tw5.server.prd.inv.config;

import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;


/**
 * 发票(百望)
 *
 * @ Author: ssy
 * @ Date: 2020/5/8
 * @ Description:
 */
@Data
@Component
@ConfigurationProperties("baiwang")
// 支持动态刷新
@NacosConfigurationProperties(dataId = "baiwang", autoRefreshed = true)
public class TwInvoiceProperties {

    //接口地址
    String url="xxx";
    //AppKey
    String appKey="xxx";
    //AppSecrect
    String appSecret="xxx";
    //用户名
    String userName="xxx";
    //密码
    String password="xxx";
    //盐值
    String userSalt="xxx";
    //销方税号
    String sellerTaxNo="xxx";

    // 租户ID
    String telantId="xxx";
    // 组织FLAG
    String organizationFlag="xxx";

    //单张发票最大开票金额(若未配置，则默认 999999)
    BigDecimal maxInvAmt=BigDecimal.valueOf(999999);
}
