package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.PmsTimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/timesheet")
@Slf4j
@Deprecated
public class TimesheetController {

    private final TimesheetService timesheetService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;

    /**
     * 批量插入 传入id就是编辑
     * <p>
     * see PmsTimesheetService.batchInsert
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/batchInsert")
    @Deprecated
    public TwOutputUtil batchInsert(@RequestBody TimesheetListPayload payload) {
        return TwOutputUtil.ok(timesheetService.batchInsert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @Deprecated
    public TwOutputUtil update(@RequestBody TimesheetPayload payload) {
        return TwOutputUtil.ok(timesheetService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(timesheetService.queryByKey(key));
    }

    /**
     * 分页
     * 默认按创建时间倒序，前端可通过参数改变排序
     * 管理员、TIME_SHEET_MANAGER查看所有
     * 普通用户只能查看自己填写的
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @Deprecated
    public TwOutputUtil paging(TimesheetQuery query) {
        final PagingVO<TimesheetVO> paging1 = timesheetService.paging(query);
        return TwOutputUtil.ok(paging1);
    }

    /**
     * 查询列表
     * 默认按创建时间倒序，前端可通过参数改变排序
     * 管理员、TIME_SHEET_MANAGER查看所有
     * 普通用户只能查看自己填写的
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @Deprecated
    public TwOutputUtil queryList(TimesheetQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        //final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        //if (isSystemAdmin) {
        //
        //} else {
        //    // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
        //    List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
        //    if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
        //
        //    } else {
        // 数据权限 只能查自己的
        query.setTsUserId(loginUserId);
        //    }
        //}
        return TwOutputUtil.ok(timesheetService.queryList(query));
    }

    /**
     * 工时列表变更审批人
     *
     * @param keys
     * @param apprUserId
     * @return
     */
    @PatchMapping("/updateApproving/{apprUserId}")
    public TwOutputUtil updateApprovingUser(@RequestBody List<Long> keys, @PathVariable Long apprUserId) {
        timesheetService.updateApprovingUser(keys, apprUserId);
        return TwOutputUtil.ok();
    }

    /**
     * 查询工时状态
     */
    @GetMapping("/getTimesheetOverview")
    @UdcNameClass
    public TwOutputUtil getTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok(timesheetService.getTimesheetOverview(query));
    }

    /**
     * 检查工时是否填满
     */
    @GetMapping("/checkMonthlyTimesheet")
    @UdcNameClass
    public TwOutputUtil checkMonthlyTimesheet(@RequestParam String checkDate) {
        return TwOutputUtil.ok(timesheetService.checkMonthlyTimesheet(checkDate));
    }


    /**
     * 待审批工时条数
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/count")
    public TwOutputUtil approvingCount(TimesheetQuery query) {
        //if (!StringUtils.hasText(query.getTsStatus())) {
        //    query.setTsStatus("APPROVING");
        //}
        query.setApprUserId(GlobalUtil.getLoginUserId());
        long total = timesheetService.count(query);
        return TwOutputUtil.ok(total);
    }

    /**
     * 待审批列表-分页
     * 默认按创建时间倒序，前端可通过参数改变排序
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/paging")
    @UdcNameClass
    public TwOutputUtil approvingPaging(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(true);
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {

        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {

            } else {
                // 数据权限 只能查审批人是自己的
                query.setApprUserId(loginUserId);
            }
        }
        OrderItem orderItem = OrderItem.desc("workDate");
        query.setOrders(Arrays.asList(orderItem));
        return TwOutputUtil.ok(timesheetService.pagingSingle(query));
    }


    /**
     * 分组审批分页列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/pagingGroup")
    @UdcNameClass
    public TwOutputUtil approvingPagingGroup(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(true);
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {

        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【工时审批管理员	TIME_SHEET_APPROVAL_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {

            } else {
                // 数据权限 只能查审批人是自己的
                query.setApprUserId(loginUserId);
            }
        }
        return TwOutputUtil.ok(timesheetService.pagingGroup(query));
    }


    /**
     * 导出工时列表
     *
     * @param query    查询
     * @param response 响应
     * @throws IOException ioexception
     */
    @GetMapping("/exportList")
    @PermissionFunction(functions = {
        @FunctionDetail(functionCode = FunctionCodeEnum.TIME_SHEET_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public void exportMyList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "工作日志审批";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        approvingDataFilterQuery(query);
        List<TimesheetVO> list = timesheetService.queryList(query);
        List<PmsTimesheetExcel> excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = udcUtil.translateList(excelList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmCustomerOperationVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, PmsTimesheetExcel.class, null);
        //写入
        sheet.doWrite(excelList);
    }

    /**
     * 详细审批导出
     *
     * @param query    查询
     * @param response 响应
     * @throws IOException ioexception
     */
    @GetMapping("/approving/exportList")
    public void exportList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "工作日志审批";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        approvingDataFilterQuery(query);
        List<TimesheetVO> list = timesheetService.queryList(query);
        List<TimesheetExcel> excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        excelList = udcUtil.translateList(excelList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmCustomerOperationVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, TimesheetExcel.class, null);
        //写入
        sheet.doWrite(excelList);

    }

    /**
     * 分组审批列表导出
     *
     * @param query    查询
     * @param response 响应
     * @return {@link TwOutputUtil}
     * @throws IOException ioexception
     */
    @GetMapping("/approving/exportListGroup")
    //@UdcNameClass
    public void exportListGroup(TimesheetQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "工作日志审批";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        approvingDataFilterQuery(query);
        List<TimesheetVO> list = timesheetService.listGroup(query);
        List<TimesheetExcel> excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        excelList = udcUtil.translateList(excelList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmCustomerOperationVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, CrmCustomerOperationExcelExport.class, null);
        //写入
        sheet.doWrite(excelList);
    }

    /**
     * 审批excel导出数据封装
     *
     * @param query 查询
     */
    private void approvingDataFilterQuery(TimesheetQuery query) {
//        if (CollectionUtils.isEmpty(query.getWorkDate())) {
//            // 限定只能查2个月内
//            throw TwException.error("", "请选择时间范围");
//            //return;
//        }
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {

        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【工时审批管理员	TIME_SHEET_APPROVAL_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {

            } else {
                // 数据权限 只能查审批人是自己的
                query.setApprUserId(loginUserId);
            }
        }
    }

    /**
     * 撤回 只有审批中的单据才允许撤回
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/revoked")
    @Deprecated
    public TwOutputUtil revoked(Long[] keys) {
        timesheetService.revoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 审批通过 只有审批中的单据才允许审批通过
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/approved")
    @Deprecated
    public TwOutputUtil toApproved(Long[] keys) {
        timesheetService.toApproved(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 审批拒绝 只有审批中的单据才允许审批拒绝
     *
     * @param keys       主键集合
     * @param apprResult 拒绝原因
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/rejected")
    @Deprecated
    public TwOutputUtil rejected(Long[] keys, String apprResult) {
        timesheetService.rejected(Arrays.asList(keys), apprResult);
        return TwOutputUtil.ok();
    }

    /**
     * 高级审批 只有审批中或新建的单据才允许审批通过
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/approvedPro")
    public TwOutputUtil approvedPro(Long[] keys) {
        timesheetService.toAdvanced(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 删除 只能删除状态为创建或者退回的工时
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        // 新建、退回的 才能删除
        timesheetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修复一月到六月的有项目无任务的工时
     */
    @GetMapping("/timesheet/repair")
    public TwOutputUtil repairTimesheet() {
        timesheetService.repairTimesheet();
        return TwOutputUtil.ok();
    }

}
