package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author sunxw
 * @description 用户假期申请
 * @Date 2023/5/9
 */
@Repository
@RequiredArgsConstructor
public class UserVacationApplyDAO {

    private static final QUserVacationApplyDetailDO qvaddo = QUserVacationApplyDetailDO.userVacationApplyDetailDO;
    private static final QUserVacationApplyDO qdo = QUserVacationApplyDO.userVacationApplyDO;
    private static final QPrdOrgOrganizationDO qpood = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;

    private final UserVacationApplyRepo userVacationApplyRepo;

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return
     */
    public PagingVO<UserVacationApplyVO> queryPaging(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<UserVacationApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<UserVacationApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return
     */
    public List<UserVacationApplyVO> queryList(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQueryWhere0(query);
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<UserVacationApplyVO> getJpaQueryWhere0(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            jpaQuery.where(qdo.applyNo.eq(query.getApplyNo()));
        }
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            jpaQuery.where(qdo.userId.eq(query.getUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdo.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentUserId())) {
            jpaQuery.where(qdo.pUserId.eq(query.getParentUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationType())) {
            jpaQuery.where(qdo.vacationType.eq(query.getVacationType()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationId())) {
            jpaQuery.where(qdo.vacationId.eq(query.getVacationId()));
        }

        /**
         * 不知道啥原因，之前取值的和筛选条件把查询值procInstStatus赋值给apprStatus
         */
//        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
//            jpaQuery.where(qdo.apprStatus.eq(query.getApprStatus()));
//        }
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            jpaQuery.where(qdo.procInstStatus.eq(ProcInstStatus.valueOf(query.getApprStatus())));
        }
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            jpaQuery.where(qdo.startDate.goe(query.getStartDate()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装请假申请查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<UserVacationApplyVO> getJpaQuerySelect0() {
        JPAQuery<UserVacationApplyVO> jpaQuery = jpaQueryFactory.select(Projections.bean(UserVacationApplyVO.class,
                qdo.id,
                qdo.createTime,
                qdo.createUserId,
                qdo.tenantId,
                qdo.applyNo,
                qdo.userId,
                qdo.orgId,
                qdo.pUserId.as("parentUserId"),
                qdo.vacationType,
                qdo.startDate,
                qdo.endDate,
                qdo.vacationDays,
                qdo.reason,
                qdo.workPlan,
                qdo.vacationId,
                qdo.addFlag,
                qdo.addList,
                qdo.procInstStatus.as("apprStatus"),
                qdo.apprUserId,
                //   qdo.apprDate,
                qdo.deleteFlag,
                qdo.autoSaveFlag,
                qdo.inProjectFlag

        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<UserVacationApplyVO> getJpaQueryWhere(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            jpaQuery.where(qdo.applyNo.eq(query.getApplyNo()));
        }
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            jpaQuery.where(qdo.userId.eq(query.getUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdo.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentUserId())) {
            jpaQuery.where(qdo.pUserId.eq(query.getParentUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationType())) {
            jpaQuery.where(qdo.vacationType.eq(query.getVacationType()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationId())) {
            jpaQuery.where(qdo.vacationId.eq(query.getVacationId()));
        }
        if (!StringUtils.isEmpty(query.getVdateStart()) && !StringUtils.isEmpty(query.getVdateEnd())) {
            jpaQuery.where(qvaddo.vDate.between(TimeUtil.dateFromYmd(query.getVdateStart()), TimeUtil.dateFromYmd(query.getVdateEnd())));
        }
        /**
         * 不知道啥原因，之前取值的和筛选条件把查询值procInstStatus赋值给apprStatus
         */
//        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
//            jpaQuery.where(qdo.apprStatus.eq(query.getApprStatus()));
//        }
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            jpaQuery.where(qdo.procInstStatus.eq(ProcInstStatus.valueOf(query.getApprStatus())));
        }
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            jpaQuery.where(qdo.startDate.goe(query.getStartDate()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装请假申请查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<UserVacationApplyVO> getJpaQuerySelect() {
        JPAQuery<UserVacationApplyVO> jpaQuery = jpaQueryFactory.select(Projections.bean(UserVacationApplyVO.class,
                        qdo.id,
                        qdo.tenantId,
                        qdo.applyNo,
                        qdo.userId,
                        qdo.orgId,
                        qpood.orgName,
                        qdo.pUserId.as("parentUserId"),
                        qdo.vacationType,
                        qdo.startDate,
                        qdo.endDate,
                        qdo.vacationDays,
                        qdo.reason,
                        qdo.workPlan,
                        qdo.vacationId,
                        qdo.addFlag,
                        qdo.addList,
                        qdo.procInstStatus.as("apprStatus"),
                        qdo.apprUserId,
                        //   qdo.apprDate,
                        qdo.deleteFlag,
                        qdo.autoSaveFlag,
                        qdo.inProjectFlag,
                        qvaddo.vMonth,
                        qvaddo.vDate.as("detailVDate"),
                        qvaddo.vDays.as("detailVDays"),
                        qvaddo.vInterval.as("detailInterval")
                )).from(qdo)
                .where(qdo.deleteFlag.eq(0))
                .leftJoin(qvaddo).on(qdo.id.longValue().eq(qvaddo.applyId).and(qvaddo.deleteFlag.eq(0)))
                .leftJoin(qpood).on(qdo.orgId.eq(qpood.id).and(qpood.deleteFlag.eq(0)));
        return jpaQuery;
    }

    public UserVacationApplyDO save(UserVacationApplyDO userVacationApplyDO) {
        return userVacationApplyRepo.save(userVacationApplyDO);
    }

    public void updateProcData(UserVacationApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        // 执行修改
        update.execute();
    }

    public UserVacationApplyDO findByProcId(String procId) {
        return userVacationApplyRepo.findByProcInstId(procId);
    }

    public UserVacationApplyDO findById(Long id) {
        return userVacationApplyRepo.findById(id).get();
    }

    public BigDecimal countApprovingDays(Long vacationId, Long id) {

        JPAQuery<BigDecimal> jpaQuery = jpaQueryFactory.select(qdo.vacationDays.sum())
                .from(qdo)
                .where(qdo.deleteFlag.eq(0))
                .where(qdo.vacationId.eq(vacationId))
                .where(qdo.procInstStatus.eq(ProcInstStatus.APPROVING));
        if (id != null) {
            jpaQuery.where(qdo.id.notIn(id));
        }
        return jpaQuery.groupBy(qdo.vacationId)
                .fetchFirst();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }
}
