package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEmployeesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationEmployeesService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationEmployeesVO;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.BusinessOperationEmployeesConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.BusinessOperationEmployeesDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationEmployeesDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationEmployeesRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-企业主要人员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessOperationEmployeesServiceImpl extends BaseServiceImpl implements BusinessOperationEmployeesService {

    private final BusinessOperationEmployeesRepo businessOperationEmployeesRepo;
    private final BusinessOperationEmployeesDAO businessOperationEmployeesDAO;

    @Override
    public PagingVO<BusinessOperationEmployeesVO> queryPaging(BusinessOperationEmployeesQuery query){
        return businessOperationEmployeesDAO.queryPaging(query);
    }

    @Override
    public List<BusinessOperationEmployeesVO> queryListDynamic(BusinessOperationEmployeesQuery query){
        return businessOperationEmployeesDAO.queryListDynamic(query);
    }

    @Override
    public BusinessOperationEmployeesVO queryByKey(Long key) {
        BusinessOperationEmployeesDO entity = businessOperationEmployeesRepo.findById(key).orElseGet(BusinessOperationEmployeesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationEmployeesVO vo = BusinessOperationEmployeesConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationEmployeesVO insert(BusinessOperationEmployeesPayload payload) {
        BusinessOperationEmployeesDO entityDo = BusinessOperationEmployeesConvert.INSTANCE.toDo(payload);
        return BusinessOperationEmployeesConvert.INSTANCE.toVo(businessOperationEmployeesRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationEmployeesVO update(BusinessOperationEmployeesPayload payload) {
        BusinessOperationEmployeesDO entity = businessOperationEmployeesRepo.findById(payload.getId()).orElseGet(BusinessOperationEmployeesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationEmployeesDO entityDo = BusinessOperationEmployeesConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessOperationEmployeesConvert.INSTANCE.toVo(businessOperationEmployeesRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessOperationEmployeesDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void deleteByPartnerId(Long partnerId) {
        businessOperationEmployeesDAO.deleteByPartnerId(partnerId);
    }

}
