package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.GeodesyUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookAddressConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookAddressDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookAddressRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-地址信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BookAddressServiceImpl extends BaseServiceImpl implements BookAddressService {

    private final BookAddressRepo bookAddressRepo;
    private final BookAddressDAO bookAddressDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final GeodesyUtil geodesyUtil;

    @Override
    public PagingVO<BookAddressVO> queryPaging(BookAddressQuery query) {
        return bookAddressDAO.queryPaging(query);
    }

    @Override
    public List<BookAddressVO> queryListDynamic(BookAddressQuery query) {
        return bookAddressDAO.queryListDynamic(query);
    }

    @Override
    public BookAddressVO queryByKey(Long key) {
        BookAddressDO entity = bookAddressRepo.findById(key).orElseGet(BookAddressDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BookAddressVO vo = BookAddressConvert.INSTANCE.toVo(entity);
        return vo;
    }

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookAddressVO}
     */
    @Override
    public BookAddressVO queryDefaultByBookId(Long bookId) {
        return bookAddressDAO.queryDefaultByBookId(bookId);
    }

    /**
     * 根据bookId查询地址列表
     *
     * @param bookId bookId
     * @return {@link List<BookAddressDO>}
     */
    @Override
    public List<BookAddressVO> queryByBookId(Long bookId) {
        List<BookAddressVO> bookAddressVOS = new ArrayList<>();
        List<BookAddressDO> bookAddressDOS = bookAddressDAO.queryByBookId(bookId);
        for (BookAddressDO bookAddressDO : bookAddressDOS) {
            bookAddressVOS.add(BookAddressConvert.INSTANCE.toVo(bookAddressDO));
        }
        return bookAddressVOS;
    }

//    @Override
//    public List<PrdAbAddressPayload> queryTwBookAddressListByBookId(List<Long> bookIdList) {
//        return bookAddressDAO.queryTwBookAddressListByBookId(bookIdList);
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookAddressVO insert(BookAddressPayload payload, Boolean logFlag) {
        //如果默认值是true就将原来的默认数据置为false
        /**
         * 如果是新增的第一条 置为默认 不管他选择了没有
         * 如果新增的不是第一条  看他这条是不是默认 是默认 将之前的默认数据置为false 不是默认不管
         **/

        BookAddressDO byBookIdAndIsDefault = bookAddressRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault() && byBookIdAndIsDefault != null) {
            byBookIdAndIsDefault.setIsDefault(false);
            bookAddressRepo.save(byBookIdAndIsDefault);
        }
        //空 说明是新增的第一条 新增的第一条置为默认
        if (byBookIdAndIsDefault == null) {
            payload.setIsDefault(true);
        }
        // 经纬度处理
        if (StringUtils.hasText(payload.getDetailAddress())) {
            if (ObjectUtils.isEmpty(payload.getLongitudeLatitude())) {
                String longitudeAndLatitude = geodesyUtil.getLongitudeAndLatitudeByAddress(payload.getDetailAddress());
                payload.setLongitudeLatitude(longitudeAndLatitude);
            }
        }

        BookAddressDO entityDo = BookAddressConvert.INSTANCE.toDo(payload);
        //操作记录
        if (logFlag && payload.getPartnerId() != null) {
            // 获取变更日志
//            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
//            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsCreateLog);
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "新增了一条地址信息");

        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookAddressConvert.INSTANCE.toVo(bookAddressRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookAddressVO update(BookAddressPayload payload, Boolean logFlag) {
        BookAddressDO entity = bookAddressRepo.findById(payload.getId()).orElseGet(BookAddressDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        BookAddressDO entityLog = new BookAddressDO();
        BeanUtils.copyProperties(entity, entityLog);
        //经纬度是否需要更新
        if (StringUtils.hasText(payload.getDetailAddress())) {
            String longitudeAndLatitude = geodesyUtil.getLongitudeAndLatitudeByAddress(payload.getDetailAddress());
            payload.setLongitudeLatitude(longitudeAndLatitude);
        }
        //如果默认值是true就将原来的默认数据置为false
        if (payload.getIsDefault() != null && payload.getIsDefault()) {
            BookAddressDO byBookIdAndIsDefault = bookAddressRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
            //确认不是自己
            if (byBookIdAndIsDefault != null && !byBookIdAndIsDefault.getId().equals(payload.getId())) {
                byBookIdAndIsDefault.setIsDefault(false);
                bookAddressRepo.save(byBookIdAndIsDefault);
            }
        }
        BookAddressDO entityDo = BookAddressConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //操作记录
        if (logFlag && null != payload.getPartnerId()) {
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "修改了一条地址信息");
        }
//        //操作记录
//        if (logFlag&&null != payload.getPartnerId()) {
//            // 修改NULL值特殊处理
//            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
//            //获取变更日志
//            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
//            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
//                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
//            }
//        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookAddressConvert.INSTANCE.toVo(bookAddressRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<BookAddressDO> optional = bookAddressRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    BookAddressDO entity = optional.get();
//                    bookAddressRepo.save(entity);
//                }
//             });

            bookAddressDAO.deleteSoft(keys);
            //如果删除只剩最后一条 就设为默认地址1
            List<BookAddressDO> dos = bookAddressDAO.queryByBookId(bookId);
            if (dos != null && dos.size() == 1) {
                BookAddressDO bookAddressDO = dos.get(0);
                bookAddressDO.setIsDefault(true);
                bookAddressRepo.save(bookAddressDO);
            }
            if (logFlag && partnerId != null) {
                logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 " + keys.size() + " 条地址信息");
            }
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    @Override
    public Long count(BookAddressQuery query) {
        return bookAddressDAO.count(query);
    }

}
