package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectMembersRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectMembersDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectMembersRepo repo;
    private final QPmsProjectMembersDO qdo = QPmsProjectMembersDO.pmsProjectMembersDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectMembersVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectMembersVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目ID
                qdo.projId,
                // 角色
                qdo.role,
                // 复合能力ID
                qdo.capasetLevelId,
                // 资源id
                qdo.resId,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 规划当量
                qdo.planEqva,
                // 工作台默认显示
                qdo.workbenchFlag,
                // 客户结算价
                qdo.customerPrice,
                qdoEmployee.resourceStatus
//                ,
//                // 任务包
//                qdo.taskPackageId
        )).from(qdo).leftJoin(qdoEmployee).on(qdo.resId.eq(qdoEmployee.userId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectMembersVO> getJpaQueryWhere(PmsProjectMembersQuery query) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("createTime"));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        jpaQuery.groupBy(qdo.resId);
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsProjectMembersQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdoEmployee).on(qdo.resId.eq(qdoEmployee.userId));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
//        jpaQuery.groupBy(qdo.resId);
        Long total = jpaQuery.fetchOne();
        total = total == null ? 0L : total;
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectMembersQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 项目ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 角色 精确 */
        if (!ObjectUtils.isEmpty(query.getRole())) {
            list.add(qdo.role.eq(query.getRole()));
        }
        /** 复合能力ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCapasetLevelId())) {
            list.add(qdo.capasetLevelId.eq(query.getCapasetLevelId()));
        }
        /** 资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getResId())) {
            list.add(qdo.resId.eq(query.getResId()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 规划当量 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEqva())) {
            list.add(qdo.planEqva.eq(query.getPlanEqva()));
        }
        /** 工作台默认显示 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkbenchFlag())) {
            list.add(qdo.workbenchFlag.eq(query.getWorkbenchFlag()));
        }
        /** 客户结算价 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerPrice())) {
            list.add(qdo.customerPrice.eq(query.getCustomerPrice()));
        }
        list.add(qdoEmployee.deleteFlag.eq(0));
//        list.add(qdoEmployee.hrStatus.eq(SystemDefaultEnum.DefaultHrStatus.getCode()));
//        list.add(qdoEmployee.resourceStatus.ne(SystemDefaultEnum.LeavedResourceStatus.getCode()));
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectMembersVO queryByKey(Long id) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsProjectMembersVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据  项目 和资源 查询
     *
     * @param projId
     * @param resId
     * @return
     */
    public PmsProjectMembersVO queryByProjAndRes(Long projId, Long resId) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projId.eq(projId));
        jpaQuery.where(qdo.resId.eq(resId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectMembersVO> queryListDynamic(PmsProjectMembersQuery query) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectMembersVO> queryPaging(PmsProjectMembersQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectMembersVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsProjectMembersVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsProjectMembersVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectMembersDO save(PmsProjectMembersDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectMembersDO> saveAll(List<PmsProjectMembersDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectMembersPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 项目ID
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 角色
        if (payload.getRole() != null) {
            update.set(qdo.role, payload.getRole());
        }
        // 复合能力ID
        if (payload.getCapasetLevelId() != null) {
            update.set(qdo.capasetLevelId, payload.getCapasetLevelId());
        }
        // 资源id
        if (payload.getResId() != null) {
            update.set(qdo.resId, payload.getResId());
        }
        // 预计开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 预计结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 规划当量
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        // 工作台默认显示
        if (payload.getWorkbenchFlag() != null) {
            update.set(qdo.workbenchFlag, payload.getWorkbenchFlag());
        }
        // 客户结算价
        if (payload.getCustomerPrice() != null) {
            update.set(qdo.customerPrice, payload.getCustomerPrice());
        }

        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目ID
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 角色
            if (nullFields.contains("role")) {
                update.setNull(qdo.role);
            }
            // 复合能力ID
            if (nullFields.contains("capasetLevelId")) {
                update.setNull(qdo.capasetLevelId);
            }
            // 资源id
            if (nullFields.contains("resId")) {
                update.setNull(qdo.resId);
            }
            // 预计开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 预计结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
            // 规划当量
            if (nullFields.contains("planEqva")) {
                update.setNull(qdo.planEqva);
            }
            // 工作台默认显示
            if (nullFields.contains("workbenchFlag")) {
                update.setNull(qdo.workbenchFlag);
            }
            // 客户结算价
            if (nullFields.contains("customerPrice")) {
                update.setNull(qdo.customerPrice);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

