package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummaryPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummaryQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummaryService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummaryVO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSummaryConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSummaryDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSummaryDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSummaryRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectSummaryServiceImpl extends BaseServiceImpl implements PmsProjectSummaryService {

    private final PmsProjectSummaryRepo pmsProjectSummaryRepo;
    private final PmsProjectSummaryDAO pmsProjectSummaryDAO;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT_SUMMARY);
    }

    @Override
    public PagingVO<PmsProjectSummaryVO> queryPaging(PmsProjectSummaryQuery query) {
        return pmsProjectSummaryDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectSummaryVO> queryListDynamic(PmsProjectSummaryQuery query) {
        return pmsProjectSummaryDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectSummaryVO queryByKey(Long key) {
        return pmsProjectSummaryDAO.queryByKey(key);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSummaryVO insert(PmsProjectSummaryPayload payload) {
        LocalDate summaryDate = LocalDate.now();
        String summaryName = payload.getProjName() + "-" + summaryDate.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        PmsProjectSummaryQuery pmsProjectSummaryQuery = new PmsProjectSummaryQuery();
        pmsProjectSummaryQuery.setSummaryName(summaryName);
        List<PmsProjectSummaryVO> pmsProjectSummaryVOS = pmsProjectSummaryDAO.queryListDynamic(pmsProjectSummaryQuery);
        if (!CollectionUtils.isEmpty(pmsProjectSummaryVOS)) {
            // 定义序号
            List<PmsProjectSummaryVO> collect = pmsProjectSummaryVOS.stream()
                    .sorted(Comparator.comparing(PmsProjectSummaryVO::getCreateTime).reversed())
                    .collect(Collectors.toList());
            String lastSummaryName = collect.get(0).getSummaryName();
            int i = Integer.parseInt(lastSummaryName.split("-")[lastSummaryName.split("-").length - 1]);
            summaryName = summaryName + "-" + String.valueOf(i + 1);
        } else {
            summaryName = summaryName + "-1";
        }
        payload.setSummaryDate(summaryDate);
        payload.setSummaryName(summaryName);
        String code = generateSeqNum("PROJ_SUMMARY");
        payload.setSummaryNo(code);
        PmsProjectSummaryDO entityDo = PmsProjectSummaryConvert.INSTANCE.toDo(payload);
        return PmsProjectSummaryConvert.INSTANCE.toVo(pmsProjectSummaryRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSummaryVO update(PmsProjectSummaryPayload payload) {
        PmsProjectSummaryDO entity = pmsProjectSummaryRepo.findById(payload.getId()).orElseGet(PmsProjectSummaryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectSummaryDO entityDo = PmsProjectSummaryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectSummaryConvert.INSTANCE.toVo(pmsProjectSummaryRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectSummaryPayload payload) {
        PmsProjectSummaryDO entity = pmsProjectSummaryRepo.findById(payload.getId()).orElseGet(PmsProjectSummaryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectSummaryDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectSummaryDAO.deleteSoft(keys);
        }
    }

    @Override
    public PagingVO<PmsProjectSummaryVO> pagingPermission(PmsProjectSummaryQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.whereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PmsProjectSummaryVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<PmsProjectSummaryVO> pmsProjectSummaryVOS = beanSearcher.searchList(PmsProjectSummaryVO.class, mapBuilder.build());
        return PagingVO.<PmsProjectSummaryVO>builder().records(pmsProjectSummaryVOS).total(total).build();
    }

    @Override
    public List<PmsProjectSummaryVO> listPermissionDynamic(PmsProjectSummaryQuery query) {
        query.setSize(999);
        MapBuilder mapBuilder = this.whereBuilder(query);
        return beanSearcher.searchList(PmsProjectSummaryVO.class, mapBuilder.build());

    }

    /**
     * 分页权限 条件封装
     *
     * @param query 查询
     * @return {@link MapBuilder}
     */
    private MapBuilder whereBuilder(PmsProjectSummaryQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty(query.getSummaryNo())) {
            builder.field(PmsProjectSummaryVO::getSummaryNo, query.getSummaryNo()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getSummaryName())) {
            String likeStr = "%" + query.getSummaryName() + "%";
            builder.field(PmsProjectSummaryVO::getSummaryName).sql("$1 like ?", likeStr);
        }
        if (!ObjectUtils.isEmpty(query.getProjSearch())) {
            String projSerchLikeStr = "%" + query.getProjSearch() + "%";
            builder.field(PmsProjectSummaryVO::getProjName, PmsProjectSummaryVO::getProjNo).sql("$1 like ? or $2 like ?", projSerchLikeStr, projSerchLikeStr);
        }
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            builder.field(PmsProjectSummaryVO::getProjId, query.getProjId()).op(FieldOps.Equal);
        }
        /** 项目经理 */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            builder.field(PmsProjectSummaryVO::getPmResId, query.getPmResId()).op(FieldOps.Equal);
        }
        /** 交付bu 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            builder.field(PmsProjectSummaryVO::getDeliBuId, query.getDeliBuId()).op(FieldOps.Equal);
        }
        /** 交付负责人 */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            builder.field(PmsProjectSummaryVO::getDeliUserId, query.getDeliUserId()).op(FieldOps.Equal);
        }
        /** 提交人 */
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            builder.field(PmsProjectSummaryVO::getCreateUserId, query.getCreateUserId()).op(FieldOps.Equal);
        }
        /**
         * 记录日期
         */
        if (!ObjectUtils.isEmpty(query.getSummaryDate())) {
            builder.field(PmsProjectSummaryVO::getSummaryDate, query.getSummaryDate().get(0), query.getSummaryDate().get(1)).op(FieldOps.Between);
        }
        /**
         * 工作类型
         */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            builder.field(PmsProjectSummaryVO::getWorkType, query.getWorkType()).op(FieldOps.Equal);
        }
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("createTime"));
        query.setOrders(orderse);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

}
