package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdProductServiceImpl extends BaseServiceImpl implements PrdProductService {

    private final PrdProductRepo productRepo;
    private final PrdProductDAO productDAO;

    private final FileUtil fileUtil;

    @Override
    public PagingVO<PrdProductVO> queryPaging(PrdProductQuery query) {
        return productDAO.queryPaging(query);
    }

    @Override
    public List<PrdProductVO> queryListDynamic(PrdProductQuery query) {
        return productDAO.queryListDynamic(query);
    }

    @Override
    public PrdProductVO queryByKey(Long key) {
        PrdProductDO entity = productRepo.findById(key).orElseGet(PrdProductDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductVO vo = PrdProductConvert.INSTANCE.toVo(entity);
        setFileData(vo);
        return vo;
    }

    @Override
    public List<PrdProductVO> queryByKeys(List<Long> keys) {
        List<PrdProductDO> PrdProductDOList = productRepo.findAllById(keys);
        if(CollectionUtils.isEmpty(PrdProductDOList)){
            throw TwException.error("","采购明细关联的产品不存在");
        }
        return PrdProductConvert.INSTANCE.toVoList(PrdProductDOList);
    }

    /**
     * 设置文件路径数据
     *
     * @param vo
     */
    private void setFileData(PrdProductVO vo) {
        if (ObjectUtils.isEmpty(vo)) {
            return;
        }
        vo.setLogoFileData(fileUtil.getFileDatas(vo.getLogoPath()));
        vo.setVideoFileData(fileUtil.getFileDatas(vo.getVideoPath()));
        vo.setCopyrightFileData(fileUtil.getFileDatas(vo.getCopyrightFileCodes()));
        vo.setReportFileData(fileUtil.getFileDatas(vo.getReportFileCodes()));
        vo.setSprcFileData(fileUtil.getFileDatas(vo.getSprcFileCodes()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductVO insert(PrdProductPayload payload) {
        String prodNo = generateSeqNum("PRODUCT_NO");
        payload.setProdNo(prodNo);
        PrdProductDO entityDo = PrdProductConvert.INSTANCE.toDo(payload);
        return PrdProductConvert.INSTANCE.toVo(productRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductVO update(PrdProductPayload payload) {
        PrdProductDO entity = productRepo.findById(payload.getId()).orElseGet(PrdProductDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductDO entityDo = PrdProductConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
        return PrdProductConvert.INSTANCE.toVo(productRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            productDAO.deleteSoft(keys);
        }
    }

}
