package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConTemplatePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConTemplateQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConTemplateVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConTemplateService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合同模板
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Api(tags = "合同模板")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/conTemplate")
@Slf4j
public class ConTemplateController {

    private final ConTemplateService conTemplateService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConTemplatePayload payload){
        return TwOutputUtil.ok(conTemplateService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConTemplatePayload payload){
        return TwOutputUtil.ok(conTemplateService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conTemplateService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConTemplateQuery query) {
        return TwOutputUtil.ok(conTemplateService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConTemplateQuery query) {
        return TwOutputUtil.ok(conTemplateService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conTemplateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据Id删除
     *
     * @param key 主键id
     * @return result
     */
    @DeleteMapping("/deleteById")
    @ApiOperation("删除")
    public TwOutputUtil deleteById(Long key) {
        conTemplateService.deleteById(key);
        return TwOutputUtil.ok();
    }

}
