package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleGroupVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleGroupRoleRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 角色组
 *
 * @Author Bill
 * @Date 2023/9/19 13:19
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemRoleGroupDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdSystemRoleGroupRoleDO qPrdSystemRoleGroupRoleDO = QPrdSystemRoleGroupRoleDO.prdSystemRoleGroupRoleDO;
    private final QPrdSystemRoleGroupDO qdo = QPrdSystemRoleGroupDO.prdSystemRoleGroupDO;

    /**
     * 查询关联角色
     * @param id
     * @return
     */
    public List<PrdSystemRoleGroupRoleDO> queryByRole(Long id) {
        JPAQuery<PrdSystemRoleGroupRoleDO> jpaQuery = getJpaQuerySelectByRoleGroupRole();
        jpaQuery.where(qPrdSystemRoleGroupRoleDO.roleGroupId.longValue().eq(id));
        return jpaQuery.fetch();
    }

    /**
     * 查询关联角色
     * @param ids
     * @return
     */
    public List<PrdSystemRoleGroupRoleDO> queryByRoles(List<Long> ids) {
        JPAQuery<PrdSystemRoleGroupRoleDO> jpaQuery = getJpaQuerySelectByRoleGroupRole();
        jpaQuery.where(qPrdSystemRoleGroupRoleDO.roleGroupId.longValue().in(ids));
        return jpaQuery.fetch();
    }

    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemRoleGroupRoleDO> getJpaQuerySelectByRoleGroupRole(){
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleGroupRoleDO.class,
                qPrdSystemRoleGroupRoleDO.id,
                qPrdSystemRoleGroupRoleDO.roleGroupId,
                qPrdSystemRoleGroupRoleDO.roleId
        )).from(qPrdSystemRoleGroupRoleDO);
    }

    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemRoleGroupVO> getJpaQuerySelectByRoleGroup(){
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleGroupVO.class,
                qdo.id,
                qdo.roleGroupName,
                qdo.roleGroupType
        )).from(qdo);
    }

    /**
     * 角色组类型 查询角色组
     * @param roleGroupType
     * @return
     */
    public List<PrdSystemRoleGroupVO> queryByRoleGroupType(String roleGroupType) {
        JPAQuery<PrdSystemRoleGroupVO> jpaQuery = getJpaQuerySelectByRoleGroup();
        if (StringUtils.hasText(roleGroupType)){
            jpaQuery.where(qdo.roleGroupType.eq(roleGroupType));
        }
        return jpaQuery.fetch();
    }
}
