package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author Quruiqizz
 * @Date 2023/10/10 19:12
 **/
@Entity
@Table(name = "prd_system_permission_function_object")
@org.hibernate.annotations.Table(appliesTo = "prd_system_permission_function_object", comment = "功能对象")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemPermissionFunctionObjectDO extends BaseModel {

    private static final long serialVersionUID = -8386631376142921624L;

    @Comment("业务对象主键")
    @Column(name = "object_id")
    private Long objectId;

    @Comment("功能主键")
    @Column(name = "function_id")
    private Long functionId;

    @Comment("类名")
    @Column(name = "class_name")
    private String className;

    @Comment("类路径编码")
    @Column(name = "class_path_code")
    private String classPathCode;

    @Comment("类路径名称")
    @Column(name = "class_path_name")
    private String classPathName;

    @Comment("功能类型")
    @Column(name = "permission_type")
    private String permissionType;

}
