package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemWorkTypeService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemWorkTypeDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemWorkTypeDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人力管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemWorkTypeServiceImpl implements PrdSystemWorkTypeService {
    private final PrdSystemWorkTypeDAO dao;
    private final CacheUtil cacheUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService service;

    @Transactional
    @Override
    public Long update(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        dao.updateByKeyDynamic(key, sysType, sysWork, sysLevel, unitPrice);
        return 0L;
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        return true;
    }

    @Override
    public PagingVO<PrdSystemWorkTypeVO> paging(PrdSystemWorkTypeQuery query) {
        PagingVO<PrdSystemWorkTypeVO> workTypeVOPagingVO = dao.queryPaging(query);
        workTypeVOPagingVO.getRecords().forEach(workTypeVO -> transferSystemSelection(workTypeVO));
        return workTypeVOPagingVO;
    }

    @Override
    public Map<String, Map<String, Map<String, BigDecimal>>> queryList() {
        List<PrdSystemWorkTypeVO> workTypeVOS = dao.queryList();
        Map<String, Map<String, Map<String, BigDecimal>>> workTypes = new HashMap<>();
        for (PrdSystemWorkTypeVO workTypeVO : workTypeVOS) {
            transferSystemSelection(workTypeVO);
            String type = workTypeVO.getSysType();
            String work = workTypeVO.getSysWork();
            String level = workTypeVO.getSysLevel();
            BigDecimal unitPrice = workTypeVO.getUnitPrice();

            Map<String, Map<String, BigDecimal>> typeMap = workTypes.get(type);
            if (typeMap == null) {
                typeMap = new HashMap<>();
                workTypes.put(type, typeMap);
            }
            Map<String, BigDecimal> workType = typeMap.get(work);
            if (workType == null) {
                workType = new HashMap<>();
                typeMap.put(work, workType);
            }

            BigDecimal price = workType.get(level);
            if (price == null) {
                workType.put(level, unitPrice);
            }
        }
        return workTypes;
    }

    @Override
    public void downloadPlus(HttpServletResponse response, PrdSystemWorkTypeQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/systemWorkTypeBatch.xlsx");
        List<PrdSystemWorkTypeVO> list = new ArrayList<>();
        if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("data")) {
            PagingVO<PrdSystemWorkTypeVO> evo = paging(query);
            list = evo.getRecords();
        }

        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("人力成本");

            excelUtil.generateRangeList(batchProjectSheet, 1, 1, "LOV", 2, "A"); // 类别
            excelUtil.generateRangeList(batchProjectSheet, 3, 1, "LOV", 2, "C"); // 工种 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 5, 1, "LOV", 2, "E"); // 级别 数据验证
            if (batchProjectSheet != null) {
                if (list.size() > 0) {
                    int nextRow = 1;
                    for (PrdSystemWorkTypeVO dataPayload : list) {
                        Row row = batchProjectSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, nextRow); // 序号
                        excelUtil.setCellValue(row, 1, dataPayload.getSysTypeName());// 账号
                        excelUtil.setCellFormulas(row, 2, "VLOOKUP(B" + ExcelUtil.formulasReplace + ",LOV!A:B,2,FALSE)");//类别
                        excelUtil.setCellValue(row, 3, dataPayload.getSysWorkName());// 邮件
                        excelUtil.setCellFormulas(row, 4, "VLOOKUP(D" + ExcelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");//工种
                        excelUtil.setCellValue(row, 5, dataPayload.getSysLevelName());// 证件号
                        excelUtil.setCellFormulas(row, 6, "VLOOKUP(F" + ExcelUtil.formulasReplace + ",LOV!E:F,2,FALSE)");//级别
                        excelUtil.setCellValue(row, 7, dataPayload.getUnitPrice());//上级名称
                        excelUtil.setCellValue(row, 8, dataPayload.getCreateUserName());//上级编号
                        excelUtil.setCellValue(row, 9, dataPayload.getCreateTime());//上级编号
                        nextRow++;
                    }
                } else {
                    excelUtil.setCellFormulas(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1), 2, "VLOOKUP(B" + ExcelUtil.formulasReplace + ",LOV!A:B,2,FALSE)");//类别
                    excelUtil.setCellFormulas(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1), 4, "VLOOKUP(D" + ExcelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");//工种
                    excelUtil.setCellFormulas(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1), 6, "VLOOKUP(F" + ExcelUtil.formulasReplace + ",LOV!E:F,2,FALSE)");//级别
                }
            }

            List<PrdSystemSelectionVO> sequenceist = service.selectByCondition(FunctionSelectionEnum.OrgEmployeeSequence.getCode());
            List<PrdSystemSelectionVO> typeList = service.selectByCondition(FunctionSelectionEnum.OrgEmployeeType.getCode());
            List<PrdSystemSelectionVO> levelList = service.selectByCondition(FunctionSelectionEnum.OrgEmployeeWorkLevel.getCode());

            Sheet sequenceSheet = workbook.getSheet("LOV");
            if (!CollectionUtils.isEmpty(sequenceist) && sequenceSheet != null) {
                int num = (sequenceist.size() > typeList.size() ? sequenceist.size() : typeList.size()) > levelList.size() ? (sequenceist.size() > typeList.size() ? sequenceist.size() : typeList.size()) : levelList.size();
                for (int i = 0; i < num; i++) {
                    Row row = sequenceSheet.createRow(i + 1);
                    if (i < sequenceist.size()) {
                        PrdSystemSelectionVO sequence = sequenceist.get(i);
                        if (StringUtils.hasText(sequence.getSelectionName()) && StringUtils.hasText(sequence.getSelectionValue())) {
                            excelUtil.setCellValue(row, 0, sequence.getSelectionName());
                            excelUtil.setCellValue(row, 1, sequence.getSelectionValue());
                        }
                    }
                    if (i < typeList.size()) {
                        PrdSystemSelectionVO type = typeList.get(i);
                        if (StringUtils.hasText(type.getSelectionName()) && StringUtils.hasText(type.getSelectionValue())) {
                            excelUtil.setCellValue(row, 2, type.getSelectionName());
                            excelUtil.setCellValue(row, 3, type.getSelectionValue());
                        }
                    }
                    if (i < levelList.size()) {
                        PrdSystemSelectionVO level = levelList.get(i);
                        if (StringUtils.hasText(level.getSelectionName()) && StringUtils.hasText(level.getSelectionValue())) {
                            excelUtil.setCellValue(row, 4, level.getSelectionName());
                            excelUtil.setCellValue(row, 5, level.getSelectionValue());
                        }
                    }
                }
            }
            String fileName = "人力成本数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (
                Exception e) {
            e.printStackTrace();
        }

    }

    @Transactional
    @Override
    public boolean importWorkType(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("人力成本");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        List<PrdSystemWorkTypeDO> workTypeDOs = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            PrdSystemWorkTypeDO workTypeDO = new PrdSystemWorkTypeDO();
            System.out.println("row.getCell(2)::" + row.getCell(1));
            String sysType = ExcelUtil.getCellFormatValue(row.getCell(2));
            if (sysType == null || sysType.length() < 1) {
                break;
            }
            String sysWork = ExcelUtil.getCellFormatValue(row.getCell(4));
            String sysLevel = ExcelUtil.getCellFormatValue(row.getCell(6));
            String unitPrice = ExcelUtil.getCellFormatValue(row.getCell(7));
            workTypeDO.setSysType(sysType);
            workTypeDO.setSysWork(sysWork);
            workTypeDO.setSysLevel(sysLevel);
            workTypeDO.setUnitPrice(new BigDecimal(unitPrice));
            workTypeDOs.add(workTypeDO);
        }

        dao.saveAll(workTypeDOs);
        return true;
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(PrdSystemWorkTypeVO vo) {
        vo.setSysTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeSequence.getCode(), vo.getSysType()));
        vo.setSysWorkName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeType.getCode(), vo.getSysWork()));
        vo.setSysLevelName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeSpecialtyLevel.getCode(), vo.getSysLevel()));


    }
}
