/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtil
extends cn.hutool.core.date.DateUtil {
    public static String getYearWeek(LocalDate localDate) {
        int week = localDate.get(WeekFields.ISO.weekOfWeekBasedYear());
        String pad = week < 10 ? "0" : "";
        return localDate.get(WeekFields.ISO.weekBasedYear()) + pad + week;
    }

    public static String getYearWeek(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int week = localDate.get(WeekFields.ISO.weekOfWeekBasedYear());
        String pad = week < 10 ? "0" : "";
        return localDate.get(WeekFields.ISO.weekBasedYear()) + pad + week;
    }

    public static LocalDate getStartWeekDay(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return localDate.with(fieldISO, 1L);
    }

    public static LocalDate getStartWeekDay() {
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return now.with(fieldISO, 1L);
    }

    public static LocalDate getEndWeekDay(LocalDate date) {
        if (null == date) {
            date = LocalDate.now();
        }
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return date.with(fieldISO, 5L);
    }

    public static List<LocalDate> getNowWeekDays() {
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>();
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        for (int i = 1; i <= 7; ++i) {
            LocalDate date = now.with(fieldISO, i);
            localDates.add(date);
        }
        return localDates;
    }

    public static List<LocalDate> getNextWeekDays() {
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>();
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        LocalDate localDate = now.with(fieldISO, 7L);
        LocalDate nextDate = localDate.plusDays(1L);
        for (int i = 1; i <= 7; ++i) {
            LocalDate date = nextDate.with(fieldISO, i);
            localDates.add(date);
        }
        return localDates;
    }

    public static int differenceMonth(LocalDate localDate0, LocalDate localDate1) {
        Period between = Period.between(localDate0, localDate1);
        return between.getYears() * 12 + between.getMonths();
    }

    public static int differenceDays(LocalDate localDate0, LocalDate localDate1) {
        Period between = Period.between(localDate0, localDate1);
        return between.getYears() * 12 + between.getMonths() * 30 + between.getDays();
    }

    public static LocalDate strToLocalDate(String strDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date = LocalDate.parse(strDate, formatter);
        return date;
    }

    public static LocalDate getMinusMonth(LocalDate localDate) {
        LocalDate with = localDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        return with;
    }
}

