/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRuleAttrExcludePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRulePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRuleRegainPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRuleRegainTriggerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreMembersConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreRuleAttrExcludeConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreRuleRegainTriggerConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleAttrExcludeDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleRegainDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleRegainTriggerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsOffshoreRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOffshoreRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmOffshoreDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOffshoreRepo repo;
    private final CrmLeadsOffshoreRepo leadsOffshoreRepo;
    private final QCrmOffshoreDO qdo = QCrmOffshoreDO.crmOffshoreDO;

    public CrmOffshoreDO save(CrmOffshoreDO ado) {
        return (CrmOffshoreDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmOffshoreDO> saveAll(List<CrmOffshoreDO> dos) {
        return this.repo.saveAll(dos);
    }

    public CrmOffshoreVO queryByKey(Long id) {
        JPAQuery<CrmOffshoreVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.id.eq((Object)id));
        return (CrmOffshoreVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<CrmOffshoreVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOffshoreVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.offshoreName})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    private JPAQuery<CrmOffshoreVO> getJpaQueryWhere(CrmOffshoreQuery query) {
        JPAQuery<CrmOffshoreVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getOffshoreName())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.offshoreName.eq((Object)query.getOffshoreName()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<CrmOffshoreVO> queryListDynamic(CrmOffshoreQuery query) {
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmOffshoreVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CrmOffshoreVO> queryPaging(CrmOffshoreQuery query) {
        JPAQuery<CrmOffshoreVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public long updateByKeyDynamic(CrmOffshorePayload payload) {
        CrmOffshoreDO offshoreDO = this.repo.findById(payload.getId()).orElse(null);
        if (offshoreDO != null) {
            if (payload.getOffshoreName() != null) {
                offshoreDO.setOffshoreName(payload.getOffshoreName());
            }
            if (payload.getLeadsNum() != null) {
                offshoreDO.setLeadsNum(payload.getLeadsNum());
            }
            if (payload.getOffshoreMembers() != null) {
                List<CrmOffshoreMembersDO> offshoreMembers = payload.getOffshoreMembers().stream().map(e -> CrmOffshoreMembersConvert.INSTANCE.toDo((CrmOffshoreMembersPayload)e)).collect(Collectors.toList());
                offshoreMembers = offshoreMembers.stream().filter(e -> {
                    if (e.getDeleteFlag() == 0) {
                        return true;
                    }
                    offshoreDO.getOffshoreMembers().remove(e);
                    return false;
                }).collect(Collectors.toList());
                offshoreDO.setOffshoreMembers(offshoreMembers);
            }
            if (payload.getDeleteFlag() != null) {
                offshoreDO.setDeleteFlag(payload.getDeleteFlag());
            }
            if (payload.getOffshoreRule() != null) {
                CrmOffshoreRuleDO offshoreRuleDO = offshoreDO.getOffshoreRule();
                CrmOffshoreRulePayload offshoreRulePayload = payload.getOffshoreRule();
                if (offshoreRulePayload.getDistributeReceiveRule() != null) {
                    offshoreRuleDO.setDistributeReceiveRule(offshoreRulePayload.getDistributeReceiveRule());
                }
                if (offshoreRulePayload.getNewLeadsRemind() != null) {
                    offshoreRuleDO.setNewLeadsRemind(offshoreRulePayload.getNewLeadsRemind());
                }
                if (offshoreRulePayload.getReceiveLeadsLimit() != null) {
                    offshoreRuleDO.setReceiveLeadsLimit(offshoreRulePayload.getReceiveLeadsLimit());
                }
                if (offshoreRulePayload.getReceiveLeadsLimitDays() != null) {
                    offshoreRuleDO.setReceiveLeadsLimitDays(offshoreRulePayload.getReceiveLeadsLimitDays());
                }
                if (offshoreRulePayload.getReceiveLeadsRemind() != null) {
                    offshoreRuleDO.setReceiveLeadsRemind(offshoreRulePayload.getReceiveLeadsRemind());
                }
                if (offshoreRulePayload.getDistributeLeadsRemindTime() != null) {
                    offshoreRuleDO.setDistributeLeadsRemindTime(offshoreRulePayload.getDistributeLeadsRemindTime());
                }
                if (offshoreRulePayload.getFollowLeadsRemindTime() != null) {
                    offshoreRuleDO.setFollowLeadsRemindTime(offshoreRulePayload.getFollowLeadsRemindTime());
                }
                if (offshoreRulePayload.getShowFollowBeforeReceive() != null) {
                    offshoreRuleDO.setShowFollowBeforeReceive(offshoreRulePayload.getShowFollowBeforeReceive());
                }
                if (offshoreRulePayload.getOffshoreRuleAttrExcludes() != null) {
                    List<CrmOffshoreRuleAttrExcludeDO> attrExcludeDOS = offshoreRulePayload.getOffshoreRuleAttrExcludes().stream().map(e -> CrmOffshoreRuleAttrExcludeConvert.INSTANCE.toDo((CrmOffshoreRuleAttrExcludePayload)e)).collect(Collectors.toList());
                    attrExcludeDOS = attrExcludeDOS.stream().filter(e -> {
                        if (e.getDeleteFlag() == 0) {
                            return true;
                        }
                        offshoreRuleDO.getOffshoreRuleAttrExcludes().remove(e);
                        return false;
                    }).collect(Collectors.toList());
                    offshoreRuleDO.setOffshoreRuleAttrExcludes(attrExcludeDOS);
                }
                if (offshoreRulePayload.getRegainRule() != null) {
                    CrmOffshoreRuleRegainPayload regainRule = offshoreRulePayload.getRegainRule();
                    CrmOffshoreRuleRegainDO regainRuleDo = offshoreRuleDO.getRegainRule();
                    if (regainRule.getRegainRemindTime() != null) {
                        regainRuleDo.setRegainRemindTime(regainRule.getRegainRemindTime());
                    }
                    if (regainRule.getToThisOffshore() != null) {
                        regainRuleDo.setToThisOffshore(regainRule.getToThisOffshore());
                    }
                    if (regainRule.getTargetOffshore() != null) {
                        regainRuleDo.setTargetOffshore(regainRule.getTargetOffshore());
                    }
                    if (regainRule.getTriggerRules() != null) {
                        List<CrmOffshoreRuleRegainTriggerDO> triggerDOS = regainRule.getTriggerRules().stream().map(e -> CrmOffshoreRuleRegainTriggerConvert.INSTANCE.toDo((CrmOffshoreRuleRegainTriggerPayload)e)).collect(Collectors.toList());
                        triggerDOS = triggerDOS.stream().filter(e -> {
                            if (e.getDeleteFlag() == 0) {
                                return true;
                            }
                            regainRuleDo.getTriggerRules().remove(e);
                            return false;
                        }).collect(Collectors.toList());
                        regainRuleDo.setTriggerRules(triggerDOS);
                    }
                }
                offshoreDO.setOffshoreRule(offshoreRuleDO);
            }
            this.repo.save((Object)offshoreDO);
            return 1L;
        }
        return 0L;
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new com.querydsl.core.types.Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public Specification<CrmOffshoreDO> getSpec(CrmOffshoreQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!ObjectUtils.isEmpty((Object)query.getId())) {
                predicates.add(cb.equal(root.get("id").as(Long.class), (Object)query.getId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getOffshoreName())) {
                predicates.add(cb.like(root.get("offshoreName").as(String.class), SqlUtil.toSqlLikeString(query.getOffshoreName())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getOffshoreNameNotEqual())) {
                predicates.add(cb.notEqual(root.get("offshoreName").as(String.class), (Object)query.getOffshoreNameNotEqual()));
            }
            Join adminJoin = root.join("offshoreAdmins", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getOffshoreAdminId())) {
                predicates.add(cb.equal(adminJoin.get("userId").as(Long.class), (Object)query.getOffshoreAdminId()));
            }
            Join memberJoin = root.join("offshoreMembers", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getMemberId())) {
                predicates.add(cb.equal(memberJoin.get("userId").as(Long.class), (Object)query.getMemberId()));
            }
            Join ruleJoin = root.join("offshoreRule", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getDistributeReceiveRule())) {
                predicates.add(cb.equal(ruleJoin.get("distributeReceiveRule").as(String.class), (Object)query.getDistributeReceiveRule()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmOffshoreDO> findAll(Specification<CrmOffshoreDO> spec) {
        return this.repo.findAll(spec);
    }

    public Page<CrmOffshoreDO> findAll(Specification<CrmOffshoreDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return this.repo.findAll(spec, pageable);
    }

    public CrmOffshoreDO queryById(Long id) {
        if (id != null) {
            return this.repo.findById(id).orElse(null);
        }
        return null;
    }

    public int countByOffshoreAdmin(Long userId) {
        CrmOffshoreQuery query = new CrmOffshoreQuery();
        query.setOffshoreAdminId(userId);
        Specification<CrmOffshoreDO> spec = this.getSpec(query);
        long count = this.repo.count(spec);
        return Integer.parseInt(String.valueOf(count));
    }

    public CrmOffshoreDO queryByOffshoreName(String offshoreName) {
        return this.repo.findByOffshoreName(offshoreName);
    }

    public int countLeads(Long offshoreId) {
        return this.leadsOffshoreRepo.countByOffshore_Id(offshoreId);
    }

    public List<CrmLeadsOffshoreDO> queryOffshoreLeads(Long offshoreId) {
        return this.leadsOffshoreRepo.findByOffshore_Id(offshoreId);
    }

    public List<Long> queryOffshoreIdsByName(List<String> toList) {
        return this.repo.queryOffshoreIdsByName(toList);
    }

    public CrmOffshoreDAO(JPAQueryFactory jpaQueryFactory, CrmOffshoreRepo repo, CrmLeadsOffshoreRepo leadsOffshoreRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.leadsOffshoreRepo = leadsOffshoreRepo;
    }
}

