/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamResultConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamResultDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamResultDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamResultRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdPerformanceExamResultServiceImpl
implements PrdPerformanceExamResultService {
    private static final Logger log = LoggerFactory.getLogger(PrdPerformanceExamResultServiceImpl.class);
    private final PrdPerformanceExamResultDao prdPerformanceExamResultDao;
    private final PrdPerformanceExamResultRepo prdPerformanceExamResultRepo;
    private final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;
    private final PrdPerformanceExamPointService prdPerformanceExamPointService;
    private final PrdEvaluateService prdEvaluateService;
    private final CalTaskSettleService calTaskSettleService;
    private final VacationService vacationService;
    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamResultVO save(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        this.checkData(prdPerformanceExamResultPayload);
        PrdPerformanceExamResultDO prdPerformanceExamResultDO = new PrdPerformanceExamResultDO();
        prdPerformanceExamResultDO = PrdPerformanceExamResultConvert.INSTANCE.p2d(prdPerformanceExamResultPayload);
        PrdPerformanceExamResultDO res = (PrdPerformanceExamResultDO)((Object)this.prdPerformanceExamResultRepo.save((Object)prdPerformanceExamResultDO));
        PrdPerformanceExamPointQuery prdPerformanceExamPointQuery = new PrdPerformanceExamPointQuery();
        prdPerformanceExamPointQuery.setExamId(prdPerformanceExamResultPayload.getExamId());
        List pointVOList = this.prdPerformanceExamPointService.getList(prdPerformanceExamPointQuery);
        pointVOList.forEach(x -> {
            PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload = new PrdPerformanceExamResDtlPayload();
            prdPerformanceExamResDtlPayload.setResultId(res.getId());
            prdPerformanceExamResDtlPayload.setPointId(x.getId());
            prdPerformanceExamResDtlPayload.setWeightRatio(x.getWeightRatio());
            prdPerformanceExamResDtlPayload.setPointName(x.getName());
            prdPerformanceExamResDtlPayload.setEvalUser(x.getName());
            prdPerformanceExamResDtlPayload.setScoreType(x.getScoreType());
            prdPerformanceExamResDtlPayload.setStandardDesc(x.getStandardDesc());
            if (x.getScoreType().equals(HrBaseEnum.SYSTEM_AUTO.getCode())) {
                if (x.getName().equals(HrBaseEnum.EXAM_EQVA_YEAR.getCode())) {
                    LocalDate currentDate = LocalDate.now();
                    LocalDate firstDayOfYear = currentDate.with(TemporalAdjusters.firstDayOfYear());
                    LocalDate lastDayOfYear = currentDate.with(TemporalAdjusters.lastDayOfYear());
                    BigDecimal score = this.dealScore(prdPerformanceExamResultPayload, firstDayOfYear, lastDayOfYear, prdPerformanceExamResDtlPayload);
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());
                } else if (x.getName().equals(HrBaseEnum.EXAM_EQVA.getCode())) {
                    LocalDate startPeriodDate = prdPerformanceExamResultPayload.getExamStartPeriod();
                    LocalDate endPeriodDate = prdPerformanceExamResultPayload.getExamEndPeriod();
                    BigDecimal score = this.dealScore(prdPerformanceExamResultPayload, startPeriodDate, endPeriodDate, prdPerformanceExamResDtlPayload);
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());
                } else if (x.getName().equals(HrBaseEnum.TASK_EVALUATION.getCode())) {
                    PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
                    prdEvaluateQuery.setToEvalUserId(prdPerformanceExamResultPayload.getUserId());
                    prdEvaluateQuery.setCate("TASK");
                    List prdEvaluateVOList = this.prdEvaluateService.getScoreListByUserId(prdEvaluateQuery);
                    BigDecimal score = new BigDecimal("60");
                    if (CollectionUtil.isNotEmpty((Collection)prdEvaluateVOList)) {
                        BigDecimal sumScore = new BigDecimal("10").multiply(new BigDecimal(prdEvaluateVOList.size()));
                        BigDecimal average = prdEvaluateVOList.stream().map(vo -> ObjectUtils.isEmpty((Object)vo.getAverageScore()) ? new BigDecimal(0) : vo.getAverageScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
                        score = average.divide(sumScore, 2, 4);
                        log.info("\u4efb\u52a1\u5f97\u5206\u4e3a\uff1a{}", (Object)score);
                    }
                    prdPerformanceExamResDtlPayload.setSysExam("\u4efb\u52a1\u8bc4\u5206:" + score);
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());
                }
            }
            this.prdPerformanceExamResDtlService.save(prdPerformanceExamResDtlPayload);
        });
        return PrdPerformanceExamResultConvert.INSTANCE.d2v(res);
    }

    private BigDecimal dealScore(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload, LocalDate firstDayOfYear, LocalDate lastDayOfYear, PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {
        BigDecimal edDl = this.getEdEqva(firstDayOfYear, lastDayOfYear, prdPerformanceExamResultPayload.getUserId());
        CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
        calTaskSettleQuery.setSettleStartDate(firstDayOfYear);
        calTaskSettleQuery.setSettleEndDate(lastDayOfYear);
        calTaskSettleQuery.setIncomeResId(prdPerformanceExamResultPayload.getUserId());
        List calTaskSettleVOS = this.calTaskSettleService.queryListDynamic(calTaskSettleQuery);
        BigDecimal jsDl = calTaskSettleVOS.stream().map(x1 -> ObjectUtils.isEmpty((Object)x1.getApproveSettleEqva()) ? BigDecimal.ZERO : x1.getApproveSettleEqva()).reduce(BigDecimal.ZERO, BigDecimal::add);
        prdPerformanceExamResDtlPayload.setSysExam("\u989d\u5b9a\u5f53\u91cf\u4e3a: " + edDl + ",\u5df2\u7ed3\u7b97\u5f53\u91cf\u4e3a:" + jsDl);
        log.info("\u989d\u5b9a\u5f53\u91cf\u4e3a: " + edDl + ",\u5df2\u7ed3\u7b97\u5f53\u91cf\u4e3a:" + jsDl);
        BigDecimal score = jsDl.divide(edDl, 2, 4);
        return score;
    }

    private void dealDate(PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO, LocalDate startDate, LocalDate endDate) {
        if (prdOrgEmployeeEqvaRatioVO.getStartDate().isBefore(startDate)) {
            prdOrgEmployeeEqvaRatioVO.setStartDate(startDate);
        }
        if (null == prdOrgEmployeeEqvaRatioVO.getEndDate()) {
            prdOrgEmployeeEqvaRatioVO.setEndDate(endDate);
        }
        if (prdOrgEmployeeEqvaRatioVO.getEndDate().isAfter(endDate)) {
            prdOrgEmployeeEqvaRatioVO.setEndDate(endDate);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamResultVO update(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        Assert.notNull((Object)prdPerformanceExamResultPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdPerformanceExamResultVO res = this.save(prdPerformanceExamResultPayload);
        return res;
    }

    public PrdPerformanceExamResultVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdPerformanceExamResultVO res = this.prdPerformanceExamResultDao.get(id);
        if (null != res.getExamCreatUserId()) {
            String userName = this.cacheUtil.getUserName(res.getExamCreatUserId());
            res.setExamCreatUser(userName);
        }
        if (null != res.getUserId()) {
            res.setEmpName(this.cacheUtil.getUserName(res.getUserId()));
        }
        if (null != res.getBaseBuId()) {
            res.setBaseBuName(this.cacheUtil.getOrgName(res.getBaseBuId()));
        }
        PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery = new PrdPerformanceExamResDtlQuery();
        prdPerformanceExamResDtlQuery.setResultId(id);
        List list = this.prdPerformanceExamResDtlService.getList(prdPerformanceExamResDtlQuery);
        list.forEach(x -> {
            String userName = this.cacheUtil.getUserName(x.getEvalUserId());
            x.setEvalUser(userName);
        });
        res.setPrdPerformanceExamResDtlVOList(list);
        return res;
    }

    public PagingVO<PrdPerformanceExamResultVO> page(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {
        PagingVO<PrdPerformanceExamResultVO> res = this.prdPerformanceExamResultDao.page(prdPerformanceExamResultQuery);
        res.getRecords().forEach(x -> {
            if (null != x.getUserId()) {
                String userName = this.cacheUtil.getUserName(x.getUserId());
                x.setEmpName(userName);
            }
            if (null != x.getBaseBuId()) {
                String orgName = this.cacheUtil.getOrgName(x.getBaseBuId());
                x.setBaseBuName(orgName);
            }
        });
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdPerformanceExamResultDao.del(ids);
        return res;
    }

    public List<PrdPerformanceExamResultVO> getList(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {
        List<PrdPerformanceExamResultVO> res = this.prdPerformanceExamResultDao.getList(prdPerformanceExamResultQuery);
        return res;
    }

    private void checkData(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        if (null == prdPerformanceExamResultPayload.getUserId()) {
            throw new BusinessException("userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        Assert.notNull((Object)prdPerformanceExamResultPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdPerformanceExamResultDao.update(prdPerformanceExamResultPayload);
        return res;
    }

    public PrdPerformanceExamResultVO getBySelf(Long id) {
        if (null == id) {
            return null;
        }
        PrdPerformanceExamResultVO res = this.prdPerformanceExamResultDao.get(id);
        PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery = new PrdPerformanceExamResDtlQuery();
        prdPerformanceExamResDtlQuery.setResultId(id);
        List list = this.prdPerformanceExamResDtlService.getList(prdPerformanceExamResDtlQuery);
        list.forEach(x -> x.setEvalDesc(null));
        res.setPrdPerformanceExamResDtlVOList(list);
        return res;
    }

    public BigDecimal getEdEqva(LocalDate startDate, LocalDate endDate, Long userId) {
        Map<String, BigDecimal> utMap = PrdPerformanceExamResultServiceImpl.getStringBigDecimalMap();
        PrdOrgEmployeeEqvaRatioQuery prdOrgEmployeeEqvaRatioQuery = new PrdOrgEmployeeEqvaRatioQuery();
        prdOrgEmployeeEqvaRatioQuery.setUserId(userId);
        prdOrgEmployeeEqvaRatioQuery.setStartDate(startDate);
        prdOrgEmployeeEqvaRatioQuery.setEndDate(endDate);
        List eqvaRatioListByDate = this.eqvaRatioService.getEqvaRatioListByDate(prdOrgEmployeeEqvaRatioQuery);
        BigDecimal edDl = BigDecimal.ZERO;
        for (PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO : eqvaRatioListByDate) {
            this.dealDate(prdOrgEmployeeEqvaRatioVO, startDate, endDate);
            long workDay = this.vacationService.findWorkDay(prdOrgEmployeeEqvaRatioVO.getStartDate(), prdOrgEmployeeEqvaRatioVO.getEndDate());
            log.info("\u5f00\u59cb\u65f6\u95f4:" + prdOrgEmployeeEqvaRatioVO.getStartDate() + "\u7ed3\u675f\u65f6\u95f4\uff1a" + prdOrgEmployeeEqvaRatioVO.getEndDate() + "\u5bf9\u5e94\u5929\u6570:" + workDay);
            BigDecimal utVal = BigDecimal.ONE;
            if (null != utMap.get(prdOrgEmployeeEqvaRatioVO.getEqvaRatio().toString())) {
                utVal = utMap.get(prdOrgEmployeeEqvaRatioVO.getEqvaRatio().toString());
            }
            BigDecimal zDl = prdOrgEmployeeEqvaRatioVO.getEqvaRatio().multiply(new BigDecimal(workDay)).multiply(utVal);
            log.info("\u8be5\u65f6\u95f4\u6bb5\u7684\u5e94\u6709\u989d\u5b9a\u5f53\u91cf\u4e3a:" + zDl);
            edDl = edDl.add(zDl);
        }
        return edDl;
    }

    @Transactional
    public void delByRangeIds(List<Long> ids) {
        Long res = this.prdPerformanceExamResultDao.delByRangeIds(ids);
    }

    private static Map<String, BigDecimal> getStringBigDecimalMap() {
        HashMap<String, BigDecimal> utMap = new HashMap<String, BigDecimal>();
        utMap.put("0.20", new BigDecimal("1"));
        utMap.put("0.50", new BigDecimal("0.95"));
        utMap.put("0.60", new BigDecimal("0.93"));
        utMap.put("0.80", new BigDecimal("0.90"));
        utMap.put("1.00", new BigDecimal("0.90"));
        utMap.put("1.20", new BigDecimal("0.88"));
        utMap.put("1.50", new BigDecimal("0.88"));
        utMap.put("1.60", new BigDecimal("0.85"));
        utMap.put("1.90", new BigDecimal("0.85"));
        utMap.put("2.00", new BigDecimal("0.85"));
        utMap.put("3.00", new BigDecimal("0.85"));
        utMap.put("3.50", new BigDecimal("0.85"));
        utMap.put("4.00", new BigDecimal("0.85"));
        return utMap;
    }

    public PrdPerformanceExamResultServiceImpl(PrdPerformanceExamResultDao prdPerformanceExamResultDao, PrdPerformanceExamResultRepo prdPerformanceExamResultRepo, PrdPerformanceExamResDtlService prdPerformanceExamResDtlService, PrdPerformanceExamPointService prdPerformanceExamPointService, PrdEvaluateService prdEvaluateService, CalTaskSettleService calTaskSettleService, VacationService vacationService, PrdOrgEmployeeEqvaRatioService eqvaRatioService, CacheUtil cacheUtil) {
        this.prdPerformanceExamResultDao = prdPerformanceExamResultDao;
        this.prdPerformanceExamResultRepo = prdPerformanceExamResultRepo;
        this.prdPerformanceExamResDtlService = prdPerformanceExamResDtlService;
        this.prdPerformanceExamPointService = prdPerformanceExamPointService;
        this.prdEvaluateService = prdEvaluateService;
        this.calTaskSettleService = calTaskSettleService;
        this.vacationService = vacationService;
        this.eqvaRatioService = eqvaRatioService;
        this.cacheUtil = cacheUtil;
    }
}

