/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEmployeCompositeAbilityConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.PrdEmployeCompositeAbilityDao;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.PrdEmployeCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.PrdEmployeCompositeAbilityRepo;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdEmployeCompositeAbilityServiceImpl
implements PrdEmployeCompositeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PrdEmployeCompositeAbilityServiceImpl.class);
    private final PrdEmployeCompositeAbilityDao prdEmployeCompositeAbilityDao;
    private final PrdEmployeCompositeAbilityRepo prdEmployeCompositeAbilityRepo;

    @Transactional(rollbackFor={Exception.class})
    public PrdEmployeCompositeAbilityVO save(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        if (null == prdEmployeCompositeAbilityPayload.getState()) {
            prdEmployeCompositeAbilityPayload.setState(Integer.valueOf(1));
        }
        this.checkData(prdEmployeCompositeAbilityPayload);
        prdEmployeCompositeAbilityPayload.setObtainTime(LocalDate.now());
        PrdEmployeCompositeAbilityDO prdEmployeCompositeAbilityDO = new PrdEmployeCompositeAbilityDO();
        prdEmployeCompositeAbilityDO = PrdEmployeCompositeAbilityConvert.INSTANCE.p2d(prdEmployeCompositeAbilityPayload);
        PrdEmployeCompositeAbilityDO res = (PrdEmployeCompositeAbilityDO)((Object)this.prdEmployeCompositeAbilityRepo.save((Object)prdEmployeCompositeAbilityDO));
        return PrdEmployeCompositeAbilityConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdEmployeCompositeAbilityVO update(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        Assert.notNull((Object)prdEmployeCompositeAbilityPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdEmployeCompositeAbilityVO res = this.save(prdEmployeCompositeAbilityPayload);
        return res;
    }

    public PrdEmployeCompositeAbilityVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdEmployeCompositeAbilityVO res = this.prdEmployeCompositeAbilityDao.get(id);
        return res;
    }

    public PagingVO<PrdEmployeCompositeAbilityVO> page(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {
        PagingVO<PrdEmployeCompositeAbilityVO> res = this.prdEmployeCompositeAbilityDao.page(prdEmployeCompositeAbilityQuery);
        res.getRecords().forEach(x -> x.setAbilityName(x.getAbilityName() + "-" + x.getLevelDtlName()));
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdEmployeCompositeAbilityDao.del(ids);
        return res;
    }

    public List<PrdEmployeCompositeAbilityVO> getList(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {
        if (null == prdEmployeCompositeAbilityQuery.getUserId()) {
            throw new BusinessException("userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PrdEmployeCompositeAbilityVO> res = this.prdEmployeCompositeAbilityDao.getList(prdEmployeCompositeAbilityQuery);
        res.forEach(x -> x.setAbilityName(x.getAbilityName() + "-" + x.getLevelDtlName()));
        return res;
    }

    @Transactional
    public Boolean batchSave(List<PrdEmployeCompositeAbilityPayload> prdEmployeCompositeAbilityPayload) {
        for (PrdEmployeCompositeAbilityPayload payload : prdEmployeCompositeAbilityPayload) {
            this.save(payload);
        }
        return true;
    }

    @Transactional
    public Long updateAbility(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        if (null != prdEmployeCompositeAbilityPayload.getMainFlag() && prdEmployeCompositeAbilityPayload.getMainFlag().booleanValue()) {
            this.prdEmployeCompositeAbilityDao.updateAllMainFlag();
        }
        if (null != prdEmployeCompositeAbilityPayload.getAuxFlag() && prdEmployeCompositeAbilityPayload.getAuxFlag().booleanValue()) {
            this.prdEmployeCompositeAbilityDao.updateAllAuxFlag();
        }
        Long res = this.prdEmployeCompositeAbilityDao.updateAbility(prdEmployeCompositeAbilityPayload);
        return res;
    }

    @Transactional
    public Boolean updateStateByFormId(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        Boolean res = this.prdEmployeCompositeAbilityDao.updateStateByFormId(prdEmployeCompositeAbilityPayload);
        return res;
    }

    private void checkData(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        if (null == prdEmployeCompositeAbilityPayload.getUserId()) {
            throw new BusinessException("userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEmployeCompositeAbilityPayload.getAbilityLevelId()) {
            throw new BusinessException("abilityLevelId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdEmployeCompositeAbilityServiceImpl(PrdEmployeCompositeAbilityDao prdEmployeCompositeAbilityDao, PrdEmployeCompositeAbilityRepo prdEmployeCompositeAbilityRepo) {
        this.prdEmployeCompositeAbilityDao = prdEmployeCompositeAbilityDao;
        this.prdEmployeCompositeAbilityRepo = prdEmployeCompositeAbilityRepo;
    }
}

