/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.VacationQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.VacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class VacationServiceImpl
implements VacationService {
    private static final Logger log = LoggerFactory.getLogger(VacationServiceImpl.class);
    private final VacationDAO vacationDAO;
    private final VacationRepo vacationRepo;
    private final PersonResService personResService;
    private final PmsTimesheetService pmsTimesheetService;
    private final CacheUtil cacheUtil;

    public Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate) {
        return this.vacationRepo.selectWorkHoursByDate(startDate, endDate);
    }

    public List<VacationVO> findListByYear(int year) {
        List<VacationDO> vacationDOList = this.vacationRepo.selectByYear(year);
        ArrayList<VacationVO> voList = new ArrayList<VacationVO>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties((Object)((Object)vacationDO), (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    public List<VacationVO> findVacationList(VacationQuery query) {
        List<VacationDO> vacationDOList = this.vacationRepo.selectByQuery(query);
        ArrayList<VacationVO> voList = new ArrayList<VacationVO>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties((Object)((Object)vacationDO), (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    public void saveVacation(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setWorkHours(Float.valueOf(8.0f));
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties((Object)vacation, (Object)((Object)vacationDO));
            int count = this.vacationRepo.updateVacationByKey(vacationDO);
            if (count == 0) {
                this.vacationRepo.save((Object)vacationDO);
            }
        });
    }

    public void saveJdeExport(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setJdeExportFlag(Byte.valueOf((byte)1));
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties((Object)vacation, (Object)((Object)vacationDO));
            int count = this.vacationRepo.updateJdeExportFlagByKey(vacationDO);
            if (count == 0) {
                this.vacationRepo.save((Object)vacationDO);
            }
        });
    }

    public long findWorkDay(LocalDate startDate, LocalDate endDate) {
        long res = this.vacationDAO.findWorkDay(startDate, endDate);
        return res;
    }

    public List<LocalDate> findWorkLocalDay(LocalDate startDate, LocalDate endDate) {
        return this.vacationDAO.findWorkLocalDay(startDate, endDate);
    }

    @Transactional
    public void taskGenerateTimesheet(String param) {
        LocalDate today = LocalDate.now();
        if (StringUtils.hasText((String)param)) {
            try {
                today = LocalDate.parse(param, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LocalDate monthDayFirst = today.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate monthDayLast = today.with(TemporalAdjusters.lastDayOfMonth());
        List<LocalDate> vacationDay = this.findVacationDay(monthDayFirst, monthDayLast);
        PrdOrgEmployeeQuery prdOrgEmployeeQuery = new PrdOrgEmployeeQuery();
        List empUserList = this.personResService.getJobingUserList(prdOrgEmployeeQuery);
        ArrayList<TimesheetPayload> timesheetPayloadList = new ArrayList<TimesheetPayload>();
        if (!CollectionUtils.isEmpty(vacationDay)) {
            TimesheetQuery queryWeek = new TimesheetQuery();
            queryWeek.setWorkDateIn(vacationDay);
            List timeSheets = this.pmsTimesheetService.queryList(queryWeek);
            for (Long userId : empUserList) {
                block3: for (LocalDate naturalDate : vacationDay) {
                    for (TimesheetVO timesheetListView : timeSheets) {
                        if (!timesheetListView.getWorkDate().equals(naturalDate) || !timesheetListView.getTsUserId().equals(userId)) continue;
                        continue block3;
                    }
                    TimesheetPayload entity = new TimesheetPayload();
                    entity.setTsUserId(userId);
                    entity.setWorkDate(naturalDate);
                    entity.setWorkDesc("\u6cd5\u5b9a\u5047\u65e5");
                    entity.setTsStatus(TimesheetStatus.APPROVING.getCode());
                    entity.setApprResult(TimesheetStatus.APPROVING.getDesc());
                    entity.setProjId(Long.valueOf(0L));
                    entity.setTaskPackageId(null);
                    entity.setTaskId(null);
                    entity.setActId(null);
                    entity.setTsTaskIden("VACATION");
                    entity.setTsActIden("LEGALHOLIDAY");
                    entity.setWorkHour(new BigDecimal("8.0"));
                    entity.setWorkDayOffStatus("UNGEN");
                    entity.setWorkFlag("NO");
                    entity.setSettleStatus("NONE");
                    entity.setWeekStartDate(naturalDate.with(DayOfWeek.MONDAY));
                    entity.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(naturalDate))));
                    Long tsBuId = this.cacheUtil.getDefaultOrgIdByUserId(userId);
                    entity.setTsUserBuId(tsBuId);
                    entity.setApprUserId(Long.valueOf(1381L));
                    entity.setAutoSaveFlag(Integer.valueOf(1));
                    entity.setSubmitTime(LocalDateTime.now());
                    timesheetPayloadList.add(entity);
                }
            }
        }
        this.pmsTimesheetService.saveAllForAutoCreate(timesheetPayloadList);
    }

    public List<LocalDate> findVacationDay(LocalDate startDate, LocalDate endDate) {
        List<LocalDate> res = this.vacationDAO.findVacationDay(startDate, endDate);
        return res;
    }

    public VacationServiceImpl(VacationDAO vacationDAO, VacationRepo vacationRepo, PersonResService personResService, PmsTimesheetService pmsTimesheetService, CacheUtil cacheUtil) {
        this.vacationDAO = vacationDAO;
        this.vacationRepo = vacationRepo;
        this.personResService = personResService;
        this.pmsTimesheetService = pmsTimesheetService;
        this.cacheUtil = cacheUtil;
    }
}

