/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgRoleRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class PrdOrgOrganizationDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgOrganizationRepo repo;
    private final PrdOrgOrganizationRefRepo refRepo;
    private final PrdOrgEmployeeRefRepo employeeRefRepo;
    private final PrdOrgRoleRepo roleRepo;
    private final QPrdOrgOrganizationDO qdo = new QPrdOrgOrganizationDO("prdOrgOrganizationDO");
    private final QPrdOrgOrganizationDO o_qdo = new QPrdOrgOrganizationDO("prdOrgOrganizationDO1");
    private final QPrdOrgOrganizationRefDO qdoRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdOrgDimensionDO qdoDim = QPrdOrgDimensionDO.prdOrgDimensionDO;

    private JPAQuery<PrdOrgOrganizationVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.orgName, this.qdo.orgCode, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5, this.qdo.extString6, this.qdo.extString7, this.qdo.extString8, this.qdo.extString9, this.qdo.extString10, this.qdo.manageId, this.qdoEmployee.employeeName.as("manageName"), this.qdoRef.parentId, this.o_qdo.orgName.as("parentName"), this.qdoDim.dimensionName, this.qdo.isBu, this.qdo.orgStatus, this.qdo.jdeOrgCode})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()))).leftJoin((EntityPath)this.o_qdo)).on((Predicate)this.o_qdo.id.longValue().eq((Expression)this.qdoRef.parentId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdo.manageId.longValue().eq((Expression)this.qdoEmployee.userId.longValue()))).leftJoin((EntityPath)this.qdoDim)).on((Predicate)this.qdo.dimensionId.longValue().eq((Expression)this.qdoDim.id.longValue()));
        return jpaQuery;
    }

    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryWhere(PrdOrgOrganizationQuery query) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdoRef.orgType.eq((Object)1));
        if (!ObjectUtils.isEmpty((Object)query.getDimensionId())) {
            jpaQuery.where((Predicate)this.qdo.dimensionId.eq((Object)query.getDimensionId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            jpaQuery.where((Predicate)this.qdoRef.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgName())) {
            jpaQuery.where((Predicate)this.qdo.orgName.like(SqlUtil.toSqlLikeString(query.getOrgName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgCode())) {
            jpaQuery.where((Predicate)this.qdo.orgCode.eq((Object)query.getOrgCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageId())) {
            jpaQuery.where((Predicate)this.qdo.manageId.eq((Object)query.getManageId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgStatus())) {
            jpaQuery.where((Predicate)this.qdo.orgStatus.eq((Object)query.getOrgStatus()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getOrgStatusList())) {
            jpaQuery.where((Predicate)this.qdo.orgStatus.in((Collection)query.getOrgStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsBu())) {
            jpaQuery.where((Predicate)this.qdo.isBu.eq((Object)query.getIsBu()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgIdList())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Collection)query.getOrgIdList()));
        }
        jpaQuery.where((Predicate)this.qdoDim.versionId.eq((Object)0L));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoRef, SqlUtil.getOrderse()));
        jpaQuery.groupBy(this.qdo.id);
        return jpaQuery;
    }

    public PagingVO<PrdOrgOrganizationVO> queryPaging(PrdOrgOrganizationQuery query) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdOrgRoleVO> getJpaQueryRoleSelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgRoleVO.class, (Expression[])new Expression[]{this.qdoRole.id, this.qdoRole.orgId, this.qdoRole.roleName, this.qdoRole.roleCode, this.qdoRole.roleEmployees, this.qdoRole.extString1, this.qdoRole.extString2, this.qdoRole.extString3, this.qdoRole.extString4, this.qdoRole.extString5, this.qdoRole.extString6, this.qdoRole.extString7, this.qdoRole.extString8, this.qdoRole.extString9, this.qdoRole.extString10, this.qdoRole.remark})).from((EntityPath)this.qdoRole);
        return jpaQuery;
    }

    public List<PrdOrgRoleVO> queryRoleList(Long orgId) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = this.getJpaQueryRoleSelect();
        if (orgId != null) {
            jpaQuery.where((Predicate)this.qdoRole.orgId.eq((Object)orgId));
        }
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdOrgRoleVO queryRoleByOrgIdAndRoleCode(Long orgId, String roleCode) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = this.getJpaQueryRoleSelect();
        if (orgId != null) {
            jpaQuery.where((Predicate)this.qdoRole.orgId.eq((Object)orgId));
        }
        if (roleCode != null) {
            jpaQuery.where((Predicate)this.qdoRole.roleCode.eq((Object)roleCode));
        }
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        return (PrdOrgRoleVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryOrgSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.orgName, this.qdo.orgCode, this.qdo.jdeOrgCode, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5, this.qdo.extString6, this.qdo.extString7, this.qdo.extString8, this.qdo.extString9, this.qdo.extString10, this.qdo.manageId, this.qdoEmployee.employeeName.as("manageName"), this.qdo.isBu, this.qdo.orgStatus, this.qdo.organizationType})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdo.manageId.longValue().eq((Expression)this.qdoEmployee.userId.longValue()).and((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0)));
        return jpaQuery;
    }

    public PrdOrgOrganizationVO queryOrgById(Long orgId) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = this.getJpaQueryOrgSelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryOrgDataSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.orgName, this.qdo.orgCode, this.qdo.orgStatus})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.id.longValue().eq((Expression)this.qdoRef.parentId.longValue()));
        return jpaQuery;
    }

    public PrdOrgOrganizationVO queryParentOrgById(Long orgId) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = this.getJpaQueryOrgDataSelect();
        jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoRef.orgType.eq((Object)1));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationVO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgEmployeeRefVO> queryRoleEmployeeList(List<Long> keys) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeRefVO.class, (Expression[])new Expression[]{this.qdoEmployee.employeeName, this.qdoEmployee.userId})).from((EntityPath)this.qdoEmployee);
        jpaQuery.where((Predicate)this.qdoEmployee.userId.in(keys));
        jpaQuery.where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryEmployeeRefSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeRefVO.class, (Expression[])new Expression[]{this.qdoEmployeeRef.id, this.qdoEmployee.employeeName, this.qdoEmployee.id.as("employeeId"), this.qdoEmployeeRef.orgId, this.qdoEmployeeRef.userId, this.qdoEmployeeRef.sortIndex, this.qdoEmployeeRef.parentId})).from((EntityPath)this.qdoEmployee)).leftJoin((EntityPath)this.qdoEmployeeRef)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdoEmployeeRef.userId.longValue()));
        return jpaQuery;
    }

    public List<PrdOrgEmployeeRefVO> queryEmployeeList(Long orgId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = this.getJpaQueryEmployeeRefSelect();
        jpaQuery.where((Predicate)this.qdoEmployeeRef.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.statusFlag.isNull().or((Predicate)this.qdoEmployeeRef.statusFlag.eq((Object)1)));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployee.resourceStatus.notIn((Object[])new String[]{"6", "2", "1"}));
        jpaQuery.where((Predicate)this.qdoEmployee.hrStatus.eq((Object)"ACTIVE"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoEmployeeRef, SqlUtil.getOrderse()));
        jpaQuery.groupBy(this.qdoEmployeeRef.userId);
        return jpaQuery.fetch();
    }

    public List<PrdOrgEmployeeRefVO> queryEmployeeList(Set<Long> orgIds) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = this.getJpaQueryEmployeeRefSelect();
        jpaQuery.where((Predicate)this.qdoEmployeeRef.orgId.in(orgIds));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoEmployee.resourceStatus.ne((Object)String.valueOf(6)));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoEmployeeRef, SqlUtil.getOrderse()));
        jpaQuery.groupBy(this.qdoEmployeeRef.userId);
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgOrganizationRefVO> getJpaQueryOrgRefSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationRefVO.class, (Expression[])new Expression[]{this.qdoRef.id, this.qdo.dimensionId, this.qdo.orgName, this.qdo.orgCode, this.qdo.manageId, this.qdo.extString1.as("buLevel"), this.qdoRef.sortIndex, this.qdoRef.orgId, this.qdoRef.parentId, this.qdoRef.orgType, this.qdo.orgStatus, this.qdo.organizationType})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()))).leftJoin((EntityPath)this.qdoDim)).on((Predicate)this.qdoDim.id.longValue().eq((Expression)this.qdoRef.dimensionId.longValue()));
        return jpaQuery;
    }

    public List<PrdOrgOrganizationRefVO> queryOrgList(Long dimensionId, String orgStatus) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = this.getJpaQueryOrgRefSelect();
        if (dimensionId != null) {
            if (dimensionId > -1L) {
                jpaQuery.where((Predicate)this.qdoDim.id.eq((Object)dimensionId));
            } else {
                jpaQuery.where((Predicate)this.qdoDim.versionId.eq((Object)0L));
            }
        } else {
            jpaQuery.where((Predicate)this.qdoDim.defaultFlag.eq((Object)0).and((Predicate)this.qdoDim.versionId.eq((Object)0L)));
        }
        jpaQuery.where((Predicate)this.qdoDim.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        if (StringUtils.hasText((String)orgStatus)) {
            jpaQuery.where((Predicate)this.qdo.orgStatus.eq((Object)orgStatus));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoRef, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgOrganizationRefVO> getJpaQueryAllOrgRefSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationRefVO.class, (Expression[])new Expression[]{this.qdo.id.as("orgId"), this.qdo.orgName, this.qdo.dimensionId, this.qdoRef.parentId, this.qdo.orgStatus, this.qdo.manageId, this.qdo.organizationType, this.qdo.extString1.as("buLevel"), this.qdoDim.dimensionName, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoDim)).on((Predicate)this.qdo.dimensionId.longValue().eq((Expression)this.qdoDim.id.longValue()))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()));
        return jpaQuery;
    }

    public List<PrdOrgOrganizationRefVO> queryAll(String code, Long dimensionId, Boolean defaultFlag) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = this.getJpaQueryAllOrgRefSelect();
        jpaQuery.where((Predicate)this.qdoDim.versionId.eq((Object)0L));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoDim.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.orgStatus.eq((Object)SystemDefaultEnum.DefaultOrgStatus.getCode()));
        if (code != null && !code.equals("")) {
            jpaQuery.where((Predicate)this.qdo.orgCode.eq((Object)code));
        }
        if (dimensionId != null) {
            jpaQuery.where((Predicate)this.qdo.dimensionId.ne((Object)dimensionId));
        } else {
            jpaQuery.where((Predicate)this.qdoDim.defaultFlag.eq((Object)0));
        }
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.orgType.eq((Object)1));
        return jpaQuery.fetch();
    }

    public List<PrdOrgOrganizationRefVO> queryByOrgStatus(String orgStatus) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = this.getJpaQueryAllOrgRefSelect();
        jpaQuery.where((Predicate)this.qdoDim.versionId.eq((Object)0L));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoDim.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoDim.defaultFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.orgType.eq((Object)1));
        if (!ObjectUtils.isEmpty((Object)orgStatus)) {
            jpaQuery.where((Predicate)this.qdo.orgStatus.eq((Object)orgStatus));
        }
        return jpaQuery.fetch();
    }

    public List<PrdOrgOrganizationVO> queryAll(PrdOrgOrganizationQuery query) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PrdOrgOrganizationDO save(PrdOrgOrganizationDO ado) {
        return (PrdOrgOrganizationDO)this.repo.save(ado);
    }

    public List<PrdOrgEmployeeRefDO> saveEmployeeRef(List<PrdOrgEmployeeRefDO> employeeRefDOs) {
        return this.employeeRefRepo.saveAll(employeeRefDOs);
    }

    public long updateEmployeeRefFlag(List<Long> userIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoEmployeeRef).set(this.qdoEmployeeRef.deleteFlag, (Object)1).set(this.qdoEmployeeRef.leaveDate, (Object)LocalDate.now()).where(new Predicate[]{this.qdoEmployeeRef.userId.in(userIds)}).where(new Predicate[]{this.qdoEmployeeRef.isCopy.eq((Object)0)});
        return update.execute();
    }

    public long updateEmployeeRefStatus(List<Long> userIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoEmployeeRef).set(this.qdoEmployeeRef.isDefault, (Object)1).where(new Predicate[]{this.qdoEmployeeRef.userId.in(userIds)}).where(new Predicate[]{this.qdoEmployeeRef.isCopy.eq((Object)0)});
        return update.execute();
    }

    public long deleteEmployeeRefSoft(Long orgId, List<Long> userIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoEmployeeRef).set(this.qdoEmployeeRef.deleteFlag, (Object)1).set(this.qdoEmployeeRef.leaveDate, (Object)LocalDate.now()).where(new Predicate[]{this.qdoEmployeeRef.orgId.eq((Object)orgId)}).where(new Predicate[]{this.qdoEmployeeRef.isDefault.eq((Object)1)}).where(new Predicate[]{this.qdoEmployeeRef.userId.in(userIds)});
        return update.execute();
    }

    public PrdOrgOrganizationRefDO saveRef(PrdOrgOrganizationRefDO ado) {
        return (PrdOrgOrganizationRefDO)this.refRepo.save(ado);
    }

    public PrdOrgOrganizationRefVO queryByRefId(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.dimensionId})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationRefVO)jpaQuery.fetchFirst();
    }

    public PrdOrgOrganizationRefDO queryByDimensionIdOrOrgId(Long dimensionId, Long orgId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRef).from((EntityPath)this.qdoRef);
        jpaQuery.where((Predicate)this.qdoRef.dimensionId.eq((Object)dimensionId));
        jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationRefDO)jpaQuery.fetchFirst();
    }

    public List<Long> queryByManageIdOrgIds(Long manageId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.manageId.eq((Object)manageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long updateRef(PrdOrgOrganizationRefPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRef).where(new Predicate[]{this.qdoRef.dimensionId.longValue().eq((Object)payload.getDimensionId())}).where(new Predicate[]{this.qdoRef.orgId.eq((Object)payload.getOrgId())}).set(this.qdoRef.parentId, (Object)payload.getParentId());
        return update.execute();
    }

    public long updateByKeyDynamic(PrdOrgOrganizationPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getOrgName() != null) {
            update.set((Path)this.qdo.orgName, (Object)payload.getOrgName());
        }
        if (payload.getOrgCode() != null) {
            update.set((Path)this.qdo.orgCode, (Object)payload.getOrgCode());
        }
        if (payload.getManageId() != null) {
            update.set(this.qdo.manageId, (Object)payload.getManageId());
        }
        if (payload.getOrganizationType() != null) {
            update.set((Path)this.qdo.organizationType, (Object)payload.getOrganizationType());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set((Path)this.qdo.extString1, (Object)payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set((Path)this.qdo.extString2, (Object)payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set((Path)this.qdo.extString3, (Object)payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set((Path)this.qdo.extString4, (Object)payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set((Path)this.qdo.extString5, (Object)payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set((Path)this.qdo.extString6, (Object)payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set((Path)this.qdo.extString7, (Object)payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set((Path)this.qdo.extString8, (Object)payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set((Path)this.qdo.extString9, (Object)payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set((Path)this.qdo.extString10, (Object)payload.getExtString10());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdo.remark);
        }
        return update.execute();
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public long deleteRefSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRef).set(this.qdoRef.deleteFlag, (Object)1).where(new Predicate[]{this.qdoRef.id.eq((Object)key)});
        return update.execute();
    }

    public long deleteAllRefSoft(Long orgId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRef).set(this.qdoRef.deleteFlag, (Object)1).where(new Predicate[]{this.qdoRef.orgId.eq((Object)orgId)});
        return update.execute();
    }

    public PrdOrgRoleDO saveRole(PrdOrgRoleDO ado) {
        return (PrdOrgRoleDO)this.roleRepo.save(ado);
    }

    public long updateRole(PrdOrgRolePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRole).where(new Predicate[]{this.qdoRole.id.eq((Object)payload.getId())});
        if (payload.getRoleName() != null) {
            update.set((Path)this.qdoRole.roleName, (Object)payload.getRoleName());
        }
        if (payload.getRoleCode() != null) {
            update.set((Path)this.qdoRole.roleCode, (Object)payload.getRoleCode());
        }
        if (payload.getRoleEmployees() != null) {
            update.set((Path)this.qdoRole.roleEmployees, (Object)payload.getRoleEmployees());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdoRole.remark, (Object)payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set((Path)this.qdoRole.extString1, (Object)payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set((Path)this.qdoRole.extString2, (Object)payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set((Path)this.qdoRole.extString3, (Object)payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set((Path)this.qdoRole.extString4, (Object)payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set((Path)this.qdoRole.extString5, (Object)payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set((Path)this.qdoRole.extString6, (Object)payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set((Path)this.qdoRole.extString7, (Object)payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set((Path)this.qdoRole.extString8, (Object)payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set((Path)this.qdoRole.extString9, (Object)payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set((Path)this.qdoRole.extString10, (Object)payload.getExtString10());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdoRole.remark);
        }
        return update.execute();
    }

    public PrdOrgOrganizationRefDO queryFirstByParentId(Long parentId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRef).from((EntityPath)this.qdoRef);
        jpaQuery.where((Predicate)this.qdoRef.parentId.eq((Object)parentId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationRefDO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationRefDO> queryAllByParentId(Long parentId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRef).from((EntityPath)this.qdoRef);
        jpaQuery.where((Predicate)this.qdoRef.parentId.eq((Object)parentId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdOrgOrganizationDO queryById(Long orgId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationDO)jpaQuery.fetchFirst();
    }

    public PrdOrgOrganizationDO queryByOrgCode(String orgCode) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.orgCode.eq((Object)orgCode));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationDO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationDO> queryByOrgCode(List<String> orgCodes) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.orgCode.in(orgCodes));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdOrgOrganizationDO queryByName(String orgName) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.orgName.eq((Object)orgName));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationDO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationDO> queryByManagerId(Long manageId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.manageId.eq((Object)manageId));
        jpaQuery.where((Predicate)this.qdo.orgStatus.eq((Object)SystemDefaultEnum.DefaultOrgStatus.getCode()));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public Set<Long> queryAllChildOrgs(Set<Long> orgIdList) {
        Set<Long> childOrgs = this.repo.queryChildOrgs(orgIdList);
        if (!CollectionUtils.isEmpty(childOrgs)) {
            Set<Long> childOrgs1 = this.queryAllChildOrgs(childOrgs);
            childOrgs.addAll(childOrgs1);
        }
        return childOrgs;
    }

    public long updateRoleEmployees(Long orgId, String roleCode, String roleEmployees) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRole).set((Path)this.qdoRole.roleEmployees, (Object)roleEmployees).where(new Predicate[]{this.qdoRole.orgId.eq((Object)orgId)}).where(new Predicate[]{this.qdoRole.roleCode.eq((Object)roleCode)});
        return update.execute();
    }

    public long deleteRoleSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRole).set(this.qdoRole.deleteFlag, (Object)1).where(new Predicate[]{this.qdoRole.id.eq((Object)key)});
        return update.execute();
    }

    public long updateStatus(Long id, String orgStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)id)}).set((Path)this.qdo.orgStatus, (Object)orgStatus);
        return update.execute();
    }

    public PrdOrgRoleDO queryRoleByKey(Long key) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRole).from((EntityPath)this.qdoRole);
        jpaQuery.where((Predicate)this.qdoRole.id.eq((Object)key));
        return (PrdOrgRoleDO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationRefDO> queryByOrgRefIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRef).from((EntityPath)this.qdoRef);
        jpaQuery.where((Predicate)this.qdoRef.id.in(ids));
        return jpaQuery.fetch();
    }

    public List<PrdOrgEmployeeRefDO> queryByEmployeeRefIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoEmployeeRef).from((EntityPath)this.qdoEmployeeRef);
        jpaQuery.where((Predicate)this.qdoEmployeeRef.id.in(ids));
        return jpaQuery.fetch();
    }

    public PrdOrgEmployeeRefDO queryByOrgIdAndEmpId(Long orgId, Long userId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoEmployeeRef).from((EntityPath)this.qdoEmployeeRef);
        jpaQuery.where((Predicate)this.qdoEmployeeRef.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0));
        return (PrdOrgEmployeeRefDO)jpaQuery.fetchFirst();
    }

    public long updateOrgRef(PrdOrgOrganizationRefDO payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoRef).where(new Predicate[]{this.qdoRef.id.longValue().eq((Object)payload.getId())});
        if (payload.getParentId() != null) {
            update.set(this.qdoRef.parentId, (Object)payload.getParentId());
        }
        if (payload.getSortIndex() != null) {
            update.set(this.qdoRef.sortIndex, (Object)payload.getSortIndex());
        }
        return update.execute();
    }

    public long updateEmployeeRef(PrdOrgEmployeeRefDO payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoEmployeeRef).where(new Predicate[]{this.qdoEmployeeRef.id.longValue().eq((Object)payload.getId())});
        if (payload.getOrgId() != null) {
            update.set(this.qdoEmployeeRef.orgId, (Object)payload.getOrgId());
        }
        if (payload.getSortIndex() != null) {
            update.set(this.qdoEmployeeRef.sortIndex, (Object)payload.getSortIndex());
        }
        return update.execute();
    }

    public Long queryManageIdByCode(String code) {
        PrdOrgOrganizationDO prdOrgOrganizationDO = this.repo.queryByOrgCodeAndDeleteFlagAndIsCopy(code, 0, 0).orElse(null);
        if (prdOrgOrganizationDO != null) {
            return prdOrgOrganizationDO.getManageId();
        }
        return null;
    }

    public Long queryManageIdById(Long id) {
        PrdOrgOrganizationDO prdOrgOrganizationDO = this.repo.queryByIdAndDeleteFlagAndIsCopy(id, 0, 0).orElse(null);
        if (prdOrgOrganizationDO != null) {
            return prdOrgOrganizationDO.getManageId();
        }
        return null;
    }

    public Long getOrgIdByV4(Long orgIdV4) {
        return this.repo.getOrgIdByV4(orgIdV4);
    }

    public List<Map<String, Object>> queryOrgs(List<Long> orgIds) {
        return this.repo.queryOrgs(orgIds);
    }

    public List<Map<String, Object>> getV4AndV5OrgIds() {
        return this.repo.getV4AndV5OrgIds();
    }

    public List<PrdOrgOrganizationVO> queryByManageIdOrgs(Long manageId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgOrganizationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.orgName, this.qdo.orgCode})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.isCopy.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.manageId.eq((Object)manageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdOrgRoleVO> queryRolesByOrgIds(List<Long> orgIds) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = this.getJpaQueryRoleSelect();
        if (orgIds != null) {
            jpaQuery.where((Predicate)this.qdoRole.orgId.in(orgIds));
        }
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgRoleVO> getJpaQueryRoleSelect0() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgRoleVO.class, (Expression[])new Expression[]{this.qdoRole.id, this.qdoRole.orgId, this.qdoRole.roleName, this.qdoRole.roleCode, this.qdoRole.roleEmployees, this.qdoRole.remark})).from((EntityPath)this.qdoRole)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.orgId.eq(this.qdoRole.orgId));
        return jpaQuery;
    }

    public List<PrdOrgRoleVO> queryRolesByDimensionId(Long dimensionId) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = this.getJpaQueryRoleSelect0();
        jpaQuery.where((Predicate)this.qdoRef.dimensionId.eq((Object)dimensionId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.isCopy.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRole.isCopy.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        jpaQuery.groupBy((Expression)this.qdoRole.roleCode);
        return jpaQuery.fetch();
    }

    public List<PrdOrgRoleVO> queryRolesByUserId(Long userId) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = this.getJpaQueryRoleSelect();
        jpaQuery.where((Predicate)this.qdoRole.roleEmployees.like(SqlUtil.toSqlLikeString("" + userId)));
        jpaQuery.where((Predicate)this.qdoRole.isCopy.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdOrgOrganizationDAO(JPAQueryFactory jpaQueryFactory, PrdOrgOrganizationRepo repo, PrdOrgOrganizationRefRepo refRepo, PrdOrgEmployeeRefRepo employeeRefRepo, PrdOrgRoleRepo roleRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.refRepo = refRepo;
        this.employeeRefRepo = employeeRefRepo;
        this.roleRepo = roleRepo;
    }
}

