/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookLicensePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookLicenseQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookLicenseVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookLicenseDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookLicenseDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookLicenseRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BookLicenseDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BookLicenseRepo repo;
    private final QBookLicenseDO qdo = QBookLicenseDO.bookLicenseDO;

    private JPAQuery<BookLicenseVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookLicenseVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bookId, this.qdo.licenseNo, this.qdo.licenseType, this.qdo.licenseStatus, this.qdo.invalidDate, this.qdo.fileCode, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BookLicenseVO> getJpaQueryWhere(BookLicenseQuery query) {
        JPAQuery<BookLicenseVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BookLicenseQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BookLicenseQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLicenseNo())) {
            list.add(this.qdo.licenseNo.eq((Object)query.getLicenseNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLicenseType())) {
            list.add(this.qdo.licenseType.eq((Object)query.getLicenseType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLicenseStatus())) {
            list.add(this.qdo.licenseStatus.eq((Object)query.getLicenseStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvalidDate())) {
            list.add(this.qdo.invalidDate.eq((Object)query.getInvalidDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFileCode())) {
            list.add(this.qdo.fileCode.eq((Object)query.getFileCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BookLicenseVO queryByKey(Long id) {
        JPAQuery<BookLicenseVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookLicenseVO)jpaQuery.fetchFirst();
    }

    public List<BookLicenseVO> queryListDynamic(BookLicenseQuery query) {
        JPAQuery<BookLicenseVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BookLicenseVO> queryPaging(BookLicenseQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BookLicenseVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BookLicenseDO save(BookLicenseDO ado) {
        return (BookLicenseDO)this.repo.save(ado);
    }

    public List<BookLicenseDO> saveAll(List<BookLicenseDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BookLicensePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getLicenseNo() != null) {
            update.set((Path)this.qdo.licenseNo, (Object)payload.getLicenseNo());
        }
        if (payload.getLicenseType() != null) {
            update.set((Path)this.qdo.licenseType, (Object)payload.getLicenseType());
        }
        if (payload.getLicenseStatus() != null) {
            update.set((Path)this.qdo.licenseStatus, (Object)payload.getLicenseStatus());
        }
        if (payload.getInvalidDate() != null) {
            update.set(this.qdo.invalidDate, (Object)payload.getInvalidDate());
        }
        if (payload.getFileCode() != null) {
            update.set((Path)this.qdo.fileCode, (Object)payload.getFileCode());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("licenseNo")) {
                update.setNull((Path)this.qdo.licenseNo);
            }
            if (nullFields.contains("licenseType")) {
                update.setNull((Path)this.qdo.licenseType);
            }
            if (nullFields.contains("licenseStatus")) {
                update.setNull((Path)this.qdo.licenseStatus);
            }
            if (nullFields.contains("invalidDate")) {
                update.setNull(this.qdo.invalidDate);
            }
            if (nullFields.contains("fileCode")) {
                update.setNull((Path)this.qdo.fileCode);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public BookLicenseDAO(JPAQueryFactory jpaQueryFactory, BookLicenseRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

