/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistBroadcastPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistBroadcastService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistBroadcastConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistBroadcastDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistBroadcastRepo;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PmsDistBroadcastServiceImpl
extends BaseServiceImpl
implements PmsDistBroadcastService {
    private static final Logger log = LoggerFactory.getLogger(PmsDistBroadcastServiceImpl.class);
    private final PmsDistBroadcastRepo pmsDistBroadcastRepo;
    private final PmsDistBroadcastDAO pmsDistBroadcastDAO;
    private final PmsDistBroadcastDAO distBroadcastDAO;
    private final PmsDistributeDAO pmsDistributeDAO;
    private final PmsDistributeRespondService distributeRespondService;

    public void cancelBroadcast(Long distId) {
        this.distBroadcastDAO.deleteByDistIds(Arrays.asList(distId));
        this.distributeRespondService.deleteByDistIds(Arrays.asList(distId));
        PmsDistributePayload distributePayload = new PmsDistributePayload();
        distributePayload.setId(distId);
        distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
        this.pmsDistributeDAO.updateByKeyDynamic(distributePayload);
    }

    public List<PmsDistBroadcastVO> findListByRespondentResId(Long respondentResId) {
        return this.distBroadcastDAO.findListByRespondentResId(respondentResId);
    }

    public PagingVO<PmsDistBroadcastVO> queryPaging(PmsDistBroadcastQuery query) {
        return this.pmsDistBroadcastDAO.queryPaging(query);
    }

    public List<PmsDistBroadcastVO> queryListDynamic(PmsDistBroadcastQuery query) {
        return this.pmsDistBroadcastDAO.queryListDynamic(query);
    }

    public PmsDistBroadcastVO queryByKey(Long key) {
        PmsDistBroadcastDO entity = this.pmsDistBroadcastRepo.findById(key).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsDistBroadcastVO vo = PmsDistBroadcastConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsDistBroadcastVO insert(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entityDo = PmsDistBroadcastConvert.INSTANCE.toDo(payload);
        return PmsDistBroadcastConvert.INSTANCE.toVo((PmsDistBroadcastDO)this.pmsDistBroadcastRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsDistBroadcastVO update(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entity = this.pmsDistBroadcastRepo.findById(payload.getId()).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsDistBroadcastDO entityDo = PmsDistBroadcastConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsDistBroadcastConvert.INSTANCE.toVo((PmsDistBroadcastDO)this.pmsDistBroadcastRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entity = this.pmsDistBroadcastRepo.findById(payload.getId()).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsDistBroadcastDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.distBroadcastDAO.deleteSoft(keys);
        }
    }

    public PmsDistBroadcastServiceImpl(PmsDistBroadcastRepo pmsDistBroadcastRepo, PmsDistBroadcastDAO pmsDistBroadcastDAO, PmsDistBroadcastDAO distBroadcastDAO, PmsDistributeDAO pmsDistributeDAO, PmsDistributeRespondService distributeRespondService) {
        this.pmsDistBroadcastRepo = pmsDistBroadcastRepo;
        this.pmsDistBroadcastDAO = pmsDistBroadcastDAO;
        this.distBroadcastDAO = distBroadcastDAO;
        this.pmsDistributeDAO = pmsDistributeDAO;
        this.distributeRespondService = distributeRespondService;
    }
}

