/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceVerDetailService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.CostUndertakeDepartmentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentAccountantApprovePayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentDefaultQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.BillVerDetailService;
import com.elitesland.tw.tw5.api.prd.purchase.service.CostUndertakeDepartmentService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentPlanReferService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.BillVerDetailVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.CostUndertakeDepartmentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentPlanReferVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.WriteOffPaymentApplyVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.CostUndertakeDepartmentConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.CostUndertakeDepartmentRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentRepo;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.Tuple;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchasePaymentServiceImpl
extends BaseServiceImpl
implements PurchasePaymentService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentServiceImpl.class);
    private final CostUndertakeDepartmentService costUndertakeDepartmentService;
    private final PurchasePaymentRepo purchasePaymentRepo;
    private final PurchasePaymentDAO purchasePaymentDAO;
    private final CostUndertakeDepartmentRepo costUndertakeDepartmentRepo;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final SaleConContractService saleConContractService;
    private final SaleConContractRepo saleConContractRepo;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    @Autowired
    private PurchaseContractManagerService purchaseContractManagerService;
    private final CrmOpportunityService crmOpportunityService;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final FileUtil fileUtil;
    private final PurchasePaymentPlanService purchasePaymentPlanService;
    private final PurchaseAgreementService purchaseAgreementService;
    private final PrdSystemRoleService systemRoleService;
    private final PaymentPlanReferService paymentPlanReferService;
    private final PaymentSlipService paymentSlipService;
    private final PmsProjectService pmsProjectService;
    private final ExcelUtil excelUtil;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.workflow.administrationBu}")
    private Long administrationBuId;
    private final BusinessPartnerService businessPartnerService;
    private final BookAccountService bookAccountService;
    private final ResWithdrawApplyService resWithdrawApplyService;
    private final InvInvoiceService invInvoiceService;
    private final InvInvoiceVerDetailService invInvoiceVerDetailService;
    private final BillVerDetailService billVerDetailService;
    private BeanSearcher beanSearcher;
    private final PurchaseContractDetailsService purchaseContractDetailsService;
    private final PurchaseAgreementDetailsService purchaseAgreementDetailsService;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    public PagingVO<PurchasePaymentVO> queryPaging(PurchasePaymentQuery query) {
        PagingVO<PurchasePaymentVO> purchasePaymentVOPagingVO = this.purchasePaymentDAO.queryPaging(query);
        this.translateBusinessPartner(purchasePaymentVOPagingVO.getRecords());
        return purchasePaymentVOPagingVO;
    }

    public PagingVO<PurchasePaymentVO> permissionPaging(PurchasePaymentQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PurchasePaymentVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List purchasePaymentVOS = this.beanSearcher.searchList(PurchasePaymentVO.class, mapBuilder.build());
        this.translateBusinessPartner(purchasePaymentVOS);
        return PagingVO.builder().records(purchasePaymentVOS).total(((Long)totalNum).longValue()).build();
    }

    public Map<String, List<WriteOffPaymentApplyVO>> findWriteOffByPrePaymentNoList(List<String> prePaymentApplyNoList) {
        List<WriteOffPaymentApplyVO> writeOffPaymentApplyVOList = this.purchasePaymentDAO.findWriteOffByPrePaymentNoList(prePaymentApplyNoList);
        return writeOffPaymentApplyVOList.stream().collect(Collectors.groupingBy(WriteOffPaymentApplyVO::getPrePaymentNo));
    }

    public List<PurConOrAgreementDetailsSimpleVO> queryByPurConOrAgreementId(Long purConOrAgreementId, String docType) {
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(docType)) {
            return this.purchaseContractDetailsService.queryByPurConId(purConOrAgreementId);
        }
        if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(docType)) {
            return this.purchaseAgreementDetailsService.queryByPurAgreementId(purConOrAgreementId);
        }
        return null;
    }

    public List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNo(String invoiceNo) {
        List costUndertakeDepartmentVOS = this.costUndertakeDepartmentService.queryListByInvoiceNo(invoiceNo);
        return costUndertakeDepartmentVOS;
    }

    public List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNos(PaymentSlipPayload payload) {
        List costUndertakeDepartmentVOS = this.costUndertakeDepartmentService.queryListByInvoiceNos(payload);
        return costUndertakeDepartmentVOS;
    }

    private MapBuilder pageWhereBuilder(PurchasePaymentQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getPaymentNameOrNo())) {
            String likeStr = "%" + query.getPaymentNameOrNo() + "%";
            ((MapBuilder)builder.field(PurchasePaymentVO::getPurchaseName, new FieldFns.FieldFn[]{PurchasePaymentVO::getPaymentNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentApplicationType())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getPaymentApplicationType, new Object[]{query.getPaymentApplicationType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayCompanyBookId())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getPayCompanyBookId, new Object[]{query.getPayCompanyBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierLegalBookId())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getSupplierLegalBookId, new Object[]{query.getSupplierLegalBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getState())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getState, new Object[]{query.getState()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptanceType())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getAcceptanceType, new Object[]{query.getAcceptanceType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedSalesContract())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getRelatedSalesContract, new Object[]{query.getRelatedSalesContract()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedProjectNo())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getRelatedProjectNo, new Object[]{query.getRelatedProjectNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            ((MapBuilder)builder.field(PurchasePaymentVO::getId, (Collection)query.getIds())).op((FieldOp)FieldOps.InList);
        }
        ((MapBuilder)builder.field(PurchasePaymentVO::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PurchasePaymentVO queryByKey(Long key) {
        List billVerDetailPayloads;
        List invInvoiceVerDetailVOS;
        List resWithdrawApplyVOS;
        List paymentSlipVOS;
        PurchasePaymentVO purchasePaymentVO = this.purchasePaymentDAO.queryByKey(key);
        if (purchasePaymentVO == null) {
            return null;
        }
        if (StringUtils.hasText((String)purchasePaymentVO.getExpenseBuId())) {
            String expenseBuId = purchasePaymentVO.getExpenseBuId();
            String[] split = expenseBuId.split(",");
            StringBuilder buBuilder = new StringBuilder();
            Arrays.stream(split).forEach(buId -> {
                String orgName = this.cacheUtil.getOrgName(Long.valueOf(buId));
                buBuilder.append(orgName + ",");
            });
            purchasePaymentVO.setExpenseBuName(buBuilder.substring(0, buBuilder.length() - 1));
        }
        List costUndertakeDepartmentVOS = this.costUndertakeDepartmentService.queryListByPaymentApplyId(key);
        purchasePaymentVO.setCostUndertakeDepartmentVOS(costUndertakeDepartmentVOS);
        this.purchasePaymentPlanService.setPaymentApplyVOPlanList(purchasePaymentVO);
        List paymentPlanReferVOS = this.paymentPlanReferService.queryListByPaymentApplyId(key);
        if (!paymentPlanReferVOS.isEmpty()) {
            purchasePaymentVO.setPaymentPlanReferVOS(paymentPlanReferVOS);
        }
        if (!(paymentSlipVOS = this.paymentSlipService.queryListByPaymentApplyId(key)).isEmpty()) {
            purchasePaymentVO.setPaymentSlipVOS(paymentSlipVOS);
        }
        if (!(resWithdrawApplyVOS = this.resWithdrawApplyService.queryListByPaymentApplyId(key)).isEmpty()) {
            purchasePaymentVO.setResWithdrawApplyVOS(resWithdrawApplyVOS);
        }
        if (!(invInvoiceVerDetailVOS = this.invInvoiceVerDetailService.queryListByPaymentApplyId(purchasePaymentVO.getDocType(), key)).isEmpty()) {
            purchasePaymentVO.setInvInvoiceVerDetailVOS(invInvoiceVerDetailVOS);
        }
        if (!(billVerDetailPayloads = this.billVerDetailService.queryListByPaymentApplyId(purchasePaymentVO.getDocType(), key)).isEmpty()) {
            for (BillVerDetailVO billVerDetailVO : billVerDetailPayloads) {
                if (ObjectUtils.isEmpty((Object)billVerDetailVO.getFileCode())) continue;
                Object fileData = this.fileUtil.getFileDatas(billVerDetailVO.getFileCode());
                billVerDetailVO.setFileData(fileData);
            }
            purchasePaymentVO.setBillVerDetailPayloads(billVerDetailPayloads);
        }
        purchasePaymentVO.setBasisFileDates(this.fileUtil.getFileDatas(purchasePaymentVO.getBasisFileCodes()));
        if (StringUtils.isEmpty((Object)purchasePaymentVO.getFileCode())) {
            purchasePaymentVO.setFileDate(this.fileUtil.getFileDatas(purchasePaymentVO.getFileCode()));
        }
        purchasePaymentVO.setUrgentPaymentDates(this.fileUtil.getFileDatas(purchasePaymentVO.getUrgentPaymentCodes()));
        if (purchasePaymentVO.getCreateUserId() != null) {
            PrdOrgEmployeeVO employee;
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(purchasePaymentVO.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = this.cacheUtil.getOrgName(defaultOrgIdByUserId);
                purchasePaymentVO.setBuName(orgName);
            }
            if ((employee = this.cacheUtil.getEmployee(purchasePaymentVO.getCreateUserId())) != null) {
                purchasePaymentVO.setGrade(employee.getExtString1());
            }
        }
        this.setDocumentId(purchasePaymentVO);
        this.translateBusinessPartner(purchasePaymentVO);
        return purchasePaymentVO;
    }

    public PurchasePaymentVO queryMainInfoByKey(Long key) {
        return this.purchasePaymentDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchasePaymentVO insertOrUpdate(PurchasePaymentPayload payload) {
        String changeLog;
        this.check(payload);
        PurchasePaymentDO entityDo = PurchasePaymentConvert.INSTANCE.toDo(payload);
        boolean isInsert = false;
        List invInvoiceVerDetailPayloads = payload.getInvInvoiceVerDetailPayloads();
        Long id = payload.getId();
        if (id == null || id < 0L) {
            isInsert = true;
            entityDo.setPaymentNo(this.generateSeqNum("PURCHASE_PAYMENT_NO", new String[0]));
            PurchasePaymentDO save = (PurchasePaymentDO)this.purchasePaymentRepo.save(entityDo);
            id = save.getId();
            entityDo.setId(id);
            payload.setId(id);
            entityDo.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
            changeLog = "\u65b0\u5efa\u4ed8\u6b3e\u7533\u8bf7\u5355";
        } else {
            if (!payload.getIsSubmit().booleanValue() && !PurchasePaymentEnum.PaymentStatus.CREATE.getCode().equals(entityDo.getState())) {
                throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u7f16\u8f91\uff01");
            }
            PurchasePaymentDO entity = this.purchasePaymentRepo.findById(id).orElseGet(PurchasePaymentDO::new);
            changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entity);
            this.updateByKeyDynamic(payload);
        }
        Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> scene = this.getScene(entityDo.getPaymentApplicationType(), entityDo.getDocType(), entityDo.getDocNo());
        entityDo.setScene((String)scene.getLeft());
        this.savePaymentPlan(payload, scene, isInsert);
        this.savePaymentPlanRefer(payload);
        if (StringUtils.hasText((String)changeLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PAYMENT_APPLY.getCode(), changeLog);
        }
        this.saveCostUndertakeBu(payload, isInsert, payload.getIsSubmit());
        this.savePaymentSlip(payload);
        this.saveInvInvoiceVerDetail(payload, isInsert, payload.getIsSubmit());
        this.saveBillVerDetail(payload, isInsert, payload.getIsSubmit());
        switch (PurchasePaymentEnum.PaymentType.match(entityDo.getPaymentApplicationType())) {
            case ADVANCE_PAY_WRITE_OFF: {
                String prePaymentNo = entityDo.getPrePaymentNo();
                if (prePaymentNo == null) break;
                this.purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITE_OFF_PROCESS);
            }
        }
        PurchasePaymentVO result = this.queryByKey(id);
        if (payload.getIsSubmit().booleanValue()) {
            this.submitPayment(result);
        }
        return result;
    }

    private BigDecimal countTaxAmt(List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(invInvoiceVerDetailPayloads)) {
            List<String> invoiceNos = invInvoiceVerDetailPayloads.stream().map(InvInvoiceVerDetailPayload::getInvoiceNo).toList();
            Map decimalMap = this.invInvoiceService.findDeductTaxDeviceAmountTaxByNoIn(invoiceNos);
            for (InvInvoiceVerDetailPayload invInvoiceVerDetailPayload : invInvoiceVerDetailPayloads) {
                BigDecimal theAmt = invInvoiceVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getTheAmt();
                String invoiceCode = invInvoiceVerDetailPayload.getInvoiceCode() == null ? "" : invInvoiceVerDetailPayload.getInvoiceCode();
                BigDecimal deductTaxDeviceAmountTax = (BigDecimal)decimalMap.get(invInvoiceVerDetailPayload.getInvoiceNo() + "-" + invoiceCode);
                deductTaxDeviceAmountTax = deductTaxDeviceAmountTax == null ? BigDecimal.ZERO : deductTaxDeviceAmountTax;
                BigDecimal taxAmount = deductTaxDeviceAmountTax.multiply(theAmt).setScale(2, RoundingMode.HALF_UP);
                sumTaxAmount = sumTaxAmount.add(taxAmount);
            }
        }
        return sumTaxAmount;
    }

    private void check(PurchasePaymentPayload payload) {
        if (payload.getCurrPaymentAmt() == null || payload.getCurrPaymentAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "\u672c\u6b21\u4ed8\u6b3e/\u6838\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    private void savePaymentPlan(PurchasePaymentPayload payload, Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> scene, Boolean isInsert) {
        PurchaseContractManagerDO purchaseContractManagerDO = (PurchaseContractManagerDO)scene.getMiddle();
        PurchaseAgreementDO purchaseAgreementDO = (PurchaseAgreementDO)scene.getRight();
        List purchasePaymentPlanPayloads = payload.getPurchasePaymentPlanPayloads();
        ArrayList<PurchasePaymentPlanPayload> eligiblePlanPayloads = new ArrayList<PurchasePaymentPlanPayload>();
        if (!CollectionUtils.isEmpty((Collection)purchasePaymentPlanPayloads)) {
            for (PurchasePaymentPlanPayload purchasePaymentPlanPayload2 : purchasePaymentPlanPayloads) {
                purchasePaymentPlanPayload2.setPaymentApplyId(payload.getId());
                if (purchasePaymentPlanPayload2.getCurrentPaymentAmt() == null || purchasePaymentPlanPayload2.getCurrentPaymentAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                eligiblePlanPayloads.add(purchasePaymentPlanPayload2);
            }
        }
        if (!CollectionUtils.isEmpty(eligiblePlanPayloads)) {
            if (purchaseContractManagerDO != null) {
                eligiblePlanPayloads.forEach(purchasePaymentPlanPayload -> {
                    purchasePaymentPlanPayload.setContractNo(purchaseContractManagerDO.getPurchaseContractNo());
                    purchasePaymentPlanPayload.setContractId(purchaseContractManagerDO.getId());
                    purchasePaymentPlanPayload.setDocType(PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode());
                });
            } else if (purchaseAgreementDO != null) {
                eligiblePlanPayloads.forEach(purchasePaymentPlanPayload -> {
                    purchasePaymentPlanPayload.setContractNo(purchaseAgreementDO.getPurchaseAgreementNo());
                    purchasePaymentPlanPayload.setContractId(purchaseAgreementDO.getId());
                    purchasePaymentPlanPayload.setDocType(PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode());
                });
            }
            boolean isPaymentPlanInsert = this.judgePaymentPlanIsInsert(payload.getPaymentApplicationType(), payload.getDocType());
            if (isPaymentPlanInsert) {
                if (!isInsert.booleanValue()) {
                    this.purchasePaymentPlanService.deleteByPaymentId(payload.getId());
                }
                this.purchasePaymentPlanService.insertAll(eligiblePlanPayloads);
            } else {
                this.purchasePaymentPlanService.updatePlans(eligiblePlanPayloads);
            }
        }
    }

    private void savePaymentSlip(PurchasePaymentPayload payload) {
        List paymentSlipPayloads = payload.getPaymentSlipPayloads();
        if (!CollectionUtils.isEmpty((Collection)paymentSlipPayloads) && !Objects.equals(payload.getPaymentApplicationType(), PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode())) {
            paymentSlipPayloads.forEach(paymentSlipPayload -> paymentSlipPayload.setPaymentApplyId(payload.getId()));
            this.paymentSlipService.deleteByPaymentApplyId(payload.getId());
            this.paymentSlipService.insertAll(paymentSlipPayloads);
        }
    }

    private void savePaymentPlanRefer(PurchasePaymentPayload payload) {
        List paymentPlanReferPayloads = payload.getPaymentPlanReferPayloads();
        if (!CollectionUtils.isEmpty((Collection)paymentPlanReferPayloads) && PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(payload.getPaymentApplicationType())) {
            paymentPlanReferPayloads.forEach(paymentPlanReferPayload -> paymentPlanReferPayload.setPaymentApplyId(payload.getId()));
            this.paymentPlanReferService.saveAll(paymentPlanReferPayloads);
        }
    }

    private void saveInvInvoiceVerDetail(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(payload.getPaymentApplicationType())) {
            return;
        }
        HashMap oldTheAmtMap = new HashMap();
        if (!isInsert.booleanValue()) {
            List invInvoiceVerDetailVOS = this.invInvoiceVerDetailService.queryListByPaymentApplyId(payload.getDocType(), payload.getId());
            if (!CollectionUtils.isEmpty((Collection)invInvoiceVerDetailVOS)) {
                invInvoiceVerDetailVOS.forEach(invInvoiceVerDetailVO -> {
                    String invoiceCode = invInvoiceVerDetailVO.getInvoiceCode() == null ? "" : invInvoiceVerDetailVO.getInvoiceCode();
                    String key = invInvoiceVerDetailVO.getInvoiceNo() + "-" + invoiceCode;
                    BigDecimal oldTheAmt = invInvoiceVerDetailVO.getTheAmt();
                    oldTheAmt = oldTheAmt == null ? BigDecimal.ZERO : oldTheAmt;
                    oldTheAmtMap.put(key, oldTheAmt);
                });
            }
            this.invInvoiceVerDetailService.deleteByPaymentApplyId(payload.getId());
        }
        List invInvoiceVerDetailPayloads = payload.getInvInvoiceVerDetailPayloads();
        BigDecimal[] allTheAmt = new BigDecimal[]{BigDecimal.ZERO};
        if (!CollectionUtils.isEmpty((Collection)invInvoiceVerDetailPayloads)) {
            HashMap newTheAmtMap = new HashMap();
            invInvoiceVerDetailPayloads.forEach(invInvoiceVerDetailPayload -> {
                BigDecimal oldTheAmt;
                BigDecimal theAmt = invInvoiceVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getTheAmt();
                String invoiceCode = invInvoiceVerDetailPayload.getInvoiceCode() == null ? "" : invInvoiceVerDetailPayload.getInvoiceCode();
                String key = invInvoiceVerDetailPayload.getInvoiceNo() + "-" + invoiceCode;
                newTheAmtMap.put(key, theAmt);
                allTheAmt[0] = allTheAmt[0].add(theAmt);
                BigDecimal invoiceAmt = invInvoiceVerDetailPayload.getInvoiceAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getInvoiceAmt();
                BigDecimal writtenOffAmt = invInvoiceVerDetailPayload.getWrittenOffAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getWrittenOffAmt();
                BigDecimal bigDecimal = oldTheAmt = oldTheAmtMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)oldTheAmtMap.get(key);
                if (writtenOffAmt.add(theAmt.subtract(oldTheAmt)).compareTo(invoiceAmt) > 0) {
                    throw TwException.error("", "\u53d1\u7968\u53f7\u7801\u4e3a\u3010" + invInvoiceVerDetailPayload.getInvoiceNo() + "\u3011\u7684\u53d1\u7968\u603b\u6838\u9500\u91d1\u989d\u9700\u5c0f\u4e8e\u53d1\u7968\u91d1\u989d");
                }
                invInvoiceVerDetailPayload.setPaymentApplyId(payload.getId());
            });
            if (newTheAmtMap.size() < invInvoiceVerDetailPayloads.size()) {
                throw TwException.error("", "\u53d1\u7968\u6838\u9500\u660e\u7ec6\u6240\u9009\u53d1\u7968\u4e0d\u53ef\u91cd\u590d");
            }
            this.invInvoiceVerDetailService.insertAll(invInvoiceVerDetailPayloads);
            this.invInvoiceService.updateWrittenOffAmtByNo(newTheAmtMap, oldTheAmtMap);
        }
    }

    private void saveCostUndertakeBu(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        if (!isInsert.booleanValue()) {
            this.costUndertakeDepartmentService.deleteByPaymentApplyId(payload.getId());
        }
        List costUndertakeDepartmentPayloads = payload.getCostUndertakeDepartmentPayloads();
        BigDecimal[] allBearAmt = new BigDecimal[]{BigDecimal.ZERO};
        if (costUndertakeDepartmentPayloads != null) {
            ArrayList costUndertakeDepartmentDOS = new ArrayList(costUndertakeDepartmentPayloads.size());
            costUndertakeDepartmentPayloads.forEach(costUndertakeDepartmentPayload -> {
                costUndertakeDepartmentPayload.setId(null);
                costUndertakeDepartmentPayload.setPaymentApplyId(payload.getId());
                costUndertakeDepartmentDOS.add(CostUndertakeDepartmentConvert.INSTANCE.toDo((CostUndertakeDepartmentPayload)costUndertakeDepartmentPayload));
                BigDecimal bearAmt = costUndertakeDepartmentPayload.getBearAmt() == null ? BigDecimal.ZERO : costUndertakeDepartmentPayload.getBearAmt();
                allBearAmt[0] = allBearAmt[0].add(bearAmt);
            });
            this.costUndertakeDepartmentRepo.saveAll(costUndertakeDepartmentDOS);
        }
        if (isCheck.booleanValue()) {
            BigDecimal currPaymentAmt = payload.getCurrPaymentAmt() == null ? BigDecimal.ZERO : payload.getCurrPaymentAmt();
            BigDecimal bigDecimal = payload.getTaxAmount() == null ? BigDecimal.ZERO : payload.getTaxAmount();
        }
    }

    @Transactional
    public PurchasePaymentVO accountantApprove(PaymentAccountantApprovePayload payload) {
        PurchasePaymentPayload paymentPayload = new PurchasePaymentPayload();
        BeanUtil.copyProperties((Object)payload, (Object)paymentPayload, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
        this.updateByKeyDynamic(paymentPayload);
        this.savePaymentSlip(paymentPayload);
        this.saveCostUndertakeBu(paymentPayload, false, true);
        PurchasePaymentVO purchasePaymentVO = this.queryByKey(payload.getId());
        this.submitPayment(purchasePaymentVO);
        return purchasePaymentVO;
    }

    private Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> getScene(String paymentApplicationType, String docType, String docNo) {
        PurchaseContractManagerDO purchaseContractManagerDO = null;
        Object purchaseContractType = null;
        Object businessType = null;
        PurchaseAgreementDO purchaseAgreementDO = null;
        Object agreementType = null;
        Object signBuId = null;
        String scene = null;
        switch (PurchasePaymentEnum.PaymentDocType.match(docType)) {
            case CONTRACT: {
                if (docNo == null) {
                    throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
                }
                Optional<PurchaseContractManagerDO> purchaseContractDO = this.purchaseContractManagerRepo.findByPurchaseContractNo(docNo);
                if (purchaseContractDO.isEmpty()) {
                    throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
                }
                purchaseContractManagerDO = purchaseContractDO.get();
                break;
            }
            case AGREEMENT: {
                if (docNo == null) {
                    throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u534f\u8bae\uff0c\u8bf7\u68c0\u67e5");
                }
                Optional<PurchaseAgreementDO> purAgreementDO = this.purchaseAgreementRepo.findByPurchaseAgreementNo(docNo);
                if (purAgreementDO.isEmpty()) {
                    throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u534f\u8bae\uff0c\u8bf7\u68c0\u67e5");
                }
                purchaseAgreementDO = purAgreementDO.get();
            }
        }
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            case CONTRACT: {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_PAYMENT_PAY.getCode();
                break;
            }
            case AGREEMENT: {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_PAYMENT_PAY.getCode();
                break;
            }
            case ADVANCE_PAY: {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY.getCode();
                break;
            }
            case ADVANCE_PAY_WRITE_OFF: {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_W_O.getCode();
            }
        }
        return new ImmutableTriple((Object)scene, purchaseContractManagerDO, purchaseAgreementDO);
    }

    private void submitPayment(PurchasePaymentVO purchasePaymentVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = PurchasePaymentEnum.PaymentStatus.APPROVING.getCode();
        if (this.workflow_enabled.booleanValue()) {
            Long relatedProjectId;
            status = PurchasePaymentEnum.PaymentStatus.APPROVING.getCode();
            String scene = purchasePaymentVO.getScene();
            HashMap<String, Object> variables = this.getVariables(purchasePaymentVO);
            variables.put("isResubmit", purchasePaymentVO.getIsResubmit() != null && purchasePaymentVO.getIsResubmit() != false);
            variables.put("urgentPaymentFlag", purchasePaymentVO.getUrgentPaymentFlag() != null && purchasePaymentVO.getUrgentPaymentFlag() != false);
            StringBuilder paymentApplyName = new StringBuilder();
            paymentApplyName.append(PurchasePaymentEnum.PaymentType.match(purchasePaymentVO.getPaymentApplicationType()).getDesc()).append("-");
            PurchasePaymentEnum.AcceptanceMethod acceptanceMethod = PurchasePaymentEnum.AcceptanceMethod.match(purchasePaymentVO.getAcceptanceType());
            if (acceptanceMethod != null) {
                paymentApplyName.append(acceptanceMethod.getDesc()).append("-");
            }
            paymentApplyName.append(purchasePaymentVO.getPurchaseName()).append("-");
            if (purchasePaymentVO.getPayCompanyName() != null) {
                paymentApplyName.append(purchasePaymentVO.getPayCompanyName()).append("-");
            }
            paymentApplyName.append(purchasePaymentVO.getCurrPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentVO.getCurrPaymentAmt());
            Long relatedSalesContractId = purchasePaymentVO.getRelatedSalesContractId();
            if (relatedSalesContractId != null) {
                SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(relatedSalesContractId, new Boolean[0]);
                purchasePaymentVO.setSaleSignBuId(saleConContractVO.getSignBuId());
            }
            if ((relatedProjectId = purchasePaymentVO.getRelatedProjectId()) != null) {
                PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(relatedProjectId);
                purchasePaymentVO.setPmResId(pmsProjectVO.getPmResId());
            }
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(purchasePaymentVO.getPurchaseInchargeResId());
            purchasePaymentVO.setSubmitBuId(defaultOrgIdByUserId);
            if (purchasePaymentVO.getProcInstId() == null) {
                processInfo = this.workflowUtil.simpleStartProcess(StartProcessPayload.of((String)PurchasePaymentEnum.PaymentProcDefKey.match(scene).getCode(), (String)String.valueOf(paymentApplyName), (String)("" + purchasePaymentVO.getId()), variables), purchasePaymentVO, new Long[0]);
            } else {
                this.workflowUtil.setVariables(SetVariablesPayload.of((String)purchasePaymentVO.getProcInstId(), variables));
            }
        }
        if (purchasePaymentVO.getUrgentPaymentFlag().booleanValue()) {
            this.transactionUtilService.executeWithRunnable(() -> this.paymentSlipService.updateStatusByPaymentApplyId(purchasePaymentVO.getId(), PurchasePaymentEnum.PaymentSlipStatus.READY.getCode()));
        }
        PurchasePaymentPayload payload = new PurchasePaymentPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(purchasePaymentVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setState(status);
        this.transactionUtilService.executeWithRunnable(() -> this.purchasePaymentDAO.updateByKeyDynamic(payload));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchasePaymentPayload payload) {
        PurchasePaymentDO entity = this.purchasePaymentRepo.findById(payload.getId()).orElseGet(PurchasePaymentDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return this.purchasePaymentDAO.updateByKeyDynamic(payload);
    }

    public PurchasePaymentVO getDefaultByTypeAndDocNo(PurchasePaymentDefaultQuery defaultQuery) {
        String paymentApplicationType = defaultQuery.getPaymentApplicationType();
        String docType = defaultQuery.getDocType();
        String docNo = defaultQuery.getDocNo();
        PurchasePaymentVO purchasePaymentVO = new PurchasePaymentVO();
        PurchasePaymentDefaultVO paymentDefaultByDocNo = new PurchasePaymentDefaultVO();
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            case CONTRACT: {
                paymentDefaultByDocNo = this.purchaseContractManagerService.findPaymentDefaultByDocNo(docNo);
                purchasePaymentVO.setPurchaseContractType(paymentDefaultByDocNo.getPurchaseContractType());
                purchasePaymentVO.setPurchasePaymentPlanVOS(this.purchasePaymentPlanService.findListByConNo(docNo, Boolean.valueOf(true)));
                purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "\u4ed8\u6b3e");
                break;
            }
            case AGREEMENT: 
            case SALARY_PAYMENT: {
                paymentDefaultByDocNo = this.purchaseAgreementService.findPaymentDefaultByDocNo(docNo);
                List withdrawByAgreementNo = this.resWithdrawApplyService.findWithdrawByAgreementNo(docNo);
                purchasePaymentVO.setResWithdrawApplyVOS(withdrawByAgreementNo);
                purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "\u4ed8\u6b3e");
                break;
            }
            case ADVANCE_PAY: {
                switch (PurchasePaymentEnum.PaymentDocType.match(docType)) {
                    case CONTRACT: {
                        paymentDefaultByDocNo = this.purchaseContractManagerService.findPaymentDefaultByDocNo(docNo);
                        break;
                    }
                    case AGREEMENT: {
                        paymentDefaultByDocNo = this.purchaseAgreementService.findPaymentDefaultByDocNo(docNo);
                        break;
                    }
                    case OPPORTUNITY: {
                        paymentDefaultByDocNo = this.crmOpportunityService.findPaymentDefaultByDocNo(docNo);
                        purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "\u6295\u6807\u4fdd\u8bc1\u91d1");
                        purchasePaymentVO.setOpportunityName(paymentDefaultByDocNo.getDocName());
                        purchasePaymentVO.setOpportunity(paymentDefaultByDocNo.getDocId() != null ? paymentDefaultByDocNo.getDocId().toString() : null);
                    }
                }
                List paymentPlanVOS = this.purchasePaymentPlanService.findListByConNo(docNo, Boolean.valueOf(true));
                if (CollectionUtils.isEmpty((Collection)paymentPlanVOS)) break;
                ArrayList paymentPlanReferVOS = new ArrayList(paymentPlanVOS.size());
                paymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                    PaymentPlanReferVO paymentPlanReferVO = new PaymentPlanReferVO();
                    paymentPlanReferVO.setPaymentStage(purchasePaymentPlanVO.getPaymentStage());
                    paymentPlanReferVO.setPaymentAmt(purchasePaymentPlanVO.getPaymentAmt());
                    paymentPlanReferVO.setEstimatedPaymentDate(purchasePaymentPlanVO.getEstimatedPaymentDate());
                    paymentPlanReferVOS.add(paymentPlanReferVO);
                });
                purchasePaymentVO.setPaymentPlanReferVOS(paymentPlanReferVOS);
                purchasePaymentVO.setPurchasePaymentPlanVOS(this.purchasePaymentPlanService.findListByConNo(docNo, Boolean.valueOf(true)));
            }
        }
        this.setPaymentVO(purchasePaymentVO, paymentDefaultByDocNo);
        purchasePaymentVO.setPaymentApplicationType(paymentApplicationType);
        purchasePaymentVO.setDocType(docType);
        purchasePaymentVO.setCurrPaymentAmt(BigDecimal.ZERO);
        return purchasePaymentVO;
    }

    private void setPaymentVO(PurchasePaymentVO purchasePaymentVO, PurchasePaymentDefaultVO paymentDefaultByDocNo) {
        BeanUtil.copyProperties((Object)paymentDefaultByDocNo, (Object)purchasePaymentVO, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
        purchasePaymentVO.setSupplierLegalBookId(paymentDefaultByDocNo.getSupplierBookId());
        purchasePaymentVO.setPayCompanyBookId(paymentDefaultByDocNo.getPaymentCompanyBooKId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(Long id, Boolean isInvalid) {
        Tuple prePaymentIdAndAmt;
        Tuple sceneAndCreatorAndState = this.purchasePaymentDAO.getSceneAndCreatorAndState(id);
        if (sceneAndCreatorAndState == null) {
            log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u5220\u9664\u5931\u8d25\uff0cid\u4e0d\u5b58\u5728{}", (Object)id);
            return;
        }
        String paymentApplicationType = (String)sceneAndCreatorAndState.get(3, String.class);
        String docType = (String)sceneAndCreatorAndState.get(4, String.class);
        if (!isInvalid.booleanValue()) {
            GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
            if (!Objects.equals(sceneAndCreatorAndState.get(1, Long.class), loginGeneralUser.getUserId()) && !loginGeneralUser.isSystemAdmin() || !PurchasePaymentEnum.PaymentStatus.CREATE.getCode().equals(sceneAndCreatorAndState.get(2, String.class))) {
                throw TwException.error("", "\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e3a\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u521b\u5efa\u4eba\u5e76\u4e14\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\u65b0\u5efa\u65f6\u624d\u5141\u8bb8\u5220\u9664");
            }
        }
        if (PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_W_O.getCode().equals(sceneAndCreatorAndState.get(0, String.class)) && (prePaymentIdAndAmt = this.purchasePaymentDAO.findPrePaymentId(id)) != null) {
            PurchasePaymentEnum.PaymentStatus newStatus = this.paymentSlipService.isOtherStatusByPaymentApplyId((Long)prePaymentIdAndAmt.get(0, Long.class)) != false ? PurchasePaymentEnum.PaymentStatus.PARTIAL_PAY : PurchasePaymentEnum.PaymentStatus.PAID;
            this.purchasePaymentDAO.updatePaymentStatus((Long)prePaymentIdAndAmt.get(0, Long.class), newStatus);
        }
        this.resWithdrawApplyService.updateWithdrawStatusByPaymentApplyId(id, null);
        this.costUndertakeDepartmentService.deleteByPaymentApplyId(id);
        List invInvoiceVerDetailVOS = this.invInvoiceVerDetailService.queryListByPaymentApplyId(docType, id);
        invInvoiceVerDetailVOS.forEach(invInvoiceVerDetailVO -> {
            BigDecimal subTheAmt = invInvoiceVerDetailVO.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailVO.getTheAmt();
            String invoiceCode = invInvoiceVerDetailVO.getInvoiceCode() == null ? "" : invInvoiceVerDetailVO.getInvoiceCode();
            this.invInvoiceService.subtractWrittenOffAmt(invInvoiceVerDetailVO.getInvoiceNo() + "-" + invoiceCode, subTheAmt);
        });
        this.invInvoiceVerDetailService.deleteByPaymentApplyId(id);
        this.purchasePaymentDAO.deleteSoft(id);
        if (this.judgePaymentPlanIsInsert(paymentApplicationType, docType)) {
            this.purchasePaymentPlanService.deleteByPaymentId(id);
            this.paymentPlanReferService.deleteByPaymentId(id);
        } else {
            this.purchasePaymentPlanService.resettingPlanByPaymentId(id);
        }
    }

    public List<PrdSystemLogVO> queryLogList(Long key) {
        return this.logService.queryLogList(key, PrdSystemObjectEnum.PAYMENT_APPLY.getCode());
    }

    public HashMap<String, Object> getVariables(PurchasePaymentVO purchasePaymentVO) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String scene = purchasePaymentVO.getScene();
        switch (PurchasePaymentEnum.PaymentProcDefKey.match(scene)) {
            case PUR_PAYMENT_PAY: {
                this.dealPurcahsePaymentPayVariables(variables, purchasePaymentVO);
                break;
            }
            case PUR_ADVANCE_PAY: {
                this.dealPurAdvancPayVariables(variables, purchasePaymentVO);
                break;
            }
            case PUR_ADVANCE_PAY_W_O: {
                this.dealAdvancePayWriteoffVariables(variables, purchasePaymentVO);
            }
        }
        return variables;
    }

    private void dealPurcahsePaymentPayVariables(HashMap<String, Object> variables, PurchasePaymentVO purchasePaymentVO) {
        Boolean purContractFlag = false;
        Boolean agentOrOutFlag = false;
        Boolean projectFlag = false;
        Boolean relateProjectFlag = false;
        Boolean agentFeeFlag = false;
        Boolean amtFlag = false;
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
            if (purchasePaymentVO.getDocNo() == null) {
                throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
            }
            Optional<PurchaseContractManagerDO> purchaseContractDO = this.purchaseContractManagerRepo.findByPurchaseContractNo(purchasePaymentVO.getDocNo());
            if (purchaseContractDO.isEmpty()) {
                throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
            }
            PurchaseContractManagerDO purchaseContractManagerDO = purchaseContractDO.get();
            purContractFlag = true;
            if (PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                PmsProjectVO pmsProjectVO;
                Optional saleConContractDO;
                agentOrOutFlag = true;
                String relatedSalesContract = purchasePaymentVO.getRelatedSalesContract();
                Optional<Object> optional = saleConContractDO = relatedSalesContract == null ? Optional.empty() : this.saleConContractRepo.findByDeleteFlagAndCode(0, relatedSalesContract);
                if (saleConContractDO.isPresent() && (pmsProjectVO = this.pmsProjectService.queryByContractId(((SaleConContractDO)saleConContractDO.get()).getId())) != null) {
                    relateProjectFlag = true;
                }
            }
            if (PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                projectFlag = true;
            }
            if (PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                agentFeeFlag = true;
            }
            if (purchasePaymentVO.getCurrPaymentAmt() != null && purchasePaymentVO.getCurrPaymentAmt().compareTo(new BigDecimal(30000)) >= 0) {
                amtFlag = true;
            }
        }
        variables.put("purContractFlag", purContractFlag);
        variables.put("agentOrOutFlag", agentOrOutFlag);
        variables.put("projectFlag", projectFlag);
        variables.put("relateProjectFlag", relateProjectFlag);
        variables.put("agentFeeFlag", agentFeeFlag);
        variables.put("amtFlag", amtFlag);
    }

    private void dealPurAdvancPayVariables(HashMap<String, Object> variables, PurchasePaymentVO purchasePaymentVO) {
        Boolean purContractFlag = false;
        Boolean purAgreementFlag = false;
        Boolean agentOrOutFlag = false;
        Boolean projectFlag = false;
        Boolean relateProjectFlag = false;
        Boolean agentFeeFlag = false;
        Boolean amtFlag = false;
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
            if (purchasePaymentVO.getDocNo() == null) {
                throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
            }
            Optional<PurchaseContractManagerDO> purchaseContractDO = this.purchaseContractManagerRepo.findByPurchaseContractNo(purchasePaymentVO.getDocNo());
            if (purchaseContractDO.isEmpty()) {
                throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u5408\u540c\uff0c\u8bf7\u68c0\u67e5");
            }
            PurchaseContractManagerDO purchaseContractManagerDO = purchaseContractDO.get();
            purContractFlag = true;
            if (PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                PmsProjectVO pmsProjectVO;
                Optional saleConContractDO;
                agentOrOutFlag = true;
                String relatedSalesContract = purchasePaymentVO.getRelatedSalesContract();
                Optional<Object> optional = saleConContractDO = relatedSalesContract == null ? Optional.empty() : this.saleConContractRepo.findByDeleteFlagAndCode(0, relatedSalesContract);
                if (saleConContractDO.isPresent() && (pmsProjectVO = this.pmsProjectService.queryByContractId(((SaleConContractDO)saleConContractDO.get()).getId())) != null) {
                    relateProjectFlag = true;
                }
            }
            if (PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                projectFlag = true;
            }
            if (PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
                agentFeeFlag = true;
            }
            if (purchasePaymentVO.getCurrPaymentAmt() != null && purchasePaymentVO.getCurrPaymentAmt().compareTo(new BigDecimal(30000)) >= 0) {
                amtFlag = true;
            }
        } else if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(purchasePaymentVO.getDocType())) {
            purAgreementFlag = true;
        }
        variables.put("purContractFlag", purContractFlag);
        variables.put("purAgreementFlag", purAgreementFlag);
        variables.put("agentOrOutFlag", agentOrOutFlag);
        variables.put("projectFlag", projectFlag);
        variables.put("relateProjectFlag", relateProjectFlag);
        variables.put("agentFeeFlag", agentFeeFlag);
        variables.put("amtFlag", amtFlag);
    }

    private void dealAdvancePayWriteoffVariables(HashMap<String, Object> variables, PurchasePaymentVO purchasePaymentVO) {
        Boolean noInvoiceFlag = false;
        if (purchasePaymentVO.getNoInvoiceVerification() != null && purchasePaymentVO.getNoInvoiceVerification() == 1 && purchasePaymentVO.getNoDocVerification() != null && purchasePaymentVO.getNoDocVerification() == 1) {
            noInvoiceFlag = true;
        }
        variables.put("noInvoiceFlag", noInvoiceFlag);
    }

    public void exportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query) {
        this.export(this.queryPaging(query), response);
    }

    public void permissionExportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query) {
        this.export(this.permissionPaging(query), response);
    }

    private void export(PagingVO<PurchasePaymentVO> purchasePaymentVOPagingVO, HttpServletResponse response) {
        List result = purchasePaymentVOPagingVO.getRecords();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            this.translate(result);
            ClassPathResource classPathResource = new ClassPathResource("template/purPaymentApply.xlsx");
            try {
                InputStream inputStream = classPathResource.getInputStream();
                Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
                XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u4ed8\u6b3e\u7533\u8bf7\u5355");
                if (!CollectionUtils.isEmpty((Collection)result) && batchProjectSheet != null) {
                    int nextRow = 1;
                    for (PurchasePaymentVO purchasePaymentVO : result) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        this.excelUtil.setCellValue((Row)row, 0, purchasePaymentVO.getPaymentNo());
                        this.excelUtil.setCellValue((Row)row, 1, purchasePaymentVO.getPurchaseName());
                        this.excelUtil.setCellValue((Row)row, 2, purchasePaymentVO.getPaymentApplicationTypeDesc());
                        this.excelUtil.setCellValue((Row)row, 3, purchasePaymentVO.getFinalPaymentCompanyName());
                        this.excelUtil.setCellValue((Row)row, 4, purchasePaymentVO.getSupplierLegalName());
                        this.excelUtil.setCellValue((Row)row, 5, purchasePaymentVO.getDocTypeDesc());
                        this.excelUtil.setCellValue((Row)row, 6, purchasePaymentVO.getDocNo());
                        this.excelUtil.setCellValue((Row)row, 7, purchasePaymentVO.getStateDesc());
                        this.excelUtil.setCellValue((Row)row, 8, purchasePaymentVO.getCurrPaymentAmt());
                        this.excelUtil.setCellValue((Row)row, 9, purchasePaymentVO.getRateDesc());
                        this.excelUtil.setCellValue((Row)row, 10, purchasePaymentVO.getApplicationDate());
                        this.excelUtil.setCellValue((Row)row, 11, purchasePaymentVO.getRelatedSalesContract());
                        this.excelUtil.setCellValue((Row)row, 12, purchasePaymentVO.getRelatedProjectNo());
                        this.excelUtil.setCellValue((Row)row, 13, purchasePaymentVO.getCreateUserName());
                        this.excelUtil.setCellValue((Row)row, 14, purchasePaymentVO.getCreateTime());
                        ++nextRow;
                    }
                }
                String fileName = "\u4ed8\u6b3e\u7533\u8bf7\u5355-" + LocalDate.now();
                ExcelUtil.writeResponse(response, fileName, workbook);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public PurchasePaymentVO findUrgentPaymentByProcInstId(String procInstId) {
        Optional<PurchasePaymentDO> byProcInstIdAndDeleteFlag = this.purchasePaymentRepo.findByProcInstIdAndDeleteFlag(procInstId, 0);
        if (byProcInstIdAndDeleteFlag.isEmpty()) {
            throw TwException.error("", "\u6b64\u6d41\u7a0b\u4e0d\u80fd\u8fdb\u884c\u7d27\u6025\u4ed8\u6b3e\uff01");
        }
        PurchasePaymentDO purchasePaymentDO = byProcInstIdAndDeleteFlag.get();
        if (!PurchasePaymentEnum.PaymentStatus.APPROVING.getCode().equals(purchasePaymentDO.getState())) {
            throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u7d27\u6025\u4ed8\u6b3e");
        }
        List paymentSlipVOS = this.paymentSlipService.queryListByPaymentApplyId(purchasePaymentDO.getId());
        if (!CollectionUtils.isEmpty((Collection)paymentSlipVOS)) {
            throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5df2\u6709\u4ed8\u6b3e\u8bb0\u5f55\uff01");
        }
        return this.queryByKey(purchasePaymentDO.getId());
    }

    public List<PurchasePaymentVO> queryByDocNo(String docNo, List<String> statusLis) {
        return this.purchasePaymentDAO.queryByDocNo(docNo, statusLis);
    }

    public List<PurchasePaymentVO> queryListDynamic(PurchasePaymentQuery query) {
        return this.purchasePaymentDAO.queryListDynamic(query);
    }

    private Map<String, List<Long>> getRoleCodeMap() {
        ArrayList<String> roleCodes = new ArrayList<String>();
        roleCodes.add(RoleEnum.PLAT_OFFI_AM.getCode());
        roleCodes.add(RoleEnum.PLAT_SALARY_MANAGER.getCode());
        roleCodes.add(RoleEnum.PLAT_SALARY_SPECIALIST.getCode());
        roleCodes.add(RoleEnum.PLAT_HRD.getCode());
        roleCodes.add(RoleEnum.PLAT_AP_ACCOUNTANT.getCode());
        roleCodes.add(RoleEnum.PLAT_BUSINESS_PIC.getCode());
        roleCodes.add(RoleEnum.OPERATION_PRESIDENT.getCode());
        roleCodes.add(RoleEnum.PLAT_ALL_PIC.getCode());
        roleCodes.add(RoleEnum.PLAT_FIN_MANAGER.getCode());
        roleCodes.add(RoleEnum.PLAT_CFO.getCode());
        roleCodes.add(RoleEnum.PLAT_FIN_CASHIER.getCode());
        return this.systemRoleService.queryUserIdMapByRoleCodes(roleCodes);
    }

    private void translate(List<PurchasePaymentVO> result) {
        result.forEach(purchasePaymentVO -> {
            purchasePaymentVO.setPaymentApplicationTypeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PAYMENT_APPLY_TYPE.getCode(), purchasePaymentVO.getPaymentApplicationType()));
            purchasePaymentVO.setDocTypeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ASSOCIATION_DOC_TYPE.getCode(), purchasePaymentVO.getDocType()));
            purchasePaymentVO.setStateDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PAYMENT_APPLY_STATUS.getCode(), purchasePaymentVO.getState()));
            purchasePaymentVO.setRateDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbTAX_RATE.getCode(), purchasePaymentVO.getRate()));
            purchasePaymentVO.setCreateUserName(this.cacheUtil.getUserName(purchasePaymentVO.getCreateUserId()));
        });
        this.translateBusinessPartner(result);
    }

    private void translateBusinessPartner(List<PurchasePaymentVO> result) {
        ArrayList bookIdList = new ArrayList();
        ArrayList receivingIdList = new ArrayList();
        result.forEach(purchasePaymentVO -> {
            bookIdList.add(purchasePaymentVO.getSupplierLegalBookId());
            bookIdList.add(purchasePaymentVO.getPayCompanyBookId());
            bookIdList.add(purchasePaymentVO.getFinalPaymentCompanyBookId());
            bookIdList.add(purchasePaymentVO.getReceivingUnitBookId());
            if (StringUtils.hasText((String)purchasePaymentVO.getReceivingId())) {
                receivingIdList.add(Long.valueOf(purchasePaymentVO.getReceivingId()));
            }
        });
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        Map bookAccountMap = new HashMap();
        if (!CollectionUtils.isEmpty(receivingIdList)) {
            bookAccountMap = this.bookAccountService.queryByIdList(receivingIdList);
        }
        for (PurchasePaymentVO purchasePaymentVO2 : result) {
            List bookAccountVOS;
            purchasePaymentVO2.setSupplierLegalName((String)nameByBookIds.get(purchasePaymentVO2.getSupplierLegalBookId()));
            purchasePaymentVO2.setPayCompanyName((String)nameByBookIds.get(purchasePaymentVO2.getPayCompanyBookId()));
            purchasePaymentVO2.setFinalPaymentCompanyName((String)nameByBookIds.get(purchasePaymentVO2.getFinalPaymentCompanyBookId()));
            purchasePaymentVO2.setReceivingUnitName((String)nameByBookIds.get(purchasePaymentVO2.getReceivingUnitBookId()));
            if (!StringUtils.hasText((String)purchasePaymentVO2.getReceivingId()) || CollectionUtils.isEmpty((Collection)(bookAccountVOS = (List)bookAccountMap.get(Long.valueOf(purchasePaymentVO2.getReceivingId()))))) continue;
            purchasePaymentVO2.setReceivingNo(((BookAccountVO)bookAccountVOS.get(0)).getAccountNo());
        }
    }

    private void translateBusinessPartner(PurchasePaymentVO purchasePaymentVO) {
        List bookAccountVOS;
        List paymentSlipVOS;
        ArrayList<Long> bookIdList = new ArrayList<Long>();
        ArrayList<Long> bankAccountIdList = new ArrayList<Long>();
        bookIdList.add(purchasePaymentVO.getPayCompanyBookId());
        bookIdList.add(purchasePaymentVO.getSupplierLegalBookId());
        bookIdList.add(purchasePaymentVO.getFinalPaymentCompanyBookId());
        bookIdList.add(purchasePaymentVO.getReceivingUnitBookId());
        if (StringUtils.hasText((String)purchasePaymentVO.getReceivingId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getReceivingId()));
        }
        if (StringUtils.hasText((String)purchasePaymentVO.getPaymentId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getPaymentId()));
        }
        if (StringUtils.hasText((String)purchasePaymentVO.getFinalPaymentId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getFinalPaymentId()));
        }
        if (!CollectionUtils.isEmpty((Collection)(paymentSlipVOS = purchasePaymentVO.getPaymentSlipVOS()))) {
            paymentSlipVOS.forEach(paymentSlipVO -> {
                bookIdList.add(paymentSlipVO.getReceivingCompanyBookId());
                bookIdList.add(paymentSlipVO.getPayCompanyBookId());
                if (StringUtils.hasText((String)paymentSlipVO.getReceivingAccount())) {
                    bankAccountIdList.add(Long.valueOf(paymentSlipVO.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)paymentSlipVO.getPaymentAccount())) {
                    bankAccountIdList.add(Long.valueOf(paymentSlipVO.getPaymentAccount()));
                }
            });
        }
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        Map bookAccountMap = new HashMap();
        if (!CollectionUtils.isEmpty(bankAccountIdList)) {
            bookAccountMap = this.bookAccountService.queryByIdList(bankAccountIdList);
        }
        purchasePaymentVO.setSupplierLegalName((String)nameByBookIds.get(purchasePaymentVO.getSupplierLegalBookId()));
        purchasePaymentVO.setPayCompanyName((String)nameByBookIds.get(purchasePaymentVO.getPayCompanyBookId()));
        purchasePaymentVO.setFinalPaymentCompanyName((String)nameByBookIds.get(purchasePaymentVO.getFinalPaymentCompanyBookId()));
        purchasePaymentVO.setReceivingUnitName((String)nameByBookIds.get(purchasePaymentVO.getReceivingUnitBookId()));
        if (StringUtils.hasText((String)purchasePaymentVO.getReceivingId()) && !CollectionUtils.isEmpty((Collection)(bookAccountVOS = (List)bookAccountMap.get(Long.valueOf(purchasePaymentVO.getReceivingId()))))) {
            purchasePaymentVO.setReceivingNo(((BookAccountVO)bookAccountVOS.get(0)).getAccountNo());
            purchasePaymentVO.setReceivingBankPrint(((BookAccountVO)bookAccountVOS.get(0)).getDepositBankOutlet());
            purchasePaymentVO.setReceivingNamePrint(((BookAccountVO)bookAccountVOS.get(0)).getAccountName());
        }
        if (StringUtils.hasText((String)purchasePaymentVO.getPaymentId()) && !CollectionUtils.isEmpty((Collection)(bookAccountVOS = (List)bookAccountMap.get(Long.valueOf(purchasePaymentVO.getPaymentId()))))) {
            purchasePaymentVO.setPaymentIdDesc(((BookAccountVO)bookAccountVOS.get(0)).getAccountNo());
        }
        if (StringUtils.hasText((String)purchasePaymentVO.getFinalPaymentId()) && !CollectionUtils.isEmpty((Collection)(bookAccountVOS = (List)bookAccountMap.get(Long.valueOf(purchasePaymentVO.getFinalPaymentId()))))) {
            purchasePaymentVO.setFinalPaymentIdDesc(((BookAccountVO)bookAccountVOS.get(0)).getAccountNo());
        }
        if (!CollectionUtils.isEmpty((Collection)paymentSlipVOS)) {
            for (PaymentSlipVO paymentSlipVO2 : paymentSlipVOS) {
                List paymentBookAccountVOS;
                paymentSlipVO2.setPayCompanyBookIdDesc((String)nameByBookIds.get(paymentSlipVO2.getPayCompanyBookId()));
                paymentSlipVO2.setReceivingCompanyBookIdDesc((String)nameByBookIds.get(paymentSlipVO2.getReceivingCompanyBookId()));
                if (!StringUtils.hasText((String)paymentSlipVO2.getReceivingAccount())) continue;
                List receivingBookAccountVOS = (List)bookAccountMap.get(Long.valueOf(paymentSlipVO2.getReceivingAccount()));
                if (!CollectionUtils.isEmpty((Collection)receivingBookAccountVOS)) {
                    paymentSlipVO2.setReceivingAccountDesc(((BookAccountVO)receivingBookAccountVOS.get(0)).getAccountNo());
                }
                if (CollectionUtils.isEmpty((Collection)(paymentBookAccountVOS = (List)bookAccountMap.get(Long.valueOf(paymentSlipVO2.getPaymentAccount()))))) continue;
                paymentSlipVO2.setPaymentAccountDesc(((BookAccountVO)paymentBookAccountVOS.get(0)).getAccountNo());
            }
        }
    }

    private void setDocumentId(PurchasePaymentVO purchasePaymentVO) {
        if (purchasePaymentVO.getDocNo() != null) {
            switch (PurchasePaymentEnum.PaymentDocType.match(purchasePaymentVO.getDocType())) {
                case CONTRACT: {
                    PurchaseContractManagerVO purchaseContractManagerVO = this.purchaseContractManagerService.queryByNo(purchasePaymentVO.getDocNo());
                    if (purchaseContractManagerVO == null) break;
                    purchasePaymentVO.setDocId(purchaseContractManagerVO.getId());
                    purchasePaymentVO.setPurchaseContractType(purchaseContractManagerVO.getPurchaseContractType());
                    break;
                }
                case AGREEMENT: {
                    purchasePaymentVO.setDocId(this.purchaseAgreementService.findIdByNo(purchasePaymentVO.getDocNo()));
                    break;
                }
                case OPPORTUNITY: {
                    PurchasePaymentDefaultVO paymentDefaultByDocNo = this.crmOpportunityService.findPaymentDefaultByDocNo(purchasePaymentVO.getDocNo());
                    if (paymentDefaultByDocNo == null) break;
                    purchasePaymentVO.setDocId(paymentDefaultByDocNo.getDocId());
                }
            }
        }
        if (purchasePaymentVO.getRelatedSalesContract() != null) {
            purchasePaymentVO.setRelatedSalesContractId(this.saleConContractService.findIdByNo(purchasePaymentVO.getRelatedSalesContract()));
        }
        if (purchasePaymentVO.getRelatedProjectNo() != null) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.findIdByNo(purchasePaymentVO.getRelatedProjectNo());
            purchasePaymentVO.setRelatedProjectId(pmsProjectVO.getId());
            purchasePaymentVO.setRelatedSubjectTempId(pmsProjectVO.getSubjectTempId());
        }
    }

    private boolean judgePaymentPlanIsInsert(String paymentApplicationType, String docType) {
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            case CONTRACT: {
                return false;
            }
            case ADVANCE_PAY: {
                return !PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(docType);
            }
        }
        return true;
    }

    private void saveBillVerDetail(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        List billVerDetailPayloads = payload.getBillVerDetailPayloads();
        HashMap oldTheAmtMap = new HashMap();
        if (!isInsert.booleanValue()) {
            List billVerDetailVOS = this.billVerDetailService.queryListByPaymentApplyId(payload.getDocType(), payload.getId());
            if (!CollectionUtils.isEmpty((Collection)billVerDetailVOS)) {
                billVerDetailVOS.forEach(billVerDetailVO -> {
                    String billCode;
                    String key = billCode = billVerDetailVO.getBillNo() == null ? "" : billVerDetailVO.getBillNo();
                    BigDecimal oldTheAmt = billVerDetailVO.getTheAmt();
                    oldTheAmt = oldTheAmt == null ? BigDecimal.ZERO : oldTheAmt;
                    oldTheAmtMap.put(key, oldTheAmt);
                });
            }
            this.billVerDetailService.deleteByPaymentApplyId(payload.getId());
        }
        BigDecimal[] allTheAmt = new BigDecimal[]{BigDecimal.ZERO};
        if (!CollectionUtils.isEmpty((Collection)billVerDetailPayloads)) {
            HashMap newTheAmtMap = new HashMap();
            billVerDetailPayloads.forEach(billVerDetailPayload -> {
                BigDecimal oldTheAmt;
                String billCode;
                BigDecimal theAmt = billVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getTheAmt();
                String key = billCode = billVerDetailPayload.getBillNo() == null ? "" : billVerDetailPayload.getBillNo();
                newTheAmtMap.put(key, theAmt);
                allTheAmt[0] = allTheAmt[0].add(theAmt);
                BigDecimal invoiceAmt = billVerDetailPayload.getInvoiceAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getInvoiceAmt();
                BigDecimal writtenOffAmt = billVerDetailPayload.getWrittenOffAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getWrittenOffAmt();
                BigDecimal bigDecimal = oldTheAmt = oldTheAmtMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)oldTheAmtMap.get(key);
                if (writtenOffAmt.add(theAmt.subtract(oldTheAmt)).compareTo(invoiceAmt) > 0) {
                    throw TwException.error("", "\u7968\u636e\u53f7\u7801\u4e3a\u3010" + billVerDetailPayload.getBillNo() + "\u3011\u7684\u7968\u636e\u603b\u6838\u9500\u91d1\u989d\u9700\u5c0f\u4e8e\u7968\u636e\u91d1\u989d");
                }
                billVerDetailPayload.setPaymentApplyId(payload.getId());
            });
            if (newTheAmtMap.size() < billVerDetailPayloads.size()) {
                throw TwException.error("", "\u7968\u636e\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
            this.billVerDetailService.insertAll(billVerDetailPayloads);
        }
    }

    public PurchasePaymentServiceImpl(CostUndertakeDepartmentService costUndertakeDepartmentService, PurchasePaymentRepo purchasePaymentRepo, PurchasePaymentDAO purchasePaymentDAO, CostUndertakeDepartmentRepo costUndertakeDepartmentRepo, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, SaleConContractService saleConContractService, SaleConContractRepo saleConContractRepo, PrdOrgOrganizationService prdOrgOrganizationService, PurchaseContractManagerRepo purchaseContractManagerRepo, CrmOpportunityService crmOpportunityService, PurchaseAgreementRepo purchaseAgreementRepo, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, FileUtil fileUtil, PurchasePaymentPlanService purchasePaymentPlanService, PurchaseAgreementService purchaseAgreementService, PrdSystemRoleService systemRoleService, PaymentPlanReferService paymentPlanReferService, PaymentSlipService paymentSlipService, PmsProjectService pmsProjectService, ExcelUtil excelUtil, CacheUtil cacheUtil, BusinessPartnerService businessPartnerService, BookAccountService bookAccountService, ResWithdrawApplyService resWithdrawApplyService, InvInvoiceService invInvoiceService, InvInvoiceVerDetailService invInvoiceVerDetailService, BillVerDetailService billVerDetailService, PurchaseContractDetailsService purchaseContractDetailsService, PurchaseAgreementDetailsService purchaseAgreementDetailsService, BusinessCustomerInfoService businessCustomerInfoService) {
        this.costUndertakeDepartmentService = costUndertakeDepartmentService;
        this.purchasePaymentRepo = purchasePaymentRepo;
        this.purchasePaymentDAO = purchasePaymentDAO;
        this.costUndertakeDepartmentRepo = costUndertakeDepartmentRepo;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.saleConContractService = saleConContractService;
        this.saleConContractRepo = saleConContractRepo;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.purchaseContractManagerRepo = purchaseContractManagerRepo;
        this.crmOpportunityService = crmOpportunityService;
        this.purchaseAgreementRepo = purchaseAgreementRepo;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.fileUtil = fileUtil;
        this.purchasePaymentPlanService = purchasePaymentPlanService;
        this.purchaseAgreementService = purchaseAgreementService;
        this.systemRoleService = systemRoleService;
        this.paymentPlanReferService = paymentPlanReferService;
        this.paymentSlipService = paymentSlipService;
        this.pmsProjectService = pmsProjectService;
        this.excelUtil = excelUtil;
        this.cacheUtil = cacheUtil;
        this.businessPartnerService = businessPartnerService;
        this.bookAccountService = bookAccountService;
        this.resWithdrawApplyService = resWithdrawApplyService;
        this.invInvoiceService = invInvoiceService;
        this.invInvoiceVerDetailService = invInvoiceVerDetailService;
        this.billVerDetailService = billVerDetailService;
        this.purchaseContractDetailsService = purchaseContractDetailsService;
        this.purchaseAgreementDetailsService = purchaseAgreementDetailsService;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

