/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanListExcelExport;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanSavePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConServicePriceService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanDataVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConRecvplanChangeLogVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ContractNodeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractRecvplanEntity;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivablePlanConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConRecvplanChangeLogConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConRecvplanChangeLogDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConReceivablePlanServiceImpl
extends BaseServiceImpl
implements ConReceivablePlanService {
    private static final Logger log = LoggerFactory.getLogger(ConReceivablePlanServiceImpl.class);
    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final ConReceivablePlanDAO conReceivablePlanDAO;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;
    private final PrdOrgEmployeeService employeeService;
    private final BusinessPartnerService businessPartnerService;
    private final ConServicePriceService conServicePriceService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final UdcUtil udcUtil;
    private final ExcelUtil excelUtil;
    private final FileService fileService;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.sale.contractRecvplan}")
    private String contractRecvplan;
    private final ConRecvplanChangeLogDAO conRecvplanChangeLogDAO;
    private final SaleConContractRepo saleConContractRepo;
    private final SaleConContractDAO saleConContractDao;
    private final ConInvBatchRepo conInvBatchRepo;
    private final TimesheetRepo timesheetRepo;

    public PagingVO<ConReceivablePlanVO> paging(ConReceivablePlanQuery query) {
        Page page = this.conReceivablePlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConReceivablePlanConvert.INSTANCE::toVo));
    }

    public ConReceivablePlanDataVO queryAppMyHandlNum(String type) {
        if (!StringUtils.hasText((String)type)) {
            throw TwException.error("", "\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        LocalDate localDate = LocalDate.now();
        List<String> receStatus = StringUtils.hasText((String)type) && type.equals("1") ? Arrays.asList(ReceStatusEnum.OK_INVOICE.getCode(), ReceStatusEnum.PART_PAYMENT.getCode()) : Arrays.asList(ReceStatusEnum.NO_INVOICE.getCode());
        query.setReceStatusList(receStatus);
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        if (query.getIsPermission().booleanValue()) {
            this.getPermissionParams(saleConContractQuery);
        }
        List orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);
        if (StringUtils.hasText((String)type) && type.equals("2")) {
            query.setSaleConStatusIn(Arrays.asList("APPROVING", "ACTIVE"));
        }
        List<ConReceivablePlanVO> conReceivablePlanVOS = this.conReceivablePlanDAO.queryListDynamic(query);
        long overdueNum = 0L;
        long oneMonthNum = 0L;
        long threeMonthNum = 0L;
        long totalNum = conReceivablePlanVOS.size();
        if (StringUtils.hasText((String)type) && type.equals("1")) {
            overdueNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isBefore(localDate)).count();
            oneMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isAfter(localDate.minusDays(1L)) && vo.getExpectReceDate().isBefore(localDate.plusDays(30L))).count();
            threeMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isAfter(localDate.minusDays(1L)) && vo.getExpectReceDate().isBefore(localDate.plusDays(90L))).count();
        } else {
            overdueNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isBefore(localDate)).count();
            oneMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isAfter(localDate.minusDays(1L)) && vo.getExpectInvDate().isBefore(localDate.plusDays(30L))).count();
            threeMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isAfter(localDate.minusDays(1L)) && vo.getExpectInvDate().isBefore(localDate.plusDays(90L))).count();
        }
        ConReceivablePlanDataVO dataVO = new ConReceivablePlanDataVO();
        dataVO.setType(type);
        dataVO.setOneMonthNum(oneMonthNum);
        dataVO.setOverdueNum(overdueNum);
        dataVO.setThreeMonthNum(threeMonthNum);
        dataVO.setTotalNum(totalNum);
        return dataVO;
    }

    public PagingVO<ConReceivablePlanVO> queryPaging(ConReceivablePlanQuery query) {
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        if (query.getIsPermission().booleanValue()) {
            this.getPermissionParams(saleConContractQuery);
        }
        List orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);
        PagingVO<ConReceivablePlanVO> paging = this.conReceivablePlanDAO.queryPaging(query);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List partnerIdList = records.stream().filter(p -> p.getPartnerId() != null).map(e -> e.getPartnerId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(partnerIdList)) {
                BusinessCustomerInfoQuery businessCustomerInfoQuery = new BusinessCustomerInfoQuery();
                businessCustomerInfoQuery.setPartnerIdList(partnerIdList);
                List businessCustomerInfoVOS = this.businessCustomerInfoService.queryListDynamic(businessCustomerInfoQuery);
                if (!CollectionUtils.isEmpty((Collection)businessCustomerInfoVOS)) {
                    Map map = businessCustomerInfoVOS.stream().collect(Collectors.groupingBy(BusinessCustomerInfoVO::getPartnerId, Collectors.toList()));
                    records.forEach(p -> {
                        if (p.getPartnerId() != null && map.containsKey(p.getPartnerId())) {
                            p.setCustomerNo(((BusinessCustomerInfoVO)((List)map.get(p.getPartnerId())).get(0)).getCustomerNo());
                        }
                    });
                }
            }
            records.forEach(e -> {
                e.setDistAmt((e.getActualRecvAmt() == null ? BigDecimal.ZERO : e.getActualRecvAmt()).subtract(e.getConfirmedAmt() == null ? BigDecimal.ZERO : e.getConfirmedAmt()));
                e.setNotReceAmt(e.getReceAmt().subtract(e.getActualRecvAmt() == null ? BigDecimal.ZERO : e.getActualRecvAmt()));
            });
            List recvplanIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            ConRecvplanChangeLogQuery logQuery = new ConRecvplanChangeLogQuery();
            logQuery.setRecvplanIds(recvplanIds);
            List<ConRecvplanChangeLogVO> conRecvplanChangeLogVOS = this.conRecvplanChangeLogDAO.queryListDynamic(logQuery);
            conRecvplanChangeLogVOS.forEach(e -> e.setCreateUserName(this.cacheUtil.getUserName(e.getCreateUserId())));
            if (!CollectionUtils.isEmpty(conRecvplanChangeLogVOS)) {
                for (ConReceivablePlanVO vo : records) {
                    List recvDateChangeLogs = conRecvplanChangeLogVOS.stream().filter(e -> vo.getId().equals(e.getRecvplanId()) && "RECV".equals(e.getType())).collect(Collectors.toList());
                    List invDateChangeLogs = conRecvplanChangeLogVOS.stream().filter(e -> vo.getId().equals(e.getRecvplanId()) && "INV".equals(e.getType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(recvDateChangeLogs)) {
                        vo.setRecvDateChangeLogs(recvDateChangeLogs);
                    }
                    if (CollectionUtils.isEmpty(invDateChangeLogs)) continue;
                    vo.setInvDateChangeLogs(invDateChangeLogs);
                }
            }
        }
        return paging;
    }

    private void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        List<String> financeRoles = Arrays.asList("FINANCE_MEMBER", "PLAT_FIN_CASHIER", "PLAT_FIN_MANAGER", "PLAT_CFO");
        ArrayList<String> dibRoles = new ArrayList<String>(roles);
        dibRoles.addAll(financeRoles);
        if (!CollectionUtils.isEmpty(userSystemRoleCodes) && CollectionUtils.containsAny(userSystemRoleCodes, dibRoles)) {
            return;
        }
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO paging = this.orgService.paging(orgQuery);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List orgIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList());
        }
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    public List<ConReceivablePlanVO> queryList(ConReceivablePlanQuery query) {
        return ConReceivablePlanConvert.INSTANCE.toVoList(this.conReceivablePlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<ConReceivablePlanVO> queryListDynamic(ConReceivablePlanQuery query) {
        return this.conReceivablePlanDAO.queryListDynamic(query);
    }

    public Long countListDynamic(ConReceivablePlanQuery query) {
        return this.conReceivablePlanDAO.count(query);
    }

    public ConReceivablePlanVO queryByKey(Long key) {
        ConReceivablePlanVO vo = this.conReceivablePlanDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw new BusinessException(ApiCode.NOT_FOUND, "\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        Assert.notNull((Object)vo.getId(), (String)"\u4e0d\u5b58\u5728");
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivablePlanVO insert(ConReceivablePlanPayload payload) {
        this.dataCheck(payload, false);
        ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("CON_PLAN", new String[0]);
        entityDo.setReceNo(code);
        this.logService.saveNewLog(payload.getSaleConId(), PrdSystemObjectEnum.SaleConContract.getCode(), "\u65b0\u5efa\u6536\u6b3e\u8ba1\u5212");
        return ConReceivablePlanConvert.INSTANCE.toVo((ConReceivablePlanDO)this.conReceivablePlanRepo.save(entityDo));
    }

    public int saveContractRecvPlans(ConReceivablePlanSavePayload payload) {
        List delList = payload.getDelList();
        List payloads = payload.getPayloads();
        if (!CollectionUtils.isEmpty((Collection)delList)) {
            this.conReceivablePlanDAO.deleteSoft(delList);
        }
        if (!CollectionUtils.isEmpty((Collection)payloads)) {
            List planDOS = payloads.stream().map(ConReceivablePlanConvert.INSTANCE::toDo).collect(Collectors.toList());
            this.conReceivablePlanRepo.saveAll(planDOS);
        }
        return 1;
    }

    private void dataCheck(ConReceivablePlanPayload payload, boolean flag) {
        SaleConContractDO conContractDO;
        Optional byId;
        LocalDate expectReceDate = payload.getExpectReceDate();
        LocalDate expectInvDate = payload.getExpectInvDate();
        String receStatus = payload.getReceStatus();
        if (StringUtils.hasText((String)receStatus) && (receStatus.equals("2") || receStatus.equals("3") || receStatus.equals("4"))) {
            ConReceivablePlanVO conReceivablePlanVO = this.queryByKey(payload.getId());
            LocalDate invDate = conReceivablePlanVO.getInvDate();
            if (expectReceDate != null && invDate != null && (expectReceDate.isBefore(invDate) || expectInvDate.equals(invDate))) {
                throw TwException.error("", "\u5df2\u5f00\u7968\u7684\u6536\u6b3e\u8ba1\u5212\uff0c\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u5b9e\u9645\u5f00\u7968\u65e5\u671f\uff01");
            }
        } else if (expectReceDate != null && expectInvDate != null && (expectReceDate.isBefore(expectInvDate) || expectInvDate.equals(expectReceDate))) {
            throw TwException.error("", "\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u9884\u8ba1\u5f00\u7968\u65e5\u671f\uff01");
        }
        List<ConReceivablePlanVO> conReceivablePlanVOS = this.queryBySaleConId(payload.getSaleConId());
        HashSet<LocalDate> expectReceDateSet = new HashSet<LocalDate>();
        HashSet<LocalDate> expectInvDateSet = new HashSet<LocalDate>();
        BigDecimal oriPlanAmt = BigDecimal.ZERO;
        for (ConReceivablePlanVO planVO : conReceivablePlanVOS) {
            expectReceDateSet.add(planVO.getExpectReceDate());
            expectInvDateSet.add(planVO.getExpectInvDate());
            if (flag && payload.getId().equals(planVO.getId())) continue;
            oriPlanAmt = oriPlanAmt.add(planVO.getReceAmt());
        }
        if (payload.getId() != null && (byId = this.conReceivablePlanRepo.findByIdAndDeleteFlag(payload.getId(), 0)).isPresent()) {
            expectReceDateSet.remove(byId.get().getExpectReceDate());
            expectInvDateSet.remove(((ConReceivablePlanDO)byId.get()).getExpectInvDate());
        }
        if (!expectReceDateSet.add(expectReceDate)) {
            throw TwException.error("", "\u540c\u4e00\u4e2a\u5408\u540c\u7684\u4e0d\u540c\u6536\u6b3e\u8ba1\u5212\u7684\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u76f8\u540c\uff01");
        }
        if (!expectInvDateSet.add(expectInvDate)) {
            throw TwException.error("", "\u540c\u4e00\u4e2a\u5408\u540c\u7684\u4e0d\u540c\u6536\u6b3e\u8ba1\u5212\u7684\u9884\u8ba1\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u76f8\u540c\uff01");
        }
        byId = this.saleConContractRepo.findById(payload.getSaleConId());
        if (byId.isPresent() && SaleConEnum.CLOSED.getCode().equals(((SaleConContractDO)byId.get()).getRangeProp()) && (oriPlanAmt = oriPlanAmt.add(payload.getReceAmt())).compareTo((conContractDO = (SaleConContractDO)byId.get()).getAmt()) > 0) {
            throw TwException.error("", "\u6536\u6b3e\u8ba1\u5212\u603b\u91d1\u989d\u8d85\u51fa\u4e86\u5b50\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ConReceivablePlanVO> insertAll(List<ConReceivablePlanPayload> payloadList) {
        ArrayList<ConReceivablePlanDO> entityDoList = new ArrayList<ConReceivablePlanDO>();
        for (ConReceivablePlanPayload payload : payloadList) {
            ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
            entityDoList.add(entityDo);
            String code = this.generateSeqNum("CON_PLAN", new String[0]);
            entityDo.setReceNo(code);
            this.logService.saveNewLog(payload.getSaleConId(), PrdSystemObjectEnum.SaleConContract.getCode(), "\u65b0\u5efa\u6536\u6b3e\u8ba1\u5212");
        }
        return ConReceivablePlanConvert.INSTANCE.toVo(this.conReceivablePlanRepo.saveAll(entityDoList));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivablePlanVO update(ConReceivablePlanPayload payload) {
        this.dataCheck(payload, true);
        ConReceivablePlanDO entity = this.conReceivablePlanRepo.findById(payload.getId()).orElseGet(ConReceivablePlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivablePlanConvert.INSTANCE.toVo((ConReceivablePlanDO)this.conReceivablePlanRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conReceivablePlanDAO.deleteSoft(keys);
        }
    }

    public List<ConReceivablePlanVO> queryBySaleConId(Long saleConId) {
        return this.conReceivablePlanDAO.queryBySaleConId(saleConId);
    }

    public PagingVO<ConReceivablePlanVO> queryBySaleConId(Long saleConId, ConReceivablePlanQuery query) {
        List partnerIdList;
        query.setSaleConId(saleConId);
        PagingVO<ConReceivablePlanVO> conReceivablePlanVOPagingVO = this.conReceivablePlanDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)conReceivablePlanVOPagingVO.getRecords()) && !CollectionUtils.isEmpty(partnerIdList = conReceivablePlanVOPagingVO.getRecords().stream().filter(p -> p.getPartnerId() != null).map(e -> e.getPartnerId()).collect(Collectors.toList()))) {
            BusinessCustomerInfoQuery businessCustomerInfoQuery = new BusinessCustomerInfoQuery();
            businessCustomerInfoQuery.setPartnerIdList(partnerIdList);
            List businessCustomerInfoVOS = this.businessCustomerInfoService.queryListDynamic(businessCustomerInfoQuery);
            if (!CollectionUtils.isEmpty((Collection)businessCustomerInfoVOS)) {
                Map map = businessCustomerInfoVOS.stream().collect(Collectors.groupingBy(BusinessCustomerInfoVO::getPartnerId, Collectors.toList()));
                conReceivablePlanVOPagingVO.getRecords().forEach(p -> {
                    if (p.getPartnerId() != null && map.containsKey(p.getPartnerId())) {
                        p.setCustomerNo(((BusinessCustomerInfoVO)((List)map.get(p.getPartnerId())).get(0)).getCustomerNo());
                    }
                });
            }
        }
        return conReceivablePlanVOPagingVO;
    }

    public void batchReceivablePlanExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<ConReceivablePlanVO> paging = this.queryPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.downloadReceivablePlanList(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadBatch(HttpServletResponse response, ConReceivablePlanQuery query) {
        try {
            Workbook workbook = null;
            Object fileName = "";
            if (StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("model")) {
                workbook = this.getVol();
                fileName = "\u6536\u6b3e\u8ba1\u5212\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
                ExcelUtil.writeResponse(response, (String)fileName, workbook);
            } else {
                fileName = "\u6536\u6b3e\u8ba1\u5212\u6570\u636e-" + LocalDate.now();
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                PagingVO<ConReceivablePlanVO> paging = this.queryPaging(query);
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                List records = paging.getRecords();
                this.download(records, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> importBatchPro(MultipartFile file, Boolean force, Long saleConId) throws InterruptedException {
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ConReceivablePlanPayload.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List<ConReceivablePlanPayload> conReceivablePlanPayloadList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(conReceivablePlanPayloadList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int warnNum = 0;
        int errorNum = 0;
        for (ConReceivablePlanPayload payload : conReceivablePlanPayloadList) {
            String expectInvDateStr;
            StringBuilder importError = new StringBuilder();
            StringBuilder importWarn = new StringBuilder();
            payload.setSaleConId(saleConId);
            String expectReceDateStr = payload.getExpectReceDateStr();
            if (StringUtils.hasText((String)expectReceDateStr)) {
                try {
                    LocalDate parse = LocalDate.parse(expectReceDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    payload.setExpectReceDate(parse);
                }
                catch (Exception e) {
                    importError.append("\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b");
                }
            }
            if (StringUtils.hasText((String)(expectInvDateStr = payload.getExpectInvDateStr()))) {
                try {
                    LocalDate parse = LocalDate.parse(expectInvDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    payload.setExpectInvDate(parse);
                }
                catch (Exception e) {
                    importError.append("\u9884\u8ba1\u5f00\u7968\u65e5\u671f\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b");
                }
            }
            payload.setTaxRate(BigDecimal.valueOf(0.06));
            payload.setNotInvAmt(ObjectUtils.isEmpty((Object)payload.getReceAmt()) ? BigDecimal.ZERO : payload.getReceAmt());
            payload.setNotReceAmt(ObjectUtils.isEmpty((Object)payload.getReceAmt()) ? BigDecimal.ZERO : payload.getReceAmt());
            payload.setImoprtError(importError.toString());
            payload.setImportWarn(importWarn.toString());
            payload.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
            if (StringUtils.hasText((CharSequence)importError) && importError.length() > 0) {
                ++errorNum;
            }
            if (!StringUtils.hasText((CharSequence)importWarn) && importWarn.length() <= 0 || force.booleanValue()) continue;
            ++warnNum;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(conReceivablePlanPayloadList));
        } else {
            this.insertAll(conReceivablePlanPayloadList);
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    public void syncContractRecvplanTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "contract_recvplan_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 7, 1, 0, 0) : syncTime.minusSeconds(120L));
        XxlJobLogger.log((String)"\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncContractRecvplanTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConReceivablePlanDO> receivablePlanDOS = this.conReceivablePlanRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(receivablePlanDOS)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            ArrayList<TwContractRecvplanEntity> copy = new ArrayList<TwContractRecvplanEntity>();
            for (ConReceivablePlanDO tempDo : receivablePlanDOS) {
                TwContractRecvplanEntity e = new TwContractRecvplanEntity();
                e.setInvbatchId(tempDo.getInvBatchId());
                e.setContractId(tempDo.getSaleConId());
                e.setPhaseDesc(tempDo.getReceStage());
                e.setRecvNo(tempDo.getReceNo());
                e.setRecvStatus(tempDo.getReceStatus());
                if (tempDo.getReceRatio() != null) {
                    e.setRecvRatio(tempDo.getReceRatio().divide(new BigDecimal(100)));
                }
                e.setRecvAmt(tempDo.getReceAmt());
                e.setExpectRecvDate(tempDo.getExpectReceDate());
                e.setInvAmt(tempDo.getAlreadyInvAmt());
                e.setExpectInvDate(tempDo.getExpectInvDate());
                e.setInvDate(tempDo.getInvDate());
                e.setActualRecvAmt(tempDo.getActualRecvAmt());
                e.setActualRecvDate(tempDo.getActualRecvDate());
                e.setConfirmedAmt(tempDo.getConfirmedAmt());
                e.setRemark(tempDo.getRemark());
                e.setRecvplanIdV5(tempDo.getId());
                e.setRecvplanIdV4(tempDo.getReceivePlanIdV4());
                e.setDelFlag(tempDo.getDeleteFlag().longValue());
                e.setCreateUserId(v4AndV5UserIds.get(tempDo.getCreateUserId()));
                e.setModifyUserId(v4AndV5UserIds.get(tempDo.getModifyUserId()));
                e.setCreateTime(tempDo.getCreateTime());
                e.setModifyTime(tempDo.getModifyTime());
                copy.add(e);
            }
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwContractRecvplanEntity temDo : copy) {
                    LocalDateTime syncEndTime;
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
                        HashMap data = new HashMap();
                        if (("" + data.get("ok")).equals("true")) continue;
                        syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3e\u8ba1\u5212id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + data.get("datum"), null);
                        this.conInvBatchRepo.updateRemark(temDo.getRecvplanIdV5());
                        ++failNum;
                    }
                    catch (Exception e) {
                        XxlJobLogger.log((String)("\u5408\u540c\u6536\u6b3e\u8ba1\u5212" + temDo.getRecvplanIdV5() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                        syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3e\u8ba1\u5212id" + temDo.getRecvplanIdV5() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                        ++failNum;
                        this.conReceivablePlanRepo.updateRemark(temDo.getRecvplanIdV5());
                    }
                }
                syncData = "\u66f4\u65b0\u4e86" + (copy.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
            } else {
                syncData = "\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    @Transactional
    public void invalidRecvplan(List<Long> ids, String remark) {
        this.conReceivablePlanDAO.updateStatusAndRemarkByKeys(ids, "5", remark);
    }

    public Boolean updateRecvOrInvDate(ConRecvplanChangeLogPayload payload) {
        Long recvplanId = payload.getRecvplanId();
        Optional optional = this.conReceivablePlanRepo.findById(recvplanId);
        if (!optional.isPresent()) {
            return false;
        }
        ConReceivablePlanDO conReceivablePlanDO = (ConReceivablePlanDO)optional.get();
        if (ObjectUtils.isEmpty((Object)conReceivablePlanDO)) {
            return false;
        }
        if (payload.getType().equals("RECV")) {
            conReceivablePlanDO.setExpectReceDate(payload.getRecvOrInvDate());
        } else {
            conReceivablePlanDO.setExpectInvDate(payload.getRecvOrInvDate());
        }
        this.conReceivablePlanDAO.save(conReceivablePlanDO);
        this.conRecvplanChangeLogDAO.save(ConRecvplanChangeLogConvert.INSTANCE.toDo(payload));
        return true;
    }

    @Transactional
    public void updateExpectReceDate(Map<Long, String> updateData) {
        for (Long id : updateData.keySet()) {
            this.conReceivablePlanDAO.updateExpectReceDate(id, LocalDate.parse(updateData.get(id)));
        }
    }

    public List<ContractNodeVO> findConNodeByConId(Long saleConId) {
        return this.conReceivablePlanDAO.findConNodeByConId(saleConId);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/conReceivablePlan.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            return workbook;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void downloadReceivablePlanList(List<ConReceivablePlanVO> records, HttpServletResponse response) throws IOException {
        boolean order = true;
        String sheetName = "\u91c7\u8d2d\u9700\u6c42\u6570\u636e";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ConReceivablePlanVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConReceivablePlanVO.class, null);
        sheet.doWrite(records);
    }

    private void download(List<ConReceivablePlanVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        records = this.udcUtil.translateList(records);
        String sheetName = "\u6536\u6b3e\u8ba1\u5212\u6570\u636e";
        List<ConReceivablePlanListExcelExport> resultList = ConReceivablePlanConvert.INSTANCE.voListVoExcelExport(records);
        for (ConReceivablePlanListExcelExport record : resultList) {
            record.setOrder(String.valueOf(order));
            ++order;
        }
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ConReceivablePlanListExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConReceivablePlanListExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    private Object downloadModelWithData(List<ConReceivablePlanPayload> records) {
        Workbook workbook = this.getVol();
        try {
            XSSFSheet planSheet = (XSSFSheet)workbook.getSheet("\u5bfc\u5165");
            if (!CollectionUtils.isEmpty(records) && planSheet != null) {
                XSSFCell errorCell = planSheet.getRow(0).getCell(7) == null ? planSheet.getRow(0).createCell(7) : planSheet.getRow(0).getCell(7);
                errorCell.setCellValue("\u5bfc\u5165\u9519\u8bef");
                XSSFCell warnCell = planSheet.getRow(0).getCell(8) == null ? planSheet.getRow(0).createCell(8) : planSheet.getRow(0).getCell(8);
                warnCell.setCellValue("\u5bfc\u5165\u8b66\u544a");
                int nextRow = 1;
                for (ConReceivablePlanPayload dataPayload : records) {
                    XSSFRow row = planSheet.getRow(nextRow);
                    if (row == null) {
                        row = planSheet.createRow(nextRow);
                    }
                    this.excelUtil.setCellValueNew((Row)row, 0, dataPayload.getReceNo());
                    this.excelUtil.setCellValueNew((Row)row, 1, dataPayload.getReceStage());
                    this.excelUtil.setCellValueNew((Row)row, 2, dataPayload.getReceAmt());
                    this.excelUtil.setCellValueNew((Row)row, 3, dataPayload.getReceRatio());
                    this.excelUtil.setCellValueNew((Row)row, 4, dataPayload.getExpectReceDateStr());
                    this.excelUtil.setCellValueNew((Row)row, 5, dataPayload.getExpectInvDateStr());
                    this.excelUtil.setCellValueNew((Row)row, 6, dataPayload.getRemark());
                    this.excelUtil.setCellValueNew((Row)row, 7, dataPayload.getImoprtError());
                    this.excelUtil.setCellValueNew((Row)row, 8, dataPayload.getImportWarn());
                    ++nextRow;
                }
            }
            String fileName = "\u5bfc\u5165-" + UUID.randomUUID() + ".xlsx";
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = this.fileService.upload(file);
            return upload.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public ConReceivablePlanServiceImpl(ConReceivablePlanRepo conReceivablePlanRepo, ConReceivablePlanDAO conReceivablePlanDAO, PrdSystemLogService logService, CacheUtil cacheUtil, PrdOrgOrganizationService orgService, PrdOrgEmployeeService employeeService, BusinessPartnerService businessPartnerService, ConServicePriceService conServicePriceService, BusinessCustomerInfoService businessCustomerInfoService, UdcUtil udcUtil, ExcelUtil excelUtil, FileService fileService, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, ConRecvplanChangeLogDAO conRecvplanChangeLogDAO, SaleConContractRepo saleConContractRepo, SaleConContractDAO saleConContractDao, ConInvBatchRepo conInvBatchRepo, TimesheetRepo timesheetRepo) {
        this.conReceivablePlanRepo = conReceivablePlanRepo;
        this.conReceivablePlanDAO = conReceivablePlanDAO;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.orgService = orgService;
        this.employeeService = employeeService;
        this.businessPartnerService = businessPartnerService;
        this.conServicePriceService = conServicePriceService;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.udcUtil = udcUtil;
        this.excelUtil = excelUtil;
        this.fileService = fileService;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.conRecvplanChangeLogDAO = conRecvplanChangeLogDAO;
        this.saleConContractRepo = saleConContractRepo;
        this.saleConContractDao = saleConContractDao;
        this.conInvBatchRepo = conInvBatchRepo;
        this.timesheetRepo = timesheetRepo;
    }
}

