/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionSpecialService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionSpecialConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionSpecialDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionSpecialDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemFunctionSpecialServiceImpl
implements PrdSystemFunctionSpecialService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFunctionSpecialServiceImpl.class);
    private final PrdSystemFunctionSpecialDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemFunctionSpecialVO insert(PrdSystemFunctionSpecialPayload payload) {
        payload.setSpecialUrl(payload.getSpecialUrl().trim().toLowerCase());
        PrdSystemFunctionSpecialVO vo = this.dao.specialInspect(payload.getSpecialUrl());
        if (vo == null) {
            PrdSystemFunctionSpecialDO ado = PrdSystemFunctionSpecialConvert.INSTANCE.toDo(payload);
            this.dao.save(ado);
            this.cacheUtil.loadSystemFunctionSpecialCache();
            return PrdSystemFunctionSpecialConvert.INSTANCE.toVo(ado);
        }
        throw TwException.error("", "\u540e\u7aef\u63a5\u53e3\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional
    public Long update(PrdSystemFunctionSpecialPayload payload) {
        payload.setSpecialUrl(payload.getSpecialUrl().trim().toLowerCase());
        PrdSystemFunctionSpecialVO vo = this.dao.specialInspect(payload.getSpecialUrl());
        if (vo == null) {
            this.dao.updateByKeyDynamic(payload);
            this.cacheUtil.loadSystemFunctionSpecialCache();
            return 0L;
        }
        if (payload.getId().equals(vo.getId())) {
            this.dao.updateByKeyDynamic(payload);
            this.cacheUtil.loadSystemFunctionSpecialCache();
            return 0L;
        }
        throw TwException.error("", "\u540e\u7aef\u63a5\u53e3\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadSystemFunctionSpecialCache();
        return true;
    }

    public PagingVO<PrdSystemFunctionSpecialVO> paging(PrdSystemFunctionSpecialQuery query) {
        return this.dao.queryPaging(query);
    }

    public PrdSystemFunctionSpecialVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public List<PrdSystemFunctionSpecialVO> queryList(PrdSystemFunctionSpecialQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public PrdSystemFunctionSpecialServiceImpl(PrdSystemFunctionSpecialDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

