/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.TServerApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.service.TServerApplyServiceImpl;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SERVER_APPLY/callBack"})
@Transactional
public class TServerApplyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(TServerApplyWorkflowCallBackController.class);
    private final TServerApplyServiceImpl serverApplyService;
    private final TServerApplyDAO serverApplyDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TServerApplyPayload serverApplyPayload = new TServerApplyPayload();
        serverApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        TServerApplyVO tServerApplyVO = this.serverApplyService.queryByKey(Long.valueOf(businessKey));
        if (tServerApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.INVALID.getCode());
                    serverApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    serverApplyPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.serverApplyDAO.updateByKeyDynamic(serverApplyPayload);
        }
        return WorkflowResult.success(null);
    }

    public TServerApplyWorkflowCallBackController(TServerApplyServiceImpl serverApplyService, TServerApplyDAO serverApplyDAO) {
        this.serverApplyService = serverApplyService;
        this.serverApplyDAO = serverApplyDAO;
    }
}

