package com.elitesland.tw.tw5.server.common;

import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class TWExceptionHandler {

    @ExceptionHandler(TwException.class)
    @ResponseBody
    public TwOutputUtil exceptionHandler(TwException exception) {
        return TwOutputUtil.addTwException(exception);
    }

    @ExceptionHandler(NotOnlineException.class)
    @ResponseBody
    public TwOutputUtil notOnlineExceptionHandler(NotOnlineException exception) {
        return TwOutputUtil.addNotOnlineException(exception);
    }

}
