package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRulePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigRuleService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigRuleConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigRuleDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigRuleDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRuleRepo;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeConfigRuleServiceImpl extends BaseServiceImpl implements BusinessDocTypeConfigRuleService {

    private final BusinessDocTypeConfigRuleRepo businessDocTypeConfigRuleRepo;
    private final BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO;
    private final YeedocService yeedocService;
    private final BusinessDocTypeConfigService businessDocTypeConfigService;
    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;

    @Override
    public PagingVO<BusinessDocTypeConfigRuleVO> queryPaging(BusinessDocTypeConfigRuleQuery query) {
        // 校验
        checkQuery(query);
        return businessDocTypeConfigRuleDAO.queryPaging(query);
    }

    /**
     * 检查查询
     *
     * @param query 查询
     */
    private void checkQuery(BusinessDocTypeConfigRuleQuery query) {
        if (ObjectUtils.isEmpty(query.getConfigId())) {
            throw TwException.error("", "configId 不能为空");
        }
    }

    @Override
    public List<BusinessDocTypeConfigRuleVO> queryListDynamic(BusinessDocTypeConfigRuleQuery query) {
        // 校验
        checkQuery(query);
        return businessDocTypeConfigRuleDAO.queryListDynamic(query);
    }

    @Override
    public Long count(BusinessDocTypeConfigRuleQuery query) {
        return businessDocTypeConfigRuleDAO.count(query);
    }

    @Override
    public Long checkUnique(Long configId) {
        return businessDocTypeConfigRuleDAO.checkUnique(configId);
    }

    @Override
    public BusinessDocTypeConfigRuleVO queryByKey(Long key) {
        BusinessDocTypeConfigRuleDO entity = businessDocTypeConfigRuleRepo.findById(key).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull(entity.getId(), "文档类型配置规则不存在");
        BusinessDocTypeConfigRuleVO vo = BusinessDocTypeConfigRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigRuleVO insert(BusinessDocTypeConfigRulePayload payload) {
        // 校验
        check(payload);
        // 初始化
        initData(payload);
        BusinessDocTypeConfigRuleDO entityDo = BusinessDocTypeConfigRuleConvert.INSTANCE.toDo(payload);
        BusinessDocTypeConfigRuleDO save = businessDocTypeConfigRuleRepo.save(entityDo);

        String path = save.getPath();
        // 填写路径的话 才创建目录
        if (org.springframework.util.StringUtils.hasText(path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }

            Map<String, Object> hashMap = new HashMap();
            List<String> pathArry = new ArrayList<>();
            pathArry.add(path);
            hashMap.put("LibraryId", save.getLibraryId());
            //hashMap.put("libraryId","02c32947-5751-4578-9c37-c1ac99593af2");
            hashMap.put("PathArry", pathArry);
            String resultStr = yeedocService.createFolder(hashMap);
            if (StringUtils.isEmpty(resultStr)) {
                throw TwException.error("", "易道壳返回为空！");
            }
            Object data;
            try {
                JSONObject resultJson = JSONObject.parseObject(resultStr);
                data = resultJson.get("Data");
            } catch (Exception e) {
                log.error("易道壳创建文件夹失败!resultStr = {" + resultStr + "}", e);
                throw TwException.error("", "易道壳创建文件夹失败!result = {" + resultStr + "}");
            }
            if (ObjectUtils.isEmpty(data)) {
                throw TwException.error("", "易道壳创建文件夹失败!result = {" + resultStr + "}");
            }
            JSONArray arrayDate = JSONArray.parseArray(data.toString());
            String itemId = "";

            for (int i = 0; i < arrayDate.size(); i++) {
                JSONObject jsonObject = JSONObject.parseObject(arrayDate.get(i).toString());
                // 取最后一级目录
                itemId = (String) jsonObject.get("FolderId");
            }
            if (StringUtils.isEmpty(itemId)) {
                throw TwException.error("", "易道壳创建文件夹失败，返回itemId为空!result = {" + resultStr + "}");
            }
            save.setItemId(itemId);
            // 事务走完 会自动更新
        }
        return BusinessDocTypeConfigRuleConvert.INSTANCE.toVo(save);
    }

    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(BusinessDocTypeConfigRulePayload payload) {
        if (ObjectUtils.isEmpty(payload.getConditions())) {
            payload.setConditions("=");
        }

        if (ObjectUtils.isEmpty(payload.getSortNo())) {
            payload.setSortNo(0);
        }

        if (!ObjectUtils.isEmpty(payload.getConfigId())) {
            BusinessDocTypeConfigVO businessDocTypeConfigVO = businessDocTypeConfigService.queryByKey(payload.getConfigId());
            payload.setConfigCode(businessDocTypeConfigVO.getCode());
            payload.setConfigName(businessDocTypeConfigVO.getName());
            payload.setFunctionId(businessDocTypeConfigVO.getFunctionId());
            payload.setTableId(businessDocTypeConfigVO.getTableId());
            // payload.setFieldId(businessDocTypeConfigVO.getFieldId());
        }

        if (!ObjectUtils.isEmpty(payload.getTableId())) {
            BusinessTableVO businessTableVO = businessTableService.queryByKey(payload.getTableId());
            payload.setTableName(businessTableVO.getTableName());
        }
        if (!ObjectUtils.isEmpty(payload.getFieldId())) {
            BusinessTableFieldsVO businessTableFieldsVO = businessTableFieldsService.queryByKey(payload.getFieldId());
            payload.setFieldShowName(businessTableFieldsVO.getShowName());
        }
        // 兼容处理路径
        if (!ObjectUtils.isEmpty(payload.getPath())) {
            if (!payload.getPath().startsWith("/")) {
                payload.setPath("/" + payload.getPath());
            }
        }


    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(BusinessDocTypeConfigRulePayload payload) {
        if (ObjectUtils.isEmpty(payload.getConfigId())) {
            throw TwException.error("", "configId 不能为空");
        }
        if (!ObjectUtils.isEmpty(payload.getFieldId())) {
            if (ObjectUtils.isEmpty(payload.getConditionsValue())) {
                log.error("conditionsValue 不能为空");
                throw TwException.error("", "存储规则值不能为空");
            }
        }
        if (ObjectUtils.isEmpty(payload.getLibraryId())) {
            throw TwException.error("", "请选择文档库");
        }

        if (!ObjectUtils.isEmpty(payload.getFieldId())) {
            // 校验重复性  configId 、fieldId 确认唯一
            BusinessDocTypeConfigRuleQuery query = new BusinessDocTypeConfigRuleQuery();
            query.setConfigId(payload.getConfigId());
            query.setFieldId(payload.getFieldId());
            query.setIdNe(payload.getId());
            query.setConditionsValue(payload.getConditionsValue());
            Long count = count(query);
            if (count > 0) {
                // throw TwException.error("", "configId 、fieldId 重复");
                throw TwException.error("", "条件重复，不可新增");
            }
        } else {
            // 校验重复性  configId 、fieldId 确认唯一
            Long count = checkUnique(payload.getConfigId());
            if (count > 0) {
                // throw TwException.error("", "configId 、fieldId 重复");
                throw TwException.error("", "条件重复，不可新增");
            }
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigRuleVO update(BusinessDocTypeConfigRulePayload payload) {
        BusinessDocTypeConfigRuleDO entity = businessDocTypeConfigRuleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull(entity.getId(), "文档类型配置规则不存在");
        BusinessDocTypeConfigRuleDO entityDo = BusinessDocTypeConfigRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigRuleConvert.INSTANCE.toVo(businessDocTypeConfigRuleRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeConfigRulePayload payload) {
        BusinessDocTypeConfigRuleDO entity = businessDocTypeConfigRuleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull(entity.getId(), "文档类型配置规则不存在");
        long result = businessDocTypeConfigRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeConfigRuleDAO.deleteSoft(keys);

            // if (keys.size() > 1) {
            //     throw TwException.error("", "不支持批量删除");// 易道壳没有批量删除
            // }
            // keys.stream().forEach(id -> {
            //     Optional<BusinessDocTypeConfigRuleDO> optional = businessDocTypeConfigRuleRepo.findById(id);
            //     if (!optional.isEmpty()) {
            //         BusinessDocTypeConfigRuleDO entity = optional.get();
            //
            //         String deleteResult = yeedocService.deleteItem(entity.getItemId());
            //         if (StringUtils.isEmpty(deleteResult)) {
            //             throw TwException.error("", "易道壳返回为空!");
            //         }
            //         if (JSONObject.parseObject(deleteResult).getIntValue("Code") != 0) {
            //             log.error("易道壳删除出错,deleteResult = {" + deleteResult + "}");
            //             throw TwException.error("", "易道壳删除异常，请联系管理员");
            //         } else {
            //             businessDocTypeConfigRuleRepo.save(entity);
            //         }
            //
            //     }
            // });
        }
    }

}
