package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeUploadRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeUploadRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeUploadRecordService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeUploadRecordVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeUploadRecordConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeUploadRecordDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeUploadRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeUploadRecordRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 通用文档-文档上传标记
 *
 * @author duwh
 * @date 2023-12-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeUploadRecordServiceImpl extends BaseServiceImpl implements BusinessDocTypeUploadRecordService {

    private final BusinessDocTypeUploadRecordRepo businessDocTypeUploadRecordRepo;
    private final BusinessDocTypeUploadRecordDAO businessDocTypeUploadRecordDAO;

    @Override
    public PagingVO<BusinessDocTypeUploadRecordVO> queryPaging(BusinessDocTypeUploadRecordQuery query) {
        return businessDocTypeUploadRecordDAO.queryPaging(query);
    }

    @Override
    public Long count(BusinessDocTypeUploadRecordQuery query) {
        return businessDocTypeUploadRecordDAO.count(query);
    }

    @Override
    public List<BusinessDocTypeUploadRecordVO> queryListDynamic(BusinessDocTypeUploadRecordQuery query) {
        return businessDocTypeUploadRecordDAO.queryListDynamic(query);
    }

    @Override
    public BusinessDocTypeUploadRecordVO queryByKey(Long key) {
        BusinessDocTypeUploadRecordDO entity = businessDocTypeUploadRecordRepo.findById(key).orElseGet(BusinessDocTypeUploadRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeUploadRecordVO vo = BusinessDocTypeUploadRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeUploadRecordVO insert(BusinessDocTypeUploadRecordPayload payload) {
        // 必填校验
        if (ObjectUtils.isEmpty(payload.getDocType())) {
            log.error("单据类型[docType]不能为空");
            throw TwException.error("", "单据类型不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getDocId())) {
            log.error("单据主键[docId]不能为空");
            throw TwException.error("", "单据主键不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getConfigId())) {
            log.error("文档类型配置主键[configId]不能为空");
            throw TwException.error("", "文档类型配置主键不能为空");
        }

        // 重复校验
        BusinessDocTypeUploadRecordQuery query = new BusinessDocTypeUploadRecordQuery();
        query.setDocType(payload.getDocType());
        query.setDocId(payload.getDocId());
        query.setConfigId(payload.getConfigId());
        List<BusinessDocTypeUploadRecordVO> list = queryListDynamic(query);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        BusinessDocTypeUploadRecordDO entityDo = BusinessDocTypeUploadRecordConvert.INSTANCE.toDo(payload);
        return BusinessDocTypeUploadRecordConvert.INSTANCE.toVo(businessDocTypeUploadRecordRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeUploadRecordVO update(BusinessDocTypeUploadRecordPayload payload) {
        BusinessDocTypeUploadRecordDO entity = businessDocTypeUploadRecordRepo.findById(payload.getId()).orElseGet(BusinessDocTypeUploadRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeUploadRecordDO entityDo = BusinessDocTypeUploadRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeUploadRecordConvert.INSTANCE.toVo(businessDocTypeUploadRecordRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeUploadRecordPayload payload) {
        BusinessDocTypeUploadRecordDO entity = businessDocTypeUploadRecordRepo.findById(payload.getId()).orElseGet(BusinessDocTypeUploadRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeUploadRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeUploadRecordDAO.deleteSoft(keys);
        }
    }

}
