package com.elitesland.tw.tw5.server.common.permission;

import cn.zhxu.bs.BeanSearcher;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.service.PermissionRuleService;

/**
 * 权限控制 BeanSearcher 工厂
 *
 * @author : JS
 * @date 2023/09/25
 */
public class PermissionBeanSearcherFactory {
    private final BeanSearcher beanSearcher;
    private final PermissionRuleService permissionRuleService;

    public PermissionBeanSearcherFactory(BeanSearcher beanSearcher, PermissionRuleService permissionRuleService) {
        this.beanSearcher = beanSearcher;
        this.permissionRuleService = permissionRuleService;
    }

    /**
     * 获取默认 BeanSearcher
     *
     * @return BeanSearcher
     */
    public BeanSearcher getBeanSearcherService() {
        return beanSearcher;
    }

    /**
     * 获取权限控制 BeanSearcher
     *
     * @param permissionDomain 业务对象类型
     * @return 权限控制 BeanSearcher
     */
    public BeanSearcher getBeanSearcherService(PermissionDomainEnum permissionDomain) {
        return new PermissionBeanSearcher(beanSearcher, permissionRuleService, permissionDomain.name());
    }

}
