package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.common.permission.contants.PermissionContants.ADMIN;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 13:45
 **/
@Service(value = "BUSINESS_OBJECT_TYPE_FIELD_ROLES_AND_ALL_UPPER_LEVEL_USERS")
@RequiredArgsConstructor
public class BusinessObjectTypeFieldRolesAndAllLevelUsers implements BusinessObjectTypeStrategyService {

    @Lazy
    @Autowired
    private PrdOrgEmployeeService prdOrgEmployeeService;

    /**
     * 字段角色及所有上级用户
     *
     * @param rule
     * @param mapBuilder
     * @param ruleGroupExprList
     * @param loginUserId
     * @param defaultOrgId
     * @param childOrgIdSet
     * @param map
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, Map<String, Object> map) {

        // 获取当前人的所有上级
        List<PrdOrgEmployeeRefVO> orgEmployeeRefVOS = prdOrgEmployeeService.queryAllParentUsers(null, loginUserId);

        // 如果发现直属上级为空 直接给权限
        if (CollectionUtils.isEmpty(orgEmployeeRefVOS)) {
            map.put(ADMIN, true);
            return true;
        }

        Set<Long> frontEmployeeSet = orgEmployeeRefVOS.stream().map(PrdOrgEmployeeRefVO::getUserId).collect(Collectors.toSet());

        // 发现需要权限管控 加入到分组中
        mapBuilder.group(rule.getRuleCode());

        // 加入自己
        frontEmployeeSet.add(loginUserId);

        // 查询这些直属下级
        mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()), frontEmployeeSet).op(FieldOps.InList);

        return true;
    }

}
