package com.elitesland.tw.tw5.server.common.workFlow;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface TwWorkflowEventAnnotation {
    // 事件名称
    String name();
    // 事件编号
    String code();
    // 事件范围类型COMMON：公共，BUSINESS：功能业务
    String scope() default "BUSINESS";
    // 主表名称,范围类型为BUSINESS时，必须指定
    String tableName() default "";
    // 事件参数
    String params() default "";
    // 事件说明
    String description() default "";
    // 是否启用
    boolean enabled() default true;
}
