package com.elitesland.tw.tw5.server.openapi.sso;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.elp.config.TwElpSpiProperties;
import com.elitesland.tw.tw5.server.elp.util.ElpSigner;
import com.elitesland.tw.tw5.server.elp.util.ElpUrlGenerator;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("e-learning学习平台SSO")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/elp")
@Slf4j
public class ElpSsoController {
    
    private final TwElpSpiProperties elpSpiProperties;

    @GetMapping("/sso/url")
    public TwOutputUtil ssoUrl() {
        try {
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            String email = loginUser.getEmail();
            String sign = ElpSigner.calculateSign("sso", elpSpiProperties.getAppSecret(),
                    elpSpiProperties.getCorpCode(), email, System.currentTimeMillis());
            return TwOutputUtil.ok(ElpUrlGenerator.generateSSOURL(email,
                    elpSpiProperties.getCorpCode(), sign));
        } catch (Exception te) {
            te.printStackTrace();
            return TwOutputUtil.error("未授权，不可以访问");
        }
    }

}
