package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingTitlePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingTitleQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingTitleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingTitleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销抬头校验
 *
 * @author zoey
 * @date 2024-05-14
 */
@Api(tags = "报销抬头校验")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSettingTitle")
@Slf4j
public class AccReimSettingTitleController {

private final AccReimSettingTitleService accReimSettingTitleService;

    /**
     * 报销抬头校验-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销抬头校验-新增")
    public TwOutputUtil<AccReimSettingTitleVO> insert(@RequestBody AccReimSettingTitlePayload payload){
         return TwOutputUtil.ok(accReimSettingTitleService.insert(payload));
    }

    /**
     * 报销抬头校验-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销抬头校验-更新")
    public TwOutputUtil<AccReimSettingTitleVO> update(@RequestBody AccReimSettingTitlePayload payload){
        return TwOutputUtil.ok(accReimSettingTitleService.update(payload));
    }

    /**
     * 报销抬头校验-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销抬头校验-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingTitlePayload payload){
        return TwOutputUtil.ok(accReimSettingTitleService.updateByKeyDynamic(payload));
    }

    /**
     * 报销抬头校验-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销抬头校验-主键查询")
    public TwOutputUtil<AccReimSettingTitleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingTitleService.queryByKey(key));
    }

    /**
     * 报销抬头校验-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销抬头校验-分页")
    public TwOutputUtil<PagingVO<AccReimSettingTitleVO>> paging(AccReimSettingTitleQuery query) {
        return TwOutputUtil.ok(accReimSettingTitleService.queryPaging(query));
    }

    /**
     * 报销抬头校验-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销抬头校验-查询列表")
    public TwOutputUtil<List<AccReimSettingTitleVO>> queryList(AccReimSettingTitleQuery query) {
        return TwOutputUtil.ok(accReimSettingTitleService.queryListDynamic(query));
    }

    /**
     * 报销抬头校验-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销抬头校验-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         accReimSettingTitleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 报销抬头校验-规则检查
     *
     * @param key 有效载荷
     * @param invoiceNo 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/ruleCheck/{key}")
    @ApiOperation("报销抬头校验-规则检查")
    public TwOutputUtil<AccReimSettingTitleVO> ruleCheck(@PathVariable Long key, String invoiceNo, Long reimUserId,Long expenseCompanyId){
        return null;
//        return TwOutputUtil.ok(accReimSettingTitleService.ruleCheck(key,invoiceNo,reimUserId,expenseCompanyId));
    }

}

