package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccFinancialSubjectPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccFinancialSubjectQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccFinancialSubjectVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccFinancialSubjectRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 会计科目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Repository
@RequiredArgsConstructor
public class AccFinancialSubjectDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccFinancialSubjectRepo repo;
    private final QAccFinancialSubjectDO qdo = QAccFinancialSubjectDO.accFinancialSubjectDO;
    private final QAccFinancialSubjectDO qdo0 = new QAccFinancialSubjectDO("accFinancialSubjectDO0");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccFinancialSubjectVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccFinancialSubjectVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 科目编号
                qdo.accCode,
                // 上级科目主键
                qdo.parentId,
                // 上级科目编号
                qdo.upperCode,
                // 科目行业
                qdo.accIndustrys,
                // 科目名称
                qdo.accName,
                // 科目简称
                qdo.accAbbr,
                // 科目状态
                qdo.accStatus,
                // 科目级别
                qdo.accLevel,
                // 汇总科目（0：否，1：是）
                qdo.sumFlag,
                // 明细账
                qdo.dtlAcc,
                // 处理码
                qdo.procCode,
                // 子账标记
                qdo.ledgerFlag,
                // 子账类型
                qdo.ledgerType,
                // 大类
                qdo.accType1,
                // 明细类1
                qdo.accType2,
                // 明细类2
                qdo.accType3,
                // 类别1
                qdo.accCat1,
                // 类别2
                qdo.accCat2,
                // 类别3
                qdo.accCat3,
                // 类别4
                qdo.accCat4,
                // 类别5
                qdo.accCat5,
                // 账套名称
                qdo.accsetName,
                // 借贷类型
                qdo.drcrType,
                //上级名称
                qdo0.accName.as("parentName")
        )).from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccFinancialSubjectVO> getJpaQueryWhere(AccFinancialSubjectQuery query) {
        JPAQuery<AccFinancialSubjectVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccFinancialSubjectQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccFinancialSubjectQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            list.add(qdo.id.in(query.getIdList()));
        }
        /** 科目编号 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCode())) {
            list.add(qdo.accCode.eq(query.getAccCode()));
        }
        /** 上级id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()).or(qdo.id.eq(query.getParentId())));
        }
        /** 上级科目编号 精确 */
        if (!ObjectUtils.isEmpty(query.getUpperCode())) {
            list.add(qdo.upperCode.eq(query.getUpperCode()));
        }
        /** 科目行业 精确 */
        if (!ObjectUtils.isEmpty(query.getAccIndustrys())) {
            list.add(qdo.accIndustrys.eq(query.getAccIndustrys()));
        }
        /** 科目名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getAccName())) {
            list.add(qdo.accName.like(SqlUtil.toSqlLikeString(query.getAccName())));
        }
        /** 科目简称 模糊 */
        if (!ObjectUtils.isEmpty(query.getAccAbbr())) {
            list.add(qdo.accAbbr.like(SqlUtil.toSqlLikeString(query.getAccAbbr())));
        }
        /** 科目状态 精确 */
        if (!ObjectUtils.isEmpty(query.getAccStatus())) {
            list.add(qdo.accStatus.eq(query.getAccStatus()));
        }
        /** 科目级别 精确 */
        if (!ObjectUtils.isEmpty(query.getAccLevel())) {
            list.add(qdo.accLevel.eq(query.getAccLevel()));
        }
        /** 汇总科目（0：否，1：是） 精确 */
        if (!ObjectUtils.isEmpty(query.getSumFlag())) {
            list.add(qdo.sumFlag.eq(query.getSumFlag()));
        }
        /** 明细账 精确 */
        if (!ObjectUtils.isEmpty(query.getDtlAcc())) {
            list.add(qdo.dtlAcc.eq(query.getDtlAcc()));
        }
        /** 处理码 精确 */
        if (!ObjectUtils.isEmpty(query.getProcCode())) {
            list.add(qdo.procCode.eq(query.getProcCode()));
        }
        /** 子账标记 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerFlag())) {
            list.add(qdo.ledgerFlag.eq(query.getLedgerFlag()));
        }
        /** 子账类型 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerType())) {
            list.add(qdo.ledgerType.eq(query.getLedgerType()));
        }
        /** 大类 精确 */
        if (!ObjectUtils.isEmpty(query.getAccType1())) {
            list.add(qdo.accType1.eq(query.getAccType1()));
        }
        /** 明细类1 精确 */
        if (!ObjectUtils.isEmpty(query.getAccType2())) {
            list.add(qdo.accType2.eq(query.getAccType2()));
        }
        /** 明细类2 精确 */
        if (!ObjectUtils.isEmpty(query.getAccType3())) {
            list.add(qdo.accType3.eq(query.getAccType3()));
        }
        /** 类别1 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCat1())) {
            list.add(qdo.accCat1.eq(query.getAccCat1()));
        }
        /** 类别2 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCat2())) {
            list.add(qdo.accCat2.eq(query.getAccCat2()));
        }
        /** 类别3 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCat3())) {
            list.add(qdo.accCat3.eq(query.getAccCat3()));
        }
        /** 类别4 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCat4())) {
            list.add(qdo.accCat4.eq(query.getAccCat4()));
        }
        /** 类别5 精确 */
        if (!ObjectUtils.isEmpty(query.getAccCat5())) {
            list.add(qdo.accCat5.eq(query.getAccCat5()));
        }
        /** 账套名称 精确 */
        if (!ObjectUtils.isEmpty(query.getAccsetName())) {
            list.add(qdo.accsetName.eq(query.getAccsetName()));
        }
        /** 借贷类型 精确 */
        if (!ObjectUtils.isEmpty(query.getDrcrType())) {
            list.add(qdo.drcrType.eq(query.getDrcrType()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccFinancialSubjectVO queryByKey(Long id) {
        JPAQuery<AccFinancialSubjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccFinancialSubjectVO> queryListDynamic(AccFinancialSubjectQuery query) {
        JPAQuery<AccFinancialSubjectVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccFinancialSubjectVO> queryPaging(AccFinancialSubjectQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccFinancialSubjectVO> jpaQuery = getJpaQueryWhere(query);
        List<AccFinancialSubjectVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccFinancialSubjectVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccFinancialSubjectDO save(AccFinancialSubjectDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccFinancialSubjectDO> saveAll(List<AccFinancialSubjectDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccFinancialSubjectPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 科目编号
        if (payload.getAccCode() != null) {
            update.set(qdo.accCode, payload.getAccCode());
        }
        // 上级科目主键
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 上级科目编号
        if (payload.getUpperCode() != null) {
            update.set(qdo.upperCode, payload.getUpperCode());
        }
        // 科目行业
        if (payload.getAccIndustrys() != null) {
            update.set(qdo.accIndustrys, payload.getAccIndustrys());
        }
        // 科目名称
        if (payload.getAccName() != null) {
            update.set(qdo.accName, payload.getAccName());
        }
        // 科目简称
        if (payload.getAccAbbr() != null) {
            update.set(qdo.accAbbr, payload.getAccAbbr());
        }
        // 科目状态
        if (payload.getAccStatus() != null) {
            update.set(qdo.accStatus, payload.getAccStatus());
        }
        // 科目级别
        if (payload.getAccLevel() != null) {
            update.set(qdo.accLevel, payload.getAccLevel());
        }
        // 汇总科目（0：否，1：是）
        if (payload.getSumFlag() != null) {
            update.set(qdo.sumFlag, payload.getSumFlag());
        }
        // 明细账
        if (payload.getDtlAcc() != null) {
            update.set(qdo.dtlAcc, payload.getDtlAcc());
        }
        // 处理码
        if (payload.getProcCode() != null) {
            update.set(qdo.procCode, payload.getProcCode());
        }
        // 子账标记
        if (payload.getLedgerFlag() != null) {
            update.set(qdo.ledgerFlag, payload.getLedgerFlag());
        }
        // 子账类型
        if (payload.getLedgerType() != null) {
            update.set(qdo.ledgerType, payload.getLedgerType());
        }
        // 大类
        if (payload.getAccType1() != null) {
            update.set(qdo.accType1, payload.getAccType1());
        }
        // 明细类1
        if (payload.getAccType2() != null) {
            update.set(qdo.accType2, payload.getAccType2());
        }
        // 明细类2
        if (payload.getAccType3() != null) {
            update.set(qdo.accType3, payload.getAccType3());
        }
        // 类别1
        if (payload.getAccCat1() != null) {
            update.set(qdo.accCat1, payload.getAccCat1());
        }
        // 类别2
        if (payload.getAccCat2() != null) {
            update.set(qdo.accCat2, payload.getAccCat2());
        }
        // 类别3
        if (payload.getAccCat3() != null) {
            update.set(qdo.accCat3, payload.getAccCat3());
        }
        // 类别4
        if (payload.getAccCat4() != null) {
            update.set(qdo.accCat4, payload.getAccCat4());
        }
        // 类别5
        if (payload.getAccCat5() != null) {
            update.set(qdo.accCat5, payload.getAccCat5());
        }
        // 账套名称
        if (payload.getAccsetName() != null) {
            update.set(qdo.accsetName, payload.getAccsetName());
        }
        // 借贷类型
        if (payload.getDrcrType() != null) {
            update.set(qdo.drcrType, payload.getDrcrType());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 科目编号
            if (nullFields.contains("accCode")) {
                update.setNull(qdo.accCode);
            }
            // 上级科目主键
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 上级科目编号
            if (nullFields.contains("upperCode")) {
                update.setNull(qdo.upperCode);
            }
            // 科目行业
            if (nullFields.contains("accIndustrys")) {
                update.setNull(qdo.accIndustrys);
            }
            // 科目名称
            if (nullFields.contains("accName")) {
                update.setNull(qdo.accName);
            }
            // 科目简称
            if (nullFields.contains("accAbbr")) {
                update.setNull(qdo.accAbbr);
            }
            // 科目状态
            if (nullFields.contains("accStatus")) {
                update.setNull(qdo.accStatus);
            }
            // 科目级别
            if (nullFields.contains("accLevel")) {
                update.setNull(qdo.accLevel);
            }
            // 汇总科目（0：否，1：是）
            if (nullFields.contains("sumFlag")) {
                update.setNull(qdo.sumFlag);
            }
            // 明细账
            if (nullFields.contains("dtlAcc")) {
                update.setNull(qdo.dtlAcc);
            }
            // 处理码
            if (nullFields.contains("procCode")) {
                update.setNull(qdo.procCode);
            }
            // 子账标记
            if (nullFields.contains("ledgerFlag")) {
                update.setNull(qdo.ledgerFlag);
            }
            // 子账类型
            if (nullFields.contains("ledgerType")) {
                update.setNull(qdo.ledgerType);
            }
            // 大类
            if (nullFields.contains("accType1")) {
                update.setNull(qdo.accType1);
            }
            // 明细类1
            if (nullFields.contains("accType2")) {
                update.setNull(qdo.accType2);
            }
            // 明细类2
            if (nullFields.contains("accType3")) {
                update.setNull(qdo.accType3);
            }
            // 类别1
            if (nullFields.contains("accCat1")) {
                update.setNull(qdo.accCat1);
            }
            // 类别2
            if (nullFields.contains("accCat2")) {
                update.setNull(qdo.accCat2);
            }
            // 类别3
            if (nullFields.contains("accCat3")) {
                update.setNull(qdo.accCat3);
            }
            // 类别4
            if (nullFields.contains("accCat4")) {
                update.setNull(qdo.accCat4);
            }
            // 类别5
            if (nullFields.contains("accCat5")) {
                update.setNull(qdo.accCat5);
            }
            // 账套名称
            if (nullFields.contains("accsetName")) {
                update.setNull(qdo.accsetName);
            }
            // 借贷类型
            if (nullFields.contains("drcrType")) {
                update.setNull(qdo.drcrType);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据编号或者名称查询
     *
     * @param accCode
     * @param accName
     * @return
     */
    public List<Long> queryByCodeAndName(String accCode, String accName) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).
                where(qdo.accCode.eq(accCode).and(qdo.accName.eq(accName)));
        return jpaQuery.fetch();
    }
}

