package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description
 * @Date 2023/11/22
 */
@Entity
@Table(name = "acc_reim_detail", indexes = {
        @Index(name = "idx_mas_id", columnList = "mas_id"),
        @Index(name = "idx_bus_acc_item_id", columnList = "bus_acc_item_id"),
        @Index(name = "idx_budget_item_id", columnList = "budget_item_id"),
        @Index(name = "idx_fin_acc_subj_id", columnList = "fin_acc_subj_id"),
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_detail", comment = "报销单明细表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimDetailDO extends BaseModel implements Serializable {

    @Comment("报销单ID")
    @Column(name = "mas_id")
    private Long masId;

    @Comment("费用发生日期")
    @Column()
    private LocalDate expenseDate;

    @Comment("费用发生地")
    @Column()
    private String expensePlace;

    @Comment("核算项目")
    @Column(name = "bus_acc_item_id")
    private Long busAccItemId;

    @Comment("预算项目")
    @Column(name = "budget_item_id")
    private Long budgetItemId;

    @Comment("会计科目")
    @Column(name = "fin_acc_subj_id")
    private Long finAccSubjId;

    @Comment("报销说明")
    @Column()
    private String reimRemark;

    @Comment("报销金额(含税)")
    @Column()
    private BigDecimal reimAmt;

    /**
     * 折扣（0~10）
     */
    @Comment("折扣（0~10）")
    @Column()
    private BigDecimal invLimit;

    @Comment("明细调整后费用")
    @Column()
    private BigDecimal adjustAmt;

    @Comment("连号发票列表")
    @Column()
    private String continuousInvoiceNos;

    @Comment("提醒文本")
    @Column()
    private String remindText;

    @Comment("报错警告文本")
    @Column()
    private String errorText;

    /**
     * 报销额度
     */
    @Comment("报销额度")
    @Column()
    private BigDecimal reimLimit;

    /**
     * 超额
     */
    @Comment("超额")
    @Column()
    private Boolean excessLimit;

    /**
     * 抬头不一致
     */
    @Comment("抬头不一致")
    @Column()
    private Boolean notEqualFlag;

    @Comment("逾期报销配置id")
    @Column()
    private Long reimSettingOverdueId;

    @Comment("连号报销配置id")
    @Column()
    private Long reimSettingContinousId;

    @Comment("报销住宿额度配置id")
    @Column()
    private Long reimSettingLimitId;

    @Comment("发票抬头配置id")
    @Column()
    private Long reimSettingTitleId;

    @Comment("城市级别")
    @Column()
    private String expensePlaceGrade;

    @Comment("支付币种")
    @Column()
    private String currCode;

    @Comment("增值税税率")
    @Column()
    private BigDecimal taxRate;

    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;

    @Comment("外币业务")
    @Column()
    private Boolean foreignCurrencyFlag;

    @Comment("原币币种")
    @Column()
    private String originalCurrency;

    @Comment("汇率")
    @Column()
    private BigDecimal exchangeRate;

    @Comment("原币币额")
    @Column()
    private BigDecimal originalCurrencyAmt;

    @Comment("本币币额")
    @Column()
    private BigDecimal baseCurrencyAmt;

    @Comment("发票张数")
    @Column()
    private Integer invoiceNum;

    @Comment("发票金额")
    @Column()
    private BigDecimal invAmt;

    @Comment("无发票原因")
    @Column()
    private String noinvReason;

    @Comment("规则检查结果")
    @Column()
    private String checkResult;

    @Comment("计算金额来源ID")
    @Column()
    private Long calcAmtSourceId;

    @Comment("费用承担人")
    @Column()
    private String costPayers;

    @Comment("事由类型")
    @Column()
    private String reasonDetailType;

    @Comment("事由id")
    @Column()
    private Long reasonDetailId;

    @Comment("事由名称")
    @Column()
    private String reasonDetailName;

    public void copy(AccReimDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
