package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Entity
@Table(name = "acc_reim_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting", comment = "报销配置主表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingDO extends BaseModel implements Serializable  {
    /** 规则名称 */
    @Comment("规则名称")
    @Column()
    private String ruleName;
    /** 状态:1 有效；0 无效 */
    @Comment("状态:1 有效；0 无效")
    @Column()
    private Integer effective;
    /** 报销单据类型,udc:ACC:REIM_PROC_KEY */
    @Comment("报销单据类型,udc:ACC:REIM_PROC_KEY")
    @Column()
    private String reimDocType;
    /** 核算项目 */
    @Comment("核算项目")
    @Column()
    private String busAccItemId;
    /** 适用公司 */
    @Comment("适用公司")
    @Column()
    private String expenseCompany;
    /** 适用范围 */
    @Comment("适用范围")
    @Column()
    private String applicationScope;
    /** 适用资源 */
    @Comment("适用资源")
    @Column()
    private String applicationSource;
    /** 例外人员 */
    @Comment("例外人员")
    @Column()
    private String whiteList;
    /** 提醒等级（0警告，1报错） */
    @Comment("提醒等级（0警告，1报错）")
    @Column()
    private Integer remindLevel;
    /** 是否执行规则 0 不执行 1执行 */
    @Comment("是否执行规则 0 不执行 1执行")
    @Column()
    private Integer executeFlag;
    /** 是否高亮 0 不高亮 1高亮 */
    @Comment("是否高亮 0 不高亮 1高亮")
    @Column()
    private Integer highlightFlag;
    /** 高亮颜色 */
    @Comment("高亮颜色")
    @Column()
    private String highlightColor;
    /** 提醒文本 */
    @Comment("提醒文本")
    @Column()
    private String remindText;
    /** 报错警告文本 */
    @Comment("报错警告文本")
    @Column()
    private String errorText;

    /**
     * 报销配置类型
     */
    @Comment("报销配置类型")
    @Column()
    private String reimSettingType;

    /**
     * 具体的报销配置id
     */
    @Comment("具体的报销配置id")
    @Column()
    private Long specificReimSettingId;

    public void copy(AccReimSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
