package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateDetailService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccSubjectTemplateDetailConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccSubjectTemplateDetailDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccSubjectTemplateDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccSubjectTemplateDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccSubjectTemplateDetailServiceImpl extends BaseServiceImpl implements AccSubjectTemplateDetailService {

    private final AccSubjectTemplateDetailRepo accSubjectTemplateDetailRepo;
    private final AccSubjectTemplateDetailDAO accSubjectTemplateDetailDAO;

    @Override
    public List<AccSubjectTemplateDetailVO> bacthInsert(List<AccSubjectTemplateDetailPayload> payloads, AccSubjectTemplateVO accSubjectTemplateVO) {
        List<Long> collect = payloads.stream().filter(payload -> payload.getAccId() != null).map(AccSubjectTemplateDetailPayload::getBusinessId).distinct().collect(Collectors.toList());
        if (collect.size() < payloads.size()) {
            throw TwException.error("", "不可重复添加项目核算数据");
        }
        //查询已添加的科目ids,判断重复
        List<Long> businessIds = accSubjectTemplateDetailDAO.queryBusinessIdList(accSubjectTemplateVO.getId());
        if (!ObjectUtils.isEmpty(businessIds)) {
            payloads = payloads.stream().filter(payload -> payload.getId() != null || !businessIds.contains(payload.getBusinessId())).collect(Collectors.toList());
        }

        List<AccSubjectTemplateDetailDO> entityDos = AccSubjectTemplateDetailConvert.INSTANCE.toDos(payloads);
        accSubjectTemplateDetailDAO.saveAll(entityDos);
//        return AccSubjectTemplateDetailConvert.INSTANCE.toVo(accSubjectTemplateDetailRepo.save(entityDo));
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accSubjectTemplateDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByTemlIds(List<Long> temlIds) {
        accSubjectTemplateDetailDAO.deleteSoftByTemlIds(temlIds);
    }

    @Override
    public PagingVO<AccSubjectTemplateDetailVO> queryPaging(AccSubjectTemplateDetailQuery query) {
        return accSubjectTemplateDetailDAO.queryPaging(query);
    }

    @Override
    public List<AccSubjectTemplateDetailVO> queryListByTmplId(Long tmplId) {
        return accSubjectTemplateDetailDAO.queryListByTmplId(tmplId);
    }

    @Override
    public List<AccBudgetItemVO> queryBudgetItemList(Long tmplId) {

        return accSubjectTemplateDetailDAO.queryBudgetItemList(tmplId);
    }
}
