package com.elitesland.tw.tw5.server.prd.borrow.controller;

import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 出让申请
 *
 * @folder 出让申请
 * @author wangly
 * @date 2024-07-15
 */
@Api(tags = "出让申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/transferApply")
@Slf4j
public class TransferApplyController {

private final TransferApplyService transferApplyService;

    /**
     * 出让申请-新增
     *
     * @folder 出让申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("出让申请-新增")
    public TwOutputUtil<TransferApplyVO> insert(@RequestBody TransferApplyPayload payload){
         return TwOutputUtil.ok(transferApplyService.insert(payload));
    }

    /**
     * 出让申请-更新
     *
         * @folder 出让申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("出让申请-更新")
    public TwOutputUtil<TransferApplyVO> update(@RequestBody TransferApplyPayload payload){
        return TwOutputUtil.ok(transferApplyService.update(payload));
    }

    /**
     * 出让申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 出让申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("出让申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TransferApplyPayload payload){
        return TwOutputUtil.ok(transferApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 出让申请-主键查询
     *
     * @folder 出让申请
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("出让申请-主键查询")
    public TwOutputUtil<TransferApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(transferApplyService.queryByKey(key));
    }

    /**
     * 出让申请-分页
     *
         * @folder 出让申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("出让申请-分页")
    public TwOutputUtil<PagingVO<TransferApplyVO>> paging(TransferApplyQuery query) {
        return TwOutputUtil.ok(transferApplyService.queryPaging(query));
    }

    /**
     * 出让申请-查询列表
     *
     * @folder 出让申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("出让申请-查询列表")
    public TwOutputUtil<List<TransferApplyVO>> queryList(TransferApplyQuery query) {
        return TwOutputUtil.ok(transferApplyService.queryListDynamic(query));
    }

    /**
     * 出让申请-删除
     *
         * @folder 出让申请
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("出让申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         transferApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

