package com.elitesland.tw.tw5.server.prd.borrow.service;

import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.BorrowWriteOffRepo;
import com.elitesland.tw.tw5.server.prd.borrow.dao.BorrowWriteOffDAO;
import com.elitesland.tw.tw5.server.prd.borrow.convert.BorrowWriteOffConvert;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowWriteOffService;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowWriteOffPayload;
import com.elitesland.tw.tw5.server.prd.borrow.entity.BorrowWriteOffDO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.server.prd.borrow.convert.BorrowWriteOffConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 借款核销
 *
 * @author wangly
 * @date 2024-07-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BorrowWriteOffServiceImpl extends BaseServiceImpl implements BorrowWriteOffService {

    private final BorrowWriteOffRepo borrowWriteOffRepo;
    private final BorrowWriteOffDAO borrowWriteOffDAO;

    @Override
    public PagingVO<BorrowWriteOffVO> queryPaging(BorrowWriteOffQuery query){
        return borrowWriteOffDAO.queryPaging(query);
    }

    @Override
    public List<BorrowWriteOffVO> queryListDynamic(BorrowWriteOffQuery query){
        return borrowWriteOffDAO.queryListDynamic(query);
    }

    @Override
    public BorrowWriteOffVO queryByKey(Long key) {
        BorrowWriteOffDO entity = borrowWriteOffRepo.findById(key).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BorrowWriteOffVO vo = BorrowWriteOffConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BorrowWriteOffVO insert(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entityDo = BorrowWriteOffConvert.INSTANCE.toDo(payload);
        return BorrowWriteOffConvert.INSTANCE.toVo(borrowWriteOffRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BorrowWriteOffVO update(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entity = borrowWriteOffRepo.findById(payload.getId()).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BorrowWriteOffDO entityDo = BorrowWriteOffConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BorrowWriteOffConvert.INSTANCE.toVo(borrowWriteOffRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entity = borrowWriteOffRepo.findById(payload.getId()).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = borrowWriteOffDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            borrowWriteOffDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<BorrowMoneyVO> queryByReimId(Long reimId) {
        return borrowWriteOffDAO.queryByReimId(reimId);
    }

    @Override
    @Transactional
    public void deleteByReimId(Long reimId) {
        borrowWriteOffDAO.deleteByReimId(reimId);
    }

}
